                                                        ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require "rake/file_list"

# Load the test files from the command line.
argv = ARGV.select do |argument|
  case argument
  when /^-/ then
    argument
  when /\*/ then
    Rake::FileList[argument].to_a.each do |file|
      require File.expand_path file
    end

    false
  else
    path = File.expand_path argument

    abort "\nFile does not exist: #{path}\n\n" unless File.exist?(path)

    require path

    false
  end
end

ARGV.replace argv
                                   gems/gems/rake-13.0.6/lib/rake/file_utils_ext.rb                                                    0000644                 00000007532 15040313415 0015136 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
require "rake/file_utils"

module Rake
  #
  # FileUtilsExt provides a custom version of the FileUtils methods
  # that respond to the <tt>verbose</tt> and <tt>nowrite</tt>
  # commands.
  #
  module FileUtilsExt
    include FileUtils

    class << self
      attr_accessor :verbose_flag, :nowrite_flag
    end

    DEFAULT = Object.new

    FileUtilsExt.verbose_flag = DEFAULT
    FileUtilsExt.nowrite_flag = false

    FileUtils.commands.each do |name|
      opts = FileUtils.options_of name
      default_options = []
      if opts.include?("verbose")
        default_options << "verbose: FileUtilsExt.verbose_flag"
      end
      if opts.include?("noop")
        default_options << "noop: FileUtilsExt.nowrite_flag"
      end

      next if default_options.empty?
      module_eval(<<-EOS, __FILE__, __LINE__ + 1)
      def #{name}(*args, **options, &block)
        super(*args,
            #{default_options.join(', ')},
            **options, &block)
      end
      EOS
    end

    # Get/set the verbose flag controlling output from the FileUtils
    # utilities.  If verbose is true, then the utility method is
    # echoed to standard output.
    #
    # Examples:
    #    verbose              # return the current value of the
    #                         # verbose flag
    #    verbose(v)           # set the verbose flag to _v_.
    #    verbose(v) { code }  # Execute code with the verbose flag set
    #                         # temporarily to _v_.  Return to the
    #                         # original value when code is done.
    def verbose(value=nil)
      oldvalue = FileUtilsExt.verbose_flag
      FileUtilsExt.verbose_flag = value unless value.nil?
      if block_given?
        begin
          yield
        ensure
          FileUtilsExt.verbose_flag = oldvalue
        end
      end
      FileUtilsExt.verbose_flag
    en                                                                                                                                                                      gems/gems/rake-13.0.6/lib/rake/task_argument_error.rb                                               0000644                 00000000225 15040313415 0016164 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ess value.nil?
      if block_given?
        begin
          yield
        ensure
          FileUtilsExt.nowrite_flag = oldvalue
        end
      en                                                                                                                                                                                                                                                                                                                                                                           gems/gems/rake-13.0.6/lib/rake/file_task.rb                                                         0000644                 00000002777 15040313415 0014066 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        # +optdecl+.  An ArgumentError exception is thrown if non-declared
    # options are found.
    def rake_check_options(options, *optdecl)
      h = options.dup
      optdecl.each do |name|
        h.delete name
      end
      raise ArgumentError, "no such option: #{h.keys.join(' ')}" unless
        h.empty?
    end

    extend self
  end
end
                                                                                                                                                                      gems/gems/rake-13.0.6/lib/rake/task_argument_error.rb                                               0000644                 00000000225 15040313415 0016164 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
module Rake

  # Error indicating an ill-formed task declaration.
  class TaskArgumentError < ArgumentError
  end

end
                                                                                                                                                                                                                                                                                                                                                                           gems/gems/rake-13.0.6/lib/rake/backtrace.rb                                                         0000644                 00000001600 15040313415 0014024 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
require "rake/task"
require "rake/early_time"

module Rake

  # A FileTask is a task that includes time based dependencies.  If any of a
  # FileTask's prerequisites have a timestamp that is later than the file
  # represented by this task, then the file must be rebuilt (using the
  # supplied actions).
  #
  class FileTask < Task

    # Is this file task needed?  Yes if it doesn't exist, or if its time stamp
    # is out of date.
    def needed?
      !File.exist?(name) || out_of_date?(timestamp) || @application.options.build_all
    end

    # Time stamp for file task.
    def timestamp
      if File.exist?(name)
        File.mtime(name.to_s)
      else
        Rake::LATE
      end
    end

    private

    # Are there any prerequisites with a later time than the given time stamp?
    def out_of_date?(stamp)
      all_prerequisite_tasks.any? { |prereq|                                                                                                                                gems/gems/rake-13.0.6/lib/rake/late_time.rb                                                         0000644                 00000000447 15040313415 0014060 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems