   lambda { |value|
              options.trace = true
              options.backtrace = true
              select_trace_output(options, "trace", value)
              Rake.verbose(true)
            }
          ],
          ["--verbose", "-v",
            "Log message to standard output.",
            lambda { |value| Rake.verbose(true) }
          ],
          ["--version", "-V",
            "Display the program version.",
            lambda { |value|
              puts "rake, version #{Rake::VERSION}"
              exit
            }
          ],
          ["--where", "-W [PATTERN]",
            "Describe the tasks (matching optional PATTERN), then exit.",
            lambda { |value|
              select_tasks_to_show(options, :lines, value)
              options.show_all_tasks = true
            }
          ],
          ["--no-deprecation-warnings", "-X",
            "Disable the deprecation warnings.",
            lambda { |value|
              options.ignore_deprecate = true
            }
          ],
        ])
    end

    def select_tasks_to_show(options, show_tasks, value) # :nodoc:
      options.show_tasks = show_tasks
      options.show_task_pattern = Regexp.new(value || "")
      Rake::TaskManager.record_task_metadata = true
    end
    private :select_tasks_to_show

    def select_trace_output(options, trace_option, value) # :nodoc:
      value = value.strip unless value.nil?
      case value
      when "stdout"
  