          when /\d/    then :NUMBER
                     else
                       raise ParseError, "BUG token #{list_label}"
                     end
                   [list_type, list_label, *pos]
                 # [text] followed by spaces or end of line => :LABEL
                 when @s.scan(/\[(.*?)\]( +|\r?$)/) then
                   [:LABEL, @s[1], *pos]
                 # text:: followed by spaces or end of line => :NOTE
                 when @s.scan(/(.*?)::( +|\r?$)/) then
                   [:NOTE, @s[1], *pos]
                 # >>> followed by end of line => :BLOCKQUOTE
                 when @s.scan(/>>> *(\w+)?$/) then
                   if word = @s[1]
                     @s.unscan(word)
                   end
                   [:BLOCKQUOTE, word, *pos]
                 # anything else: :TEXT
                 else
                   @s.scan(/(.*?)(  )?\r?$/)
                   token = [:TEXT, @s[1], *pos]

                   if @s[2] then
                     @tokens << token
                     [:BREAK, @s[2], pos[0] + @s[1].length, pos[1]]
                   else
                     token
                   end
                 end
    end

    self
  end

  ##
  # Returns the current token to the token stream

  def unget
    token = @current_token
    p :unget => token if @debug
    raise Error, 'too many #ungets' if token == @tokens.first
    @tokens.unshift token if token
  end

end
                                                                                                  gems/gems/rdoc-6.5.1.1/lib/rdoc/erbio.rb                                                            0000644                 00000002006 15040313412 0013276 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
require 'erb'

##
# A subclass of ERB that writes directly to an IO.  Credit to Aaron Patterson
# and Masatoshi SEKI.
#
# To use:
#
#   erbio = RDoc::ERBIO.new '<%= "hello world" %>', nil, nil
#
#   File.open 'hello.txt', 'w' do |io|
#     erbio.result binding
#   end
#
# Note that binding must enclose the io you wish to output on.

class RDoc::ERBIO < ERB

  ##
  # Defaults +eoutvar+ to 'io', otherwise is identical to ERB's initialize

  def initialize str, safe_level = nil, legacy_trim_mode = nil, legacy_eoutvar = 'io', trim_mode: nil, eoutvar: 'io'
    if RUBY_VERSION >= '2.6'
      super(str, trim_mode: trim_mode, eoutvar: eoutvar)
    else
      super(str, safe_level, legacy_trim_mode, legacy_eoutvar)
    end
  end

  ##
  # Instructs +compiler+ how to write to +io_variable+

  def set_eoutvar compiler, io_variable
    compiler.put_cmd    = "#{io_variable}.write"
    compiler.insert_cmd = "#{io_variable}.write"
    compiler.pre_cmd    = []
    compiler.post_cmd   = []
  end

end

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          gems/gems/rdoc-6.5.1.1/lib/rdoc/rd.rb                                                 