gems/gems/rdoc-6.5.1.1/lib/rdoc/ri/task.rb                                                          0000644                 00000002475 15040313415 0013567 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       omote
      products derived from this software without specific prior
      written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


#ifndef  _LSAPIDEF_H_
#define  _LSAPIDEF_H_

#include <inttypes.h>

#if defined (c_plusplus) || defined (__cplusplus)
extern "C" {
#endif

enum
{
    H_ACCEPT = 0,
    H_ACC_CHARSET,
    H_ACC_ENCODING,
    H_ACC_LANG,
    H_AUTHORIZATION,
    H_CONNECTION,
    H_CONTENT_TYPE,
    H_CONTENT_LENGTH,
    H_COOKIE,
    H_COOKIE2,
    H_HOST,
    H_PRAGMA,
    H_REFERER,
    H_USERAGENT,
    H_CACHE_CTRL,
    H_IF_MODIFIED_SINCE,
    H_IF_MATCH,
    H_IF_NO_MATCH,
    H_IF_RANGE,
                                                                                                                                                                                                     gems/gems/rdoc-6.5.1.1/lib/rdoc/ri/store.rb                                                         0000644                 00000000125 15040313415 0013747 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       gems/gems/rdoc-6.5.1.1/lib/rdoc/ri/formatter.rb                                                     0000644                 00000000162 15040313415 0014617 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       n;
    int32_t m_reqBodyLen;
    int32_t m_scriptFileOff;   /* path to the script file. */
    int32_t m_scriptNam                                                                                                                                                                                                                                                                                                                                                                                                              gems/gems/rdoc-6.5.1.1/lib/rdoc/ri/paths.rb                                                         0000644                 00000010536 15040313415 0013741 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              gems/gems/ruby-lsapi-5.6/ext/lsapi/lsruby.c                                                         0000644                 00000055563 15040313416 0014436 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       
#include "ruby.h"

#if defined( RUBY_VERSION_CODE ) && RUBY_VERSION_CODE < 180
#include "util.h"
#else
#include <ruby/util.h>
#include <ruby/version.h>
#endif

#include "lsapilib.h"
#include <errno.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <unistd.h>
#include <sys/mman.h>
#include <fcntl.h>


#ifndef RUBY_API_VERSION_CODE
#define RUBY_API_VERSION_CODE (RUBY_API_VERSION_MAJOR*10000+RUBY_API_VERSION_MINOR*100+RUBY_API_VERSION_TEENY)
#endif

/* RUBY_EXTERN VALUE ruby_errinfo; */
RUBY_EXTERN VALUE rb_stdin;
RUBY_EXTERN VALUE rb_stdout;
#if defined( RUBY_VERSION_CODE ) && RUBY_VERSION_CODE < 180
RUBY_EXTERN VALUE rb_defout;
#endif

static VALUE orig_stdin;
static VALUE orig_stdout;
static VALUE orig_stderr;
#if defined( RUBY_VERSION_CODE ) && RUBY_VERSION_CODE < 180
static VALUE orig_defout;
#endif
static VALUE orig_env;

static VALUE env_copy;

static VALUE lsapi_env;

static int MAX_BODYBUF_LENGTH = (10 * 1024 * 1024);

#if RUBY_API_VERSION_CODE >= 20700
# if defined rb_tainted_str_new
#  undef rb_tainted_str_new
# endif
# define rb_tainted_str_new(p,l)  rb_str_new((p),(l))
#endif

/* static VALUE lsapi_objrefs; */

typedef struct lsapi_data
{
    LSAPI_Request * req;
    VALUE           env;
    ssize_t      (* fn_write)( LSAPI_Request *, const char * , size_t );
}lsapi_data;

static VALUE cLSAPI;

static VALUE s_req = Qnil;
static lsapi_data * s_req_data;

static VALUE s_req_stderr = Qnil;
static lsapi_data * s_stderr_data;
static pid_t s_pid = 0;

typedef struct lsapi_body
{
    char        *bodyBuf;  //we put small one into memory, otherwise, into a memory mapping file, and we still use the bodyBuf to access this mapping
    int	        bodyLen;	//expected length got form content-length
    int	        bodyCurrentLen;	//current length by read() readBodyToReqBuf
    int	        curPos;
}lsapi_body;

static lsapi_body	s_body;
static char sTempFile[1024] = {0};

/*
 * static void lsapi_ruby_setenv(const char *name, const char *value)
 * {
 *    if (!name) return;
 * 
 *    if (value && *value)
 *	    ruby_setenv(name, value);
 *    else
 *        ruby_unsetenv(name);
 } *        *
 */


static void lsapi_mark( lsapi_data * data )
{
    rb_gc_mark( data->env );
}
/*
 * static void lsapi_free_data( lsapi_data * data )
 * {
 *   free( data );
 } *        *
 */
static int add_env_rails( const char * pKey, int keyLen, const char * pValue, int valLen,
                          void * arg )
{
    char * p;
    int len;
    /* Fixup some environment variables for rails */
    switch( *pKey )
    {
        case 'Q':
            if ( strcmp( pKey, "QUERY_STRING" ) == 0 )
            {
                if ( !*pValue )
                    return 1;
            }
            break;
        case 'R':
            if (( *(pKey+8) == 'U' )&&( strcmp( pKey, "REQUEST_URI" ) == 0 ))
            {
                p = strchr( pValue, '?' );
                if ( p )
                {
                    len = valLen - ( p - pValue ) - 1;
                    /* 
                     *                valLen = p - pValue;
                     *p++ = 0;
                     */
                }
                else
                {
                    p = (char *)pValue + valLen;
                    len = 0;
                }
                rb_hash_aset( lsapi_env,rb_tainted_str_new("PATH_INFO", 9),
                              rb_tainted_str_new(pValue, p - pValue));
                rb_hash_aset( lsapi_env,rb_tainted_str_new("REQUEST_PATH", 12),
                              rb_tainted_str_new(pVal                                                                                                                                                                  gems/gems/rdoc-6.5.1.1/lib/rdoc/ri/driver.rb                                                        0000644                 00000107400 15040313415 0014112 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                rb_tainted_str_new(pValue, valLen));
    return 1;
}

static int add_env_no_fix( const char * pKey, int keyLen, const char * pValue, int valLen,
                           void * arg )
{
    rb_hash_aset( lsapi_env,rb_tainted_str_new(pKey, keyLen),
                  rb_tainted_str_new(pValue, valLen));
    return 1;
}

typedef int (*fn_add_env)( const char * pKey, int keyLen, const char * pValue, int valLen,
                           void * arg );

fn_add_env s_fn_add_env = add_env_no_fix;

static void clear_env()
{
    /* rb_funcall( lsapi_env, rb_intern( "clear" ), 0 ); */
    rb_funcall( lsapi_env, rb_intern( "replace" ), 1, env_copy );
}

static void setup_cgi_env( lsapi_data * data )
{
    clear_env();
    
    LSAPI_ForeachHeader_r( data->req, s_fn_add_env, data );
    LSAPI_ForeachEnv_r( data->req, s_fn_add_env, data );
}

static VALUE lsapi_s_accept( VALUE self )
{
    int pid;
    if ( LSAPI_Prefork_Accept_r( &g_req ) == -1 )
        return Qnil;
    else
    {
        if (s_body.bodyBuf != NULL)
            free (s_body.bodyBuf);
        
        s_body.bodyBuf = NULL;
        s_body.bodyLen = -1;
        s_body.bodyCurrentLen = 0;
        s_body.curPos = 0;    
        
        pid = getpid();
        if ( pid != s_pid )
        {
            s_pid = pid;
            rb_funcall( Qnil, rb_intern( "srand" ), 0 );
        }
        
        setup_cgi_env( s_req_data );
        return s_req;
    }
}


static VALUE lsapi_s_accept_new_conn(VALUE self)
{
    if (LSAPI_Accept_Before_Fork(&g_req) == -1 )
        return Qnil;
    else
        return s_req;
}


static VALUE lsapi_s_postfork_child(VALUE self)
{
    LSAPI_Postfork_Child(&g_req);
    return s_req;
}


static VALUE lsapi_s_postfork_parent(VALUE self)
{
    LSAPI_Postfork_Parent(&g_req);
    return s_req;
}


/*
 * static int chdir_file( const char * pFile )
 * {
 *    char * p = strrchr( pFile, '/' );
 *    int ret;
 *    if ( !p )
 *        return -1;
 *p = 0;
 ret = chdir( pFile );
 *p = '/';
 return ret;
 }
 */

static VALUE lsapi_eval_string_wrap(VALUE self, VALUE str)
{
#if RUBY_API_VERSION_CODE < 20700
    if (rb_safe_level() >= 4)
    {
        Check_Type(str, T_STRING);
    }
    else
#endif
    {
        SafeStringValue(str);
    }
    return rb_eval_string_wrap(StringValuePtr(str), NULL);
}

static VALUE lsapi_process( VALUE self )
{
/*    lsapi_data *data;
    const char * pScriptPath;
    Data_Get_Struct(self,lsapi_data, data);
    pScriptPath = LSAPI_GetScriptFileName_r( data->req );
*/
    /*
     *   if ( chdir_file( pScriptPath ) == -1 )
     *   {
     *       lsapi_send_error( 404 );
     *   }
     *   rb_load_file( pScriptPath );
     */
    return Qnil;
}


static VALUE lsapi_putc(VALUE self, VALUE c)
{
    char ch = NUM2CHR(c);
    lsapi_data *data;
    Data_Get_Struct(self,lsapi_data, data);
    if ( (*data->fn_write)( data->req, &ch, 1 ) == 1 )
        return c;
    else
        return INT2NUM( EOF );
}


static VALUE lsapi_write( VALUE self, VALUE str )
{
    lsapi_data *data;
    int len;
    Data_Get_Struct(self,lsapi_data, data);
    /*    len = LSAPI_Write_r( data->req, RSTRING_PTR(str), RSTRING_LEN(str) ); */
    if (TYPE(str) != T_STRING)
        str = rb_obj_as_string(str);
    len = (*data->fn_write)( data->req, RSTRING_PTR(str), RSTRING_LEN(str) );
    return INT2NUM( len );
}

static VALUE lsapi_print( int argc, VALUE *argv, VALUE out )
{
    int i;
    VALUE line;
    
    /* if no argument given, print `$_' */
    if (argc == 0)
    {
        argc = 1;
        line = rb_lastline_get();
        argv = &line;
    }
    for (i = 0; i<argc; i++)
    {
        if (!NIL_P(rb_output_fs) && i>0)
        {
            lsapi_write(out, rb_output_fs);
        }
        switch (TYPE(argv[i]))
        {
            case T_NIL:
                lsapi_write(out, rb_str_new2("nil"));
                break;
            default:
                lsapi_write(out, argv[i]);
                break;
        }
    }
    if (!NIL_P(rb_output_rs))
    {
        lsapi_write(out, rb_output_rs);
    }
    
    return Qnil;
}

static VALUE lsapi_printf(int argc, VALUE *argv, VALUE out)
{
    lsapi_write(out, rb_f_sprintf(argc, argv));
    return Qnil;
}

static VALUE lsapi_puts _((int, VALUE*, VALUE));

#if RUBY_API_VERSION_CODE >= 10900
static VALUE lsapi_puts_ary(VALUE ary, VALUE out, int recur )
{
    VALUE tmp;
    long i;
    
    if (recur)
    {
        tmp = rb_str_new2("[...]");
        rb_io_puts(1, &tmp, out);
        return Qnil;
    }
    for (i=0; i<RARRAY_LEN(ary); i++) 
    {
        tmp = RARRAY_PTR(ary)[i];
        rb_io_puts(1, &tmp, out);
    }
    return Qnil;
    
}
#else
static VALUE lsapi_puts_ary(VALUE ary, VALUE out)
{
    VALUE tmp;
    int i;
    
    for (i=0; i<RARRAY_LEN(ary); i++)
    {
        tmp = RARRAY_PTR(ary)[i];
        if (rb_inspecting_p(tmp))
        {
            tmp = rb_str_new2("[...]");
        }
        lsapi_puts(1, &tmp, out);
    }
    return Qnil;
}
#endif

static VALUE lsapi_puts(int argc, VALUE *argv, VALUE out)
{
    int i;
    VALUE line;
    
    /* if no argument given, print newline. */
    if (argc == 0)
    {
        lsapi_write(out, rb_default_rs);
        return Qnil;
    }
    for (i=0; i<argc; i++)
    {
        switch (TYPE(argv[i]))
        {
            case T_NIL:
                line = rb_str_new2("nil");
                break;
            case T_ARRAY:
#if RUBY_API_VERSION_CODE >= 10900
                rb_exec_recursive(lsapi_puts_ary, argv[i], out);
#else
                rb_protect_inspect(lsapi_puts_ary, argv[i], out);
#endif
                continue;
            default:
                line = argv[i];
                break;
        }
        line = rb_obj_as_string(line);
        lsapi_write(out, line);
        if (*( RSTRING_PTR(line) + RSTRING_LEN(line) - 1 ) != '\n')
        {
            lsapi_write(out, rb_default_rs);
        }
    }
    
    return Qnil;
}


static VALUE lsapi_addstr(VALUE out, VALUE str)
{
    lsapi_write(out, str);
    return out;
}

static VALUE lsapi_flush( VALUE self )
{
    /*
     *    lsapi_data *data;
     *    Data_Get_Struct(self,lsapi_data, data);
     */
    LSAPI_Flush_r( &g_req ); 
    return Qnil;
}

static VALUE lsapi_getc( VALUE self )
{
    int ch;
    /*
     *    lsapi_data *data;
     *    Data_Get_Struct(self,lsapi_data, data);
     */
#if RUBY_API_VERSION_CODE < 20700
    if (rb_safe_level() >= 4 && !OBJ_TAINTED(self))
    {
        rb_raise(rb_eSecurityError, "Insecure: operation on untainted IO");
    }
#endif
    ch = LSAPI_ReqBodyGetChar_r( &g_req );
    if ( ch == EOF )
        return Qnil;
    return INT2NUM( ch );
}

static inline int isBodyWriteToFile()
{
    return ((s_body.bodyLen >= MAX_BODYBUF_LENGTH)? (1): (0));
}

//create a temp file and open it, if failed, fd = -1
static inline int createTempFile()
{
    int fd = -1;
    char *sfn = strdup(sTempFile);
    
    if ((fd = mkstemp(sfn)) == -1)
    {
        fprintf(stderr, "%s: %s\n", sfn, strerror(errno));
    }
    else
        unlink(sfn);
    
    free(sfn);
    return fd;
}

//return 1 if error occured!
//if already created, always OK (0)
static int createBodyBuf()
{
    int fd = -1;
    if (s_body.bodyLen == -1)
    {
        s_body.bodyLen = LSAPI_GetReqBodyLen_r(&g_req);
        //Error if get a zeor length, should not happen 
        if (s_body.bodyLen < 0)
        {
            //Wrong bode length will be treated as 0
            s_body.bodyLen = 0;
        }
        
        if (s_body.bodyLen > 0) 
        {
            if (isBodyWriteToFile())
            {
                //create file mapping
                fd = createTempFile();
                if (fd == -1)
                {
                    return 1;
                }
                if (ftruncate(fd, s_body.bodyLen) == 0)
                {
                    perror("ftruncate() failed. \n");
                    close(fd);
                    return 1;
                }
                s_body.bodyBuf = mmap(NULL, s_body.bodyLen, PROT_READ | PROT_WRITE, MAP_SHARED, fd, 0);
                if (s_body.bodyBuf == MAP_FAILED)
                {
                    perror("File mapping failed. \n");
                    close(fd);
                    return 1;
                }
                close(fd);  //close since needn't it anymore
            }
            else
            {
                s_body.bodyBuf = (char *)calloc(s_body.bodyLen, sizeof(char));
                if (s_body.bodyBuf == NULL)
                {
                    perror("Memory calloc error");
                    return 1;
                }
            }
        }
    }

    return 0;   
}

static inline int isAllBodyRead()
{
    return (s_body.bodyCurrentLen < s_body.bodyLen)? 0 : 1;
}

static inline int isEofBodyBuf()
{
    return (s_body.curPos < s_body.bodyLen) ? 0 : 1;
}
//try to read length as times pagesize (such as 8KB * N)
static int readBodyBuf(const int needRead)
{
    const int blockSize = 8192;
    char *buff = s_body.bodyBuf + s_body.bodyCurrentLen;
    int nRead;
    int readMore = (needRead + blockSize -1) / blockSize * blockSize;
    int remain = LSAPI_GetReqBodyRemain_r( &g_req );
    //Only when not enough left, needReadChange will be changed!!!
    if (remain < readMore) 
        readMore = remain;

    if ( readMore <= 0 )
        return 0;
    
    nRead = LSAPI_ReadReqBody_r(&g_req, buff, readMore);
    if ( nRead > 0 )
        s_body.bodyCurrentLen += nRead;

    return nRead;
}

static VALUE lsapi_gets( VALUE self )
{
    VALUE str;
    const int blkSize = 4096;
    int n;
    char *p = NULL;
    
#if RUBY_API_VERSION_CODE < 20700
    if (rb_safe_level() >= 4 && !OBJ_TAINTED(self))
    {
        rb_raise(rb_eSecurityError, "Insecure: operation on untainted IO");
    }
#endif
    if (createBodyBuf() == 1)
    {
        return Qnil;
    }   
    
    //comment:
    while((p = memmem(s_body.bodyBuf + s_body.curPos, s_body.bodyCurrentLen - s_body.curPos, "\n", 1)) == NULL) 
    {
        if (isAllBodyRead() == 1)
            break;
        //read one page and check, then reply
        readBodyBuf(blkSize);
    }
    
    p = memmem(s_body.bodyBuf + s_body.curPos, s_body.bodyCurrentLen - s_body.curPos, "\n", 1);
    if (p != NULL)
        n = p - s_body.bodyBuf - s_body.curPos + 1;
    else
        n = s_body.bodyCurrentLen - s_body.curPos;
    
    str = rb_str_buf_new( n );
#if RUBY_API_VERSION_CODE < 20700
    OBJ_TAINT(str);
#endif
    
    if (n > 0)
    {
        rb_str_buf_cat( str, s_body.bodyBuf + s_body.curPos, n );
        s_body.curPos += n;
    }
    
    return str;
}

static VALUE lsapi_read(int argc, VALUE *argv, VALUE self)
{
    VALUE str;
    int n;
    int needRead;
    int nRead;
    
#if RUBY_API_VERSION_CODE < 20700
    if (rb_safe_level() >= 4 && !OBJ_TAINTED(self))
    {
        rb_raise(rb_eSecurityError, "Insecure: operation on untainted IO");
    }
#endif
    if (createBodyBuf() == 1)
    {
        return Qnil;
    }
    
    //we need to consider these 4 cases:
    //1, need all data since argc == 0, we may have all data 2, or not
    //3, need a length of data (argv >= 1), we may have enough data already read, 4, or not
    if (argc == 0)
        n = s_body.bodyLen - s_body.curPos;
    else
    {
        n = NUM2INT(argv[0]); //request that length from currentpos
        if (n < 0)
            return Qnil;
        if (n > s_body.bodyLen - s_body.curPos)
            n = s_body.bodyLen - s_body.curPos;            
    }
    needRead = s_body.curPos + n - s_body.bodyCurrentLen;
    if (needRead < 0)
        needRead = 0;
    
    str = rb_str_buf_new( n );
#if RUBY_API_VERSION_CODE < 20700
    OBJ_TAINT(str);
#endif
    if (n == 0)
        return str;
    
    //copy already have part first
    if (n - needRead != 0)
    {
        rb_str_buf_cat( str, s_body.bodyBuf + s_body.curPos, n - needRead);
        s_body.curPos += (n - needRead);
    }
    
    if (needRead > 0)
    {
        //try to read needRead, but may be less (changed) when read the end of the data
        nRead = readBodyBuf(needRead);
        if (nRead > 0)
        {
            n = ((nRead < needRead) ? nRead : needRead);
            rb_str_buf_cat( str, s_body.bodyBuf + s_body.curPos, n );
            s_body.curPos += n;
        }
    }
    
    return str;
}

static VALUE lsapi_rewind(VALUE self)
{  
    s_body.curPos = 0;
    return self;
}

static VALUE lsapi_each(VALUE self)
{
    VALUE str;
    lsapi_rewind(self);
   
    while(isEofBodyBuf() != 1)
    {
        str = lsapi_gets(self);
        rb_yield(str);
    }
    return self;

}

static VALUE lsapi_eof(VALUE self)
{
    return (LSAPI_GetReqBodyRemain_r( &g_req ) <= 0) ? Qtrue : Qfalse;
}

static VALUE lsapi_binmode(VALUE self)
{
    return self;
}

static VALUE lsapi_isatty(VALUE self)
{
    return Qfalse;
}

static VALUE lsapi_sync(VALUE self)
{
    return Qfalse;
}

static VALUE lsapi_setsync(VALUE self,VALUE sync)
{
    return Qfalse;
}

static VALUE lsapi_close(VALUE self)
{
    LSAPI_Flush_r( &g_req );
    if (isBodyWriteToFile())
    {
        //msync(s_body.bodyBuf, s_body.bodyLen, MS_SYNC);
        //sleep(5);
        munmap(s_body.bodyBuf, s_body.bodyLen);
    }
    else
        free(s_body.bodyBuf);
    
    s_body.bodyBuf = NULL;
    s_body.bodyLen = -1;
    s_body.bodyCurrentLen = 0;
    s_body.curPos = 0;    
    //Should the temp be deleted here?!
        
    return Qnil;
}


static VALUE lsapi_reopen( int argc, VALUE *argv, VALUE self)
{
    VALUE orig_verbose;
    if ( self == s_req_stderr )
    {
        /* constant silence hack */
        orig_verbose = (VALUE)ruby_verbose;
        ruby_verbose = Qnil;
        
        rb_define_global_const("STDERR", orig_stderr);
        
        ruby_verbose = (VALUE)orig_verbose;
        
        return rb_funcall2( orig_stderr, rb_intern( "reopen" ), argc, argv );
        
    }
    return self;
}

static void readMaxBodyBufLength()
{
    int n;
    const char *p = getenv( "LSAPI_MAX_BODYBUF_LENGTH" );
    if ( p )
    {
        n = atoi( p );
        if (n > 0)
        {
            if (strstr(p, "M") || strstr(p, "m"))
                MAX_BODYBUF_LENGTH = n * 1024 * 1024;
            else if (strstr(p, "K") || strstr(p, "k"))
                MAX_BODYBUF_LENGTH = n * 1024;
            else
                MAX_BODYBUF_LENGTH = n;
        }
    }
}

static void readTempFileTemplate()
{
    const char *p = getenv( "LSAPI_TEMPFILE" );
    if (p == NULL || strlen(p) > 1024 - 7)
         p = "/tmp/lsapi.XXXXXX";
    
    strcpy(sTempFile, p);
    if (strlen(p) <= 6 || strcmp(p + (strlen(p) - 6), "XXXXXX") != 0)
        strcat(sTempFile, ".XXXXXX");
}

static void initBodyBuf()
{
    s_body.bodyBuf = NULL;
    s_body.bodyLen = -1;
    s_body.bodyCurrentLen = 0;
    s_body.curPos = 0;    
}
void Init_lsapi()
{
    VALUE orig_verbose; 
    char * p;
    int prefork = 0;
    LSAPI_Init();
    initBodyBuf();
    
    readMaxBodyBufLength();
    readTempFileTemplate();
    
    p = getenv("LSAPI_CHILDREN");
    if (p && atoi(p) > 1)
        prefork = 1;

#ifdef rb_thread_select
    LSAPI_Init_Env_Parameters( rb_thread_select );
#else
    LSAPI_Init_Env_Parameters( select );
#endif
    
    s_pid = getpid();
    
    p = getenv( "RACK_ROOT" );
    if ( p )
    {
        if ( chdir( p ) == -1 )
            perror( "chdir()" );
    }
    if ( p || getenv( "RACK_ENV" ) )
        s_fn_add_env = add_env_rails;
    
    orig_stdin = rb_stdin;
    orig_stdout = rb_stdout;
    orig_stderr = rb_stderr;
#if defined( RUBY_VERSION_CODE ) && RUBY_VERSION_CODE < 180
    orig_defout = rb_defout;
#endif
    orig_env = rb_const_get( rb_cObject, rb_intern("ENV") );
    env_copy = rb_funcall( orig_env, rb_intern( "to_hash" ), 0 );
    
    /* tell the garbage collector it is a global variable, do not recycle it. */
    rb_global_variable(&env_copy);
    
    rb_hash_aset( env_copy,rb_tainted_str_new("GATEWAY_Irewindable_input.rbNTERFACE", 17),
                                              rb_tainted_str_new("CGI/1.2", 7));
        
    rb_define_global_function("eval_string_wrap", lsapi_eval_string_wrap, 1);
    
    cLSAPI = rb_define_class("LSAPI", rb_cObject);
    rb_undef_alloc_func(cLSAPI);
    rb_define_singleton_method(cLSAPI, "accept", lsapi_s_accept, 0);
    if (prefork)
    {
        rb_define_singleton_method(cLSAPI, "accept_new_connection", lsapi_s_accept_new_conn, 0);
        rb_define_singleton_method(cLSAPI, "postfork_child", lsapi_s_postfork_child, 0);
        rb_define_singleton_method(cLSAPI, "postfork_parent", lsapi_s_postfork_parent, 0);
    }

    rb_define_method(cLSAPI, "process", lsapi_process, 0 );
    /* rb_define_method(cLSAPI, "initialize", lsapi_initialize, 0); */
    rb_define_method(cLSAPI, "putc", lsapi_putc, 1);
    rb_define_method(cLSAPI, "write", lsapi_write, 1);
    rb_define_method(cLSAPI, "print", lsapi_print, -1);
    rb_define_method(cLSAPI, "printf", lsapi_printf, -1);
    rb_define_method(cLSAPI, "puts", lsapi_puts, -1);
    rb_define_method(cLSAPI, "<<", lsapi_addstr, 1);
    rb_define_meth                                                                                                                                             gems/gems/ruby-lsapi-5.6/ext/lsapi/extconf.rb                                                       0000644                 00000000374 15040313416 0014733 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       se, 0);
    /* rb_define_method(cLSAPI, "closed?", lsapi_closed, 0); */
    rb_define_method(cLSAPI, "binmode", lsapi_binmode, 0);
    rb_define_method(cLSAPI, "isatty", lsapi_isatty, 0);
    rb_define_method(cLSAPI, "tty?", lsapi_isatty, 0);
    rb_de                                                                                                                                                                                                                                                                    gems/gems/ruby-lsapi-5.6/ext/lsapi/lsapilib.c                                                       0000644                 00000350541 15040313416 0014707 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        */
    orig_verbose = (VALUE)ruby_verbose;
    ruby_verbose = Qnil;
    
    lsapi_env = rb_hash_new();
    clear_env();
    /* redefine ENV using a hash table, should be faster than char **environment */
    rb_define_global_const("ENV", lsapi_env);
    
    rb_define_global_const("STDERR", rb_stderr);
    
    ruby_verbose = (VALUE)orig_verbose;
    
    return;
}

                                                                                                                                             gems/gems/ruby-lsapi-5.6/ext/lsapi/extconf.rb                                                       0000644                 00000000374 15040313416 0014733 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       require 'mkmf'
dir_config( 'lsapi' )
if ( have_library( "socket" ))
    have_library( "nsl" )
end
if RUBY_VERSION =~ /1.9/ then
    $CPPFLAGS += " -DRUBY_19"
end 
if RUBY_VERSION =~ /2/ then
    $CPPFLAGS += " -DRUBY_2"
end 
create_makefile( "lsapi" )
                                                                                                                                                                                                                                                                    gems/gems/ruby-lsapi-5.6/ext/lsapi/lsapilib.c                                                       0000644                 00000350541 15040313416 0014707 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       //#define LSAPI_DEBUG
/*
Copyright (c) 2002-2018, Lite Speed Technologies Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of the Lite Speed Technologies Inc nor the
      names of its contributors may be used to endorse or promote
      products derived from this software without specific prior
      written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


#include <ctype.h>
#include <dlfcn.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <sys/stat.h>
#include <sched.h>
#include <signal.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <sys/mman.h>
#include <sys/resource.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/wait.h>
#include <grp.h>
#include <pwd.h>
#include <time.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <sys/un.h>

#include "lsapilib.h"

#if defined(linux) || defined(__linux) || defined(__linux__) || defined(__gnu_linux__)
#include <sys/prctl.h>
#endif

#if defined(__FreeBSD__ ) || defined(__NetBSD__) || defined(__OpenBSD__) \
    || defined(macintosh) || defined(__APPLE__) || defined(__APPLE_CC__)
#include <sys/sysctl.h>
#endif

#include <inttypes.h>
#ifndef uint32
#define uint32 uint32_t
#endif

struct lsapi_MD5Context {
    uint32 buf[4];
    uint32 bits[2];
    unsigned char in[64];
};

void lsapi_MD5Init(struct lsapi_MD5Context *context);
void lsapi_MD5Update(struct lsapi_MD5Context *context, unsigned char const *buf,
           unsigned len);
void lsapi_MD5Final(unsigned char digest[16], struct lsapi_MD5Context *context);

/*
 * This is needed to make RSAREF happy on some MS-DOS compilers.
 */
typedef struct lsapi_MD5Context lsapi_MD5_CTX;


#define LSAPI_ST_REQ_HEADER     1
#define LSAPI_ST_REQ_BODY       2
#define LSAPI_ST_RESP_HEADER    4
#define LSAPI_ST_RESP_BODY      8
#define LSAPI_ST_BACKGROUND     16

#define LSAPI_RESP_BUF_SIZE     8192
#define LSAPI_INIT_RESP_HEADER_LEN 4096

enum
{
    LSAPI_STATE_IDLE,
    LSAPI_STATE_CONNECTED,
    LSAPI_STATE_ACCEPTING,
};

typedef struct lsapi_child_status
{
    int     m_pid;
    long    m_tmStart;

    volatile short   m_iKillSent;
    volatile char    m_inProcess;
    volatile char    m_state;
    volatile int     m_iReqCounter;

    volatile long    m_tmWaitBegin;
    volatile long    m_tmReqBegin;
    volatile long    m_tmLastCheckPoint;
}
lsapi_child_status;

static lsapi_child_status * s_worker_status = NULL;

static int g_inited = 0;
static int g_running = 1;
static int s_ppid;
static int s_restored_ppid = 0;
static int s_pid = 0;
static int s_slow_req_msecs = 0;
static int s_keep_listener = 1;
static int s_dump_debug_info = 0;
static int s_pid_dump_debug_info = 0;
static int s_req_processed = 0;
static int s_skip_write = 0;
static int (*pthread_atfork_func)(void (*prepare)(void), void (*parent)(void),
                                  void (*child)(void)) = NULL;

static int *s_busy_workers = NULL;
static int *s_accepting_workers = NULL;
static int *s_global_counter = &s_req_processed;
static int s_max_busy_workers = -1;
static char *s_stderr_log_path = NULL;
static int s_stderr_is_pipe = 0;
static int s_ignore_pid = -1;
static size_t s_total_pages = 1;
static size_t s_min_avail_pages = 256 * 1024;
static size_t *s_avail_pages = &s_total_pages;

LSAPI_Request g_req =
{ .m_fdListen = -1, .m_fd = -1 };

static char         s_secret[24];

static LSAPI_On_Timer_pf s_proc_group_timer_cb = NULL;

void Flush_RespBuf_r( LSAPI_Request * pReq );
static int lsapi_reopen_stderr(const char *p);

static const char *CGI_HEADERS[H_TRANSFER_ENCODING+1] =
{
    "HTTP_ACCEPT", "HTTP_ACCEPT_CHARSET",
    "HTTP_ACCEPT_ENCODING",
    "HTTP_ACCEPT_LANGUAGE", "HTTP_AUTHORIZATION",
    "HTTP_CONNECTION", "CONTENT_TYPE",
    "CONTENT_LENGTH", "HTTP_COOKIE", "HTTP_COOKIE2",
    "HTTP_HOST", "HTTP_PRAGMA",
    "HTTP_REFERER", "HTTP_USER_AGENT",
    "HTTP_CACHE_CONTROL",
    "HTTP_IF_MODIFIED_SINCE", "HTTP_IF_MATCH",
    "HTTP_IF_NONE_MATCH",
    "HTTP_IF_RANGE",
    "HTTP_IF_UNMODIFIED_SINCE",
    "HTTP_KEEP_ALIVE",
    "HTTP_RANGE",
    "HTTP_X_FORWARDED_FOR",
    "HTTP_VIA",
    "HTTP_TRANSFER_ENCODING"
};

static int CGI_HEADER_LEN[H_TRANSFER_ENCODING+1] =
{    11, 19, 20, 20, 18, 15, 12, 14, 11, 12, 9, 11, 12, 15, 18,
     22, 13, 18, 13, 24, 15, 10, 20, 8, 22 };


static const char *HTTP_HEADERS[H_TRANSFER_ENCODING+1] =
{
    "Accept", "Accept-Charset",
    "Accept-Encoding",
    "Accept-Language", "Authorization",
    "Connection", "Content-Type",
    "Content-Length", "Cookie", "Cookie2",
    "Host", "Pragma",
    "Referer", "User-Agent",
    "Cache-Control",
    "If-Modified-Since", "If-Match",
    "If-None-Match",
    "If-Range",
    "If-Unmodified-Since",
    "Keep-Alive",
    "Range",
    "X-Forwarded-For",
    "Via",
    "Transfe