y = bool ? 0 : 1
  end

  ##
  # Removes directories from +path+ that are outside the current directory

  def sanitize_path path
    require 'pathname'
    dot = Pathname.new('.').expand_path

    path.reject do |item|
      path = Pathname.new(item).expand_path
      is_reject = nil
      relative = nil
      begin
        relative = path.relative_path_from(dot).to_s
      rescue ArgumentError
        # On Windows, sometimes crosses different drive letters.
        is_reject = true
      else
        is_reject = relative.start_with? '..'
      end
      is_reject
    end
  end

  ##
  # Set up an output generator for the named +generator_name+.
  #
  # If the found generator responds to :setup_options it will be called with
  # the options instance.  This allows generators to add custom options or set
  # default options.

  def setup_generator generator_name = @generator_name
    @generator = @generators[generator_name]

    unless @generator then
      raise OptionParser::InvalidArgument,
            "Invalid output formatter #{generator_name}"
    end

    return if @generator_options.include? @generator

    @generator_name = generator_name
    @generator_options << @generator

    if @generator.respond_to? :setup_options then
      @option_parser ||= OptionParser.new
      @generator.setup_options self
    end
  end

  ##
  # Finds the template dir for +template+

  def template_dir_for template
    template_path = File.join 'rdoc', 'generator', 'template', template

    $LOAD_PATH.map do |path|
      File.join File.expand_path(path), template_path
    end.find do |dir|
      File.directory? dir
    end
  end

  # Sets the minimum visibility of a documented method.
  #
  # Accepts +:public+, +:protected+, +:private+, +:nodoc+, or +:all+.
  #
  # When +:all+ is passed, visibility is set to +:private+, similarly to
  # RDOCOPT="--all", see #visibility for more information.

  def visibility= visibility
    case visibility
    when :all
      @visibility = :private
    else
      @visibility = visibility
    end
  end

  ##
  # Displays a warning using Kernel#warn if we're being verbose

  def warn message
    super message if @verbosity > 1
  end

  ##
  # Writes the YAML file .rdoc_options to the current directory containing the
  # parsed options.

  def write_options
    RDoc.load_yaml

    File.open '.rdoc_options', 'w' do |io|
      io.set_encoding Encoding::UTF_8

      io.print to_yaml
    end
  end

  ##
  # Loads options from .rdoc_options if the file exists, otherwise creates a
  # new RDoc::Options instance.

  def self.load_options
    options_file = File.expand_path '.rdoc_options'
    return RDoc::Options.new unless File.exist? options_file

    RDoc.load_yaml

    begin
      options = YAML.safe_load File.read('.rdoc_options'), permitted_classes: [RDoc::Options, Symbol]
    rescue Psych::SyntaxError
      raise RDoc::Error, "#{options_file} is not a valid rdoc options file"
    end

    return RDoc::Options.new unless options # Allow empty file.

    raise RDoc::Error, "#{options_file} is not a valid rdoc options file" unless
      RDoc::Options === options or Hash === options

    if Hash === options
      # Override the default values with the contents of YAML file.
      options = RDoc::Options.new options
    end

    options
  end

end
                                                                                                                                                                                                                                                                       gems/gems/rdoc-6.5.1.1/lib/rdoc/stats.rb                                                            0000644                 00000024772 15040313412 0013352 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# RDoc statistics collector which prints a summary and report of a project's
# documentation totals.

class RDoc::Stats

  include RDoc::Text

  ##
  # Output level for the coverage report

  attr_reader :coverage_level

  ##
  # Count of files parsed during parsing

  attr_reader :files_so_far

  ##
  # Total number of files found

  attr_reader :num_files

  ##
  # Creates a new Stats that will have +num_files+.  +verbosity+ defaults to 1
  # which will create an RDoc::Stats::Normal outputter.

  def initialize store, num_files, verbosity = 1
    @num_files = num_files
    @store     = store

    @coverage_level   = 0
    @doc_items        = nil
    @files_so_far     = 0
    @fully_documented = false
    @num_params       = 0
    @percent_doc      = nil
    @start            = Time.now
    @undoc_params     = 0

    @display = case verbosity
               when 0 then Quiet.new   num_files
               when 1 then Normal.new  num_files
               else        Verbose.new num_files
               end
  end

  ##
  # Records the parsing of an alias +as+.

  def add_alias as
    @display.print_alias as
  end

  ##
  # Records the parsing of an attribute +attribute+

  def add_attribute attribute
    @display.print_attribute attribute
  end

  ##
  # Records the parsing of a class +klass+

  def add_class klass
    @display.print_class klass
  end

  ##
  # Records the parsing of +constant+

  def add_constant constant
    @display.print_constant constant
  end

  ##
  # Records the parsing of +file+

  def add_file(file)
    @files_so_far += 1
    @display.print_file @files_so_far, file
  end

  ##
  # Records the parsing of +method+

  def add_method(method)
    @display.print_method method
  end

  ##
  # Records the parsing of a module +mod+

  def add_module(mod)
    @display.print_module mod
  end

  ##
  # Call this to mark the beginning of parsing for display purposes

  def begin_adding
    @display.begin_adding
  end

  ##
  # Calculates documentation totals and percentages for classes, modules,
  # constants, attributes and methods.

  def calculate
    return if @doc_items

    ucm = @store.unique_classes_and_modules

    classes = @store.unique_classes.reject { |cm| cm.full_name == 'Object' }

    constants = []
    ucm.each { |cm| constants.concat cm.constants }

    methods = []
    ucm.each { |cm| methods.concat cm.method_list }

    attributes = []
    ucm.each { |cm| attributes.concat cm.attributes }

    @num_attributes, @undoc_attributes = doc_stats attributes
    @num_classes,    @undoc_classes    = doc_stats classes
    @num_constants,  @undoc_constants  = doc_stats constants
    @num_methods,    @undoc_methods    = doc_stats methods
    @num_modules,    @undoc_modules    = doc_stats @store.unique_modules

    @num_items =
      @num_attributes +
      @num_classes +
      @num_constants +
      @num_methods +
      @num_modules +
      @num_params

    @undoc_items =
      @undoc_attributes +
      @undoc_classes +
      @undoc_constants +
      @undoc_methods +
      @undoc_modules +
      @undoc_params

    @doc_items = @num_items - @undoc_items
  end

  ##
  # Sets coverage report level.  Accepted values are:
  #
  # false or nil:: No report
  # 0:: Classes, modules, constants, attributes, methods
  # 1:: Level 0 + method parameters

  def coverage_level= level
    level = -1 unless level

    @coverage_level = level
  end

  ##
  # Returns the length and number of undocumented items in +collection+.

  def doc_stats collection
    visible = collection.select { |item| item.display? }
    [visible.length, visible.count { |item| not item.documented? }]
  end

  ##
  # Call this to mark the end of parsing for display purposes

  def done_adding
    @display.done_adding
  end

  ##
  # The documentation status of this project.  +true+ when 100%, +false+ when
  # less than 100% and +nil+ when unknown.
  #
  # Set by calling #calculate

  def fully_documented?
    @fully_documented
  end

  ##
  # A report that says you did a great job!

  def great_job
    report = RDoc::Markup::Document.new

    report << RDoc::Markup::Paragraph.new('100% documentation!')
    report << RDoc::Markup::Paragraph.new('Great Job!')

    report
  end

  ##
  # Calculates the percentage of items documented.

  def percent_doc
    return @percent_doc if @percent_doc

    @fully_documented = (@num_items - @doc_items) == 0

    @percent_doc = @doc_items.to_f / @num_items * 100 if @num_items.nonzero?
    @percent_doc ||= 0

    @percent_doc
  end

  ##
  # Returns a report on which items are not documented

  def report
    if @coverage_level > 0 then
      extend RDoc::Text
    end

    if @coverage_level.zero? then
      calculate

      return great_job if @num_items == @doc_items
    end

    ucm = @store.unique_classes_and_modules

                                                                                                                                                                                                                                                                       gems/gems/rdoc-6.5.1.1/lib/rdoc/stats.rb                                                            0000644                 00000024772 15040313412 0013352 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       {attr.line}" : nil
      report << "  #{attr.definition} :#{attr.name} # in file #{attr.file.full_name}#{line}\n"
      report << "\n"
    end

    report
  end

  ##
  # Returns a report on undocumented items in ClassModule +cm+

  def report_class_module cm
    return if cm.fully_documented? and @coverage_level.zero?
    return unless cm.display?

    report = RDoc::Markup::Document.new

    if cm.in_files.empty? then
      report << RDoc::Markup::Paragraph.new("#{cm.definition} is referenced but empty.")
      report << RDoc::Markup::Paragraph.new("It probably came from another project.  I'm sorry I'm holding it against you.")

      return report
    elsif cm.documented? then
      documented = true
      klass = RDoc::Markup::Verbatim.new("#{cm.definition} # is documented\n")
    else
      report << RDoc::Markup::Paragraph.new('In files:')

      list = RDoc::Markup::List.new :BULLET

      cm.in_files.each do |file|
        para = RDoc::Markup::Paragraph.new file.full_name
        list << RDoc::M