e-distribute or change these files under Ruby's License or GPL.
#
# 1. You may make and give away verbatim copies of the source form of the
#    software without restriction, provided that you duplicate all of the
#    original copyright notices and associated disclaimers.
#
# 2. You may modify your copy of the software in any way, provided that
#    you do at least ONE of the following:
#
#    a. place your modifications in the Public Domain or otherwise
#       make them Freely Available, such as by posting said
#       modifications to Usenet or an equivalent medium, or by allowing
#       the author to include your modifications in the software.
#
#    b. use the modified software only within your corporation or
#       organization.
#
#    c. give non-standard binaries non-standard names, with
#       instructions on where to get the original software distribution.
#
#    d. make other distribution arrangements with the author.
#
# 3. You may distribute the software in object code or binary form,
#    provided that you do at least ONE of the following:
#
#    a. distribute the binaries and library files of the software,
#       together with instructions (in the manual page or equivalent)
#       on where to get the original distribution.
#
#    b. accompany the distribution with the machine-readable source of
#       the software.
#
#    c. give non-standard binaries non-standard names, with
#       instructions on where to get the original software distribution.
#
#    d. make other distribution arrangements with the author.
#
# 4. You may modify and include the part of the software into any other
#    software (possibly commercial).  But some files in the distribution
#    are not written by the author, so that they are not under these terms.
#
#    For the list of those files and their copying conditions, see the
#    file LEGAL.
#
# 5. The scripts and library files supplied as input to or produced as
#    output from the software do not automatically fall under the
#    copyright of the software, but belong to whomever generated them,
#    and may be sold commercially, and may be aggregated with this
#    software.
#
# 6. THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
#    IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
#    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#    PURPOSE.

class RDoc::RD

  ##
  # Parses +rd+ source and returns an RDoc::Markup::Document.                                                                                                    gems/gems/rdoc-6.5.1.1/lib/rdoc/erbio.rb                                                            0000644                 00000002006 15040313412 0013276 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       , "#{__dir__}/rd/inline_parser"
  autoload :Inline,       "#{__dir__}/rd/inline"

end
                                                                                                                                                                                                                                                                                                                                                                                                                                          gems/gems/rdoc-6.5.1.1/lib/rdoc/text.rb                                                             0000644                 00000017206 15040313412 0013172 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # froz                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          gems/gems/rdoc-6.5.1.1/lib/rdoc/rd.rb                                                               0000644                 00000007126 15040313412 0012613 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ack('–', encoding, '--'),
      :open_dquote  => encode_fallback('“', encoding, '"'),
      :open_squote  => encode_fallback('‘', encoding, '\''),
      :trademark    => encode_fallback('®', encoding, '(r)'),
    }
  end

  ##
  # Transcodes +character+ to +encoding+ with a +fallback+ character.

  def self.encode_fallback character, encoding, fallback
    character.encode(encoding, :fallback => { character => fallback },
                     :undef => :replace, :replace => fallback)
  end

  ##
  # Expands tab characters in +text+ to eight spaces

  def expand_tabs text
    expanded = []

    text.each_line do |line|
      nil while line.gsub!(/(?:\G|\r)((?:.{8})*?)([^\t\r\n]{0,7})\t/) do
        r = "#{$1}#{$2}#{' ' * (8 - $2.size)}"
        r = RDoc::Encoding.change_encoding r, text.encoding
        r
      end

      expanded << line
    end

    expanded.join
  end

  ##
  # Flush +text+ left based on the shortest line

  def flush_left text
    indent = 9999

    text.each_line do |line|
      line_indent = line =~ /\S/ || 9999
      indent = line_indent if indent > line_indent
    end

    empty = ''
    empty = RDoc::Encoding.change_encoding empty, text.encoding

    text.gsub(/^ {0,#{indent}}/, empty)
  end

  ##
  # Convert a string in markup format into HTML.
  #
  # Requires the including class to implement #formatter

  def markup text
    if @store.rdoc.options
      locale = @store.rdoc.options.locale
    else
      locale = nil
    end
    if locale
      i18n_text = RDoc::I18n::Text.new(text)
      text = i18n_text.translate(locale)
    end
    parse(text).accept formatter
  end

  ##
  # Strips hashes, expands tabs then flushes +text+ to the left

  def normalize_comment text
    return text if text.empty?

    case language
    when :ruby
      text = strip_hashes text
    when :c
      text = strip_stars text
    end
    text = expand_tabs    text
    text = flush_left     text
    text = strip_newlines text
    text
  end

  ##
  # Normalizes +text+ then builds a RDoc::Markup::Document from it

  def parse text, format = 'rdoc'
    return text if RDoc::Markup::Document === text
    return text.parse if RDoc::Comment === text

    text = normalize_comment text # TODO remove, should not be necessary

    return RDoc::Markup::Document.new if text =~ /\A\n*\z/

    MARKUP_FORMAT[format].parse text
  end

  ##
  # The first +limit+ characters of +text+ as HTML

  def snippet text, limit = 100
    document = parse text

    RDoc::Markup::ToHtmlSnippet.new(options, limit).convert document
  end

  ##
  # Strips leading # characters from +text+

  def strip_hashes text
    return text if text =~ /^(?>\s*)[^\#]/

    empty = ''