_LIBS = 
LIBS = $(LIBRUBYARG_SHARED)  -lm -lpthread  -lc
ORIG_SRCS = lsapilib.c lsruby.c
SRCS = $(ORIG_SRCS) 
OBJS = lsapilib.o lsruby.o
HDRS = $(srcdir)/lsapidef.h $(srcdir)/lsapilib.h
LOCAL_HDRS = 
TARGET = lsapi
TARGET_NAME = lsapi
TARGET_ENTRY = Init_$(TARGET_NAME)
DLLIB = $(TARGET).so
EXTSTATIC = 
STATIC_LIB = 

TIMESTAMP_DIR = .
BINDIR        = $(bindir)
RUBYCOMMONDIR = $(sitedir)$(target_prefix)
RUBYLIBDIR    = $(sitelibdir)$(target_prefix)
RUBYARCHDIR   = $(sitearchdir)$(target_prefix)
HDRDIR        = $(sitehdrdir)$(target_prefix)
ARCHHDRDIR    = $(sitearchhdrdir)$(target_prefix)
TARGET_SO_DIR =
TARGET_SO     = $(TARGET_SO_DIR)$(DLLIB)
CLEANLIBS     = $(TARGET_SO) false
CLEANOBJS     = $(OBJS) *.bak
TARGET_SO_DIR_TIMESTAMP = $(TIMESTAMP_DIR)/.sitearchdir.time

all:    $(DLLIB)
static: $(STATIC_LIB)
.PHONY: all install static install-so install-rb
.PHONY: clean clean-so clean-static clean-rb

clean-static::
clean-rb-default::
clean-rb::
clean-so::
clean: clean-so clean-static clean-rb-default clean-rb
		-$(Q)$(RM_RF) $(CLEANLIBS) $(CLEANOBJS) $(CLEANFILES) .*.time

distclean-rb-default::
distclean-rb::
distclean-so::
distclean-static::
distclean: clean distclean-so distclean-static distclean-rb-default distclean-rb
		-$(Q)$(RM) Makefile $(RUBY_EXTCONF_H) conftest.* mkmf.log
		-$(Q)$(RM) core ruby$(EXEEXT) *~ $(DISTCLEANFILES)
		-$(Q)$(RMDIRS) $(DISTCLEANDIRS) 2> /dev/null || true

realclean: distclean
install: install-so install-rb

install-so: $(DLLIB) $(TARGET_SO_DIR_TIMESTAMP)
	$(INSTALL_PROG) $(DLLIB) $(RUBYARCHDIR)
clean-static::
	-$(Q)$(RM) $(STATIC_LIB)
install-rb: pre-install-rb do-install-rb install-rb-default
install-rb-default: pre-install-rb-default do-install-rb-default
pre-install-rb: Makefile
pre-install-rb-default: Makefile
do-install-rb:
do-install-rb-default:
pre-install-rb-default:
	@$(NULLCMD)
$(TARGET_SO_DIR_TIMESTAMP):
	$(Q) $(MAKEDIRS) $(@D) $(RUBYARCHDIR)
	$(Q) $(TOUCH) $@

site-install: site-install-so site-install-rb
site-install-so: install-so
site-install-rb: install-rb

.SUFFIXES: .c .m .cc .mm .cxx .cpp .o .S

.cc.o:
	$(ECHO) compiling $(<)
	$(Q) $(CXX) $(INCFLAGS) $(CPPFLAGS) $(CXXFLAGS) $(COUTFLAG)$@ -c $(CSRCFLAG)$<

.cc.S:
	$(ECHO) translating $(<)
	$(Q) $(CXX) $(INCFLAGS) $(CPPFLAGS) $(CXXFLAGS) $(COUTFLAG)$@ -S $(CSRCFLAG)$<

.mm.o:
	$(ECHO) compiling $(<)
	$(Q) $(CXX) $(INCFLAGS) $(CPPFLAGS) $(CXXFLAGS) $(COUTFLAG)$@ -c $(CSRCFLAG)$<

.mm.S:
	$(ECHO) translating $(<)
	$(Q) $(CXX) $(INCFLAGS) $(CPPFLAGS) $(CXXFLAGS) $(COUTFLAG)$@ -S $(CSRCFLAG)$<

.cxx.o:
	$(ECHO) compiling $(<)
	$(Q) $(CXX) $(INCFLAGS) $(CPPFLAGS) $(CXXFLAGS) $(COUTFLAG)$@ -c $(CSRCFLAG)$<

.cxx.S:
	$(ECHO) translating $(<)
	$(Q) $(CXX) $(INCFLAGS) $(CPPFLAGS) $(CXXFLAGS) $(COUTFLAG)$@ -S $(CSRCFLAG)$<

.cpp.o:
	$(ECHO) compiling $(<)
	$(Q) $(CXX) $(INCFLAGS) $(CPPFLAGS) $(CXXFLAGS) $(COUTFLAG)$@ -c $(CSRCFLAG)$<

.cpp.S:
	$(ECHO) translating $(<)
	$(Q) $(CXX) $(INCFLAGS) $(CPPFLAGS) $(CXXFLAGS) $(COUTFLAG)$@ -S $(CSRCFLAG)$<

.c.o:
	$(ECHO) compiling $(<)
	$(Q) $(CC) $(INCFLAGS) $(CPPFLAGS) $(CFLAGS) $(COUTFLAG)$@ -c $(CSRCFLAG)$<

.c.S:
	$(ECHO) translating $(<)
	$(Q) $(CC) $(INCFLAGS) $(CPPFLAGS) $(CFLAGS) $(COUTFLAG)$@ -S $(CSRCFLAG)$<

.m.o:
	$(ECHO) compiling $(<)
	$(Q) $(CC) $(INCFLAGS) $(CPPFLAGS) $(CFLAGS) $(COUTFLAG)$@ -c $(CSRCFLAG)$<

.m.S:
	$(ECHO) translating $(<)
	$(Q) $(CC) $(INCFLAGS) $(CPPFLAGS) $(CFLAGS) $(COUTFLAG)$@ -S $(CSRCFLAG)$<

$(TARGET_SO): $(OBJS) Makefile
	$(ECHO) linking shared-object $(DLLIB)
	-$(Q)$(RM) $(@)
	$(Q) $(LDSHARED) -o $@ $(OBJS) $(LIBPATH) $(DLDFLAGS) $(LOCAL_LIBS) $(LIBS)
	$(Q) $(POSTLINK)



$(OBJS): $(HDRS) $(ruby_headers)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                  gems/gems/ruby-lsapi-5.6/ext/lsapi/lsapidef.h                                                       0000644                 00000011054 15040313416 0014675 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       /*
Copyright (c) 2002-2018, Lite Speed Technologies Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of the Lite Speed Technologies Inc nor the
      names of its contributors may be used to endorse or promote
      products derived from this software without specific prior
      written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


#ifndef  _LSAPIDEF_H_
#define  _LSAPIDEF_H_

#include <inttypes.h>

#if defined (c_plusplus) || defined (__cplusplus)
extern "C" {
#endif

enum
{
    H_ACCEPT = 0,
    H_ACC_CHARSET,
    H_ACC_ENCODING,
    H_ACC_LANG,
    H_AUTHORIZATION,
    H_CONNECTION,
    H_CONTENT_TYPE,
    H_CONTENT_LENGTH,
    H_COOKIE,
    H_COOKIE2,
    H_HOST,
    H_PRAGMA,
    H_REFERER,
    H_USERAGENT,
    H_CACHE_CTRL,
    H_IF_MODIFIED_SINCE,
    H_IF_MATCH,
    H_IF_NO_MATCH,
    H_IF_RANGE,
    H_IF_UNMOD_SINCE,
    H_KEEP_ALIVE,
    H_RANGE,
    H_X_FORWARDED_FOR,
    H_VIA,
    H_TRANSFER_ENCODING

};
#define LSAPI_SOCK_FILENO           0

#define LSAPI_VERSION_B0            'L'
#define LSAPI_VERSION_B1            'S'

/* Values for m_flag in lsapi_packet_header */
#define LSAPI_ENDIAN_LITTLE         0
#define LSAPI_ENDIAN_BIG            1
#define LSAPI_ENDIAN_BIT            1

#if defined(__i386__)||defined( __x86_64 )||defined( __x86_64__ )
#define LSAPI_ENDIAN                LSAPI_ENDIAN_LITTLE
#else
#define LSAPI_ENDIAN                LSAPI_ENDIAN_BIG
#endif

/* Values for m_type in lsapi_packet_header */
#define LSAPI_BEGIN_REQUEST         1
#define LSAPI_ABORT_REQUEST         2
#define LSAPI_RESP_HEADER           3
#define LSAPI_RESP_STREAM           4
#define LSAPI_RESP_END              5
#define LSAPI_STDERR_STREAM         6
#define LSAPI_REQ_RECEIVED          7
#define LSAPI_CONN_CLOSE            8
#define LSAPI_INTERNAL_ERROR        9


#define LSAPI_MAX_HEADER_LEN        65535
#define LSAPI_MAX_DATA_PACKET_LEN   16384

#define LSAPI_RESP_HTTP_HEADER_MAX  32768
#define LSAPI_PACKET_HEADER_LEN     8


struct lsapi_packet_header
{
    char    m_versionB0;      /* LSAPI protocol version */
    char    m_versionB1;
    char    m_type;
    char    m_flag;
    union
    {
        int32_t m_iLen;       /* include this header */
        char    m_bytes[4];
    }m_packetLen;
};

/*
    LSAPI request header packet

    1. struct lsapi_req_header
    2. struct lsapi_http_header_index
    3. lsapi_header_offset * unknownHeaders
    4. org http request header
    5. request body if available
*/

struct lsapi_req_header
{
    struct lsapi_packet_header m_pktHeader;

    int32_t m_httpHeaderLen;
    int32_t m_reqBodyLen;
    int32_t m_scriptFileOff;   /* path to the script file. */
    int32_t m_scriptNameOff;   /* decrypted URI, without pathinfo, */
    int32_t m_queryStringOff;  /* Query string inside env */
    int32_t m_requestMethodOff;
    int32_t m_cntUnknownHeaders;
    int32_t m_cntEnv;
    int32_t m_cntSpecialEnv;
} ;


struct lsapi_http_header_index
{
    uint16_t m_headerLen[H_TRANSFER_ENCODING+1];
    int32_t m_headerOff[H_TRANSFER_ENCODING+1];
} ;

struct lsapi_header_offset
{
    int32_t nameOff;
    int32_t nameLen;
    int32_t valueOff;
    int32_t valueLen;
} ;

struct lsapi_resp_info
{
    int32_t m_cntHeaders;
    int32_t m_status;
};

struct lsapi_resp_header
{
    struct  lsapi_packet_header  m_pktHeader;
    struct  lsapi_resp_info      m_respInfo;
};

#if defined (c_plusplus) || defined (__cplusplus)
}
#endif


#endif

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    gems/gems/ruby-lsapi-5.6/ext/lsapi/lsruby.c                                                         0000644                 00000055563 15040313416 0014436 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       
#include "ruby.h"

#if defined( RUBY_VERSION_CODE ) && RUBY_VERSION_CODE < 180
#include "util.h"
#else
#include <ruby/util.h>
#include <ruby/version.h>
#endif

#include "lsapilib.h"
#include <errno.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <unistd.h>
#include <sys/mman.h>
#include <fcntl.h>


#ifndef RUBY_API_VERSION_CODE
#define RUBY_API_VERSION_CODE (RUBY_API_VERSION_MAJOR*10000+RUBY_API_VERSION_MINOR*100+RUBY_API_VERSION_TEENY)
#endif

/* RUBY_EXTERN VALUE ruby_errinfo; */
RUBY_EXTERN VALUE rb_stdin;
RUBY_EXTERN VALUE rb_stdout;
#if defined( RUBY_VERSION_CODE ) && RUBY_VERSION_CODE < 180
RUBY_EXTERN VALUE rb_defout;
#endif

static VALUE orig_stdin;
static VALUE orig_stdout;
static VALUE orig_stderr;
#if defined( RUBY_VERSION_CODE ) && RUBY_VERSION_CODE < 180
static VALUE orig_defout;
#endif
static VALUE orig_env;

static VALUE env_copy;

static VALUE lsapi_env;

static int MAX_BODYBUF_LENGTH = (10 * 1024 * 1024);

#if RUBY_API_VERSION_CODE >= 20700
# if defined rb_tainted_str_new
#  undef rb_tainted_str_new
# endif
# define rb_tainted_str_new(p,l)  rb_str_new((p),(l))
#endif

/* static VALUE lsapi_objrefs; */

typedef struct lsapi_data
{
    LSAPI_Request * req;
    VALUE           env;
    ssize_t      (* fn_write)( LSAPI_Request *, const char * , size_t );
}lsapi_data;

static VALUE cLSAPI;

static VALUE s_req = Qnil;
static lsapi_data * s_req_data;

static VALUE s_req_stderr = Qnil;
static lsapi_data * s_stderr_data;
static pid_t s_pid = 0;

typedef struct lsapi_body
{
    char        *bodyBuf;  //we put small one into memory, otherwise, into a memory mapping file, and we still use the bodyBuf to access this mapping
    int	        bodyLen;	//expected length got form content-length
    int	        bodyCurrentLen;	//current length by read() readBodyToReqBuf
    int	        curPos;
}lsapi_body;

static lsapi_body	s_body;
static char sTempFile[1024] = {0};

/*
 * static void lsapi_ruby_setenv(const char *name, const char *value)
 * {
 *    if (!name) return;
 * 
 *    if (value && *value)
 *	    ruby_setenv(name, value);
 *    else
 *        ruby_unsetenv(name);
 } *        *
 */


static void lsapi_mark( lsapi_data * data )
{
    rb_gc_mark( data->env );
}
/*
 * static void lsapi_free_data( lsapi_data * data )
 * {
 *   free( data );
 } *        *
 */
static int add_env_rails( const char * pKey, int keyLen, const char * pValue, int valLen,
                          void * arg )
{
    char * p;
    int len;
    /* Fixup some environment variables for rails */
    switch( *pKey )
    {
        case 'Q':
            if ( strcmp( pKey, "QUERY_STRING" ) == 0 )
            {
                if ( !*pValue )
                    return 1;
            }
            break;
        case 'R':
            if (( *(pKey+8) == 'U' )&&( strcmp( pKey, "REQUEST_URI" ) == 0 ))
            {
                p = strchr( pValue, '?' );
                if ( p )
                {
                    len = valLen - ( p - pValue ) - 1;
                    /* 
                     *                valLen = p - pValue;
                     *p++ = 0;
                     */
                }
                else
                {
                    p = (char *)pValue + valLen;
                    len = 0;
                }
                rb_hash_aset( lsapi_env,rb_tainted_str_new("PATH_INFO", 9),
                              rb_tainted_str_new(pValue, p - pValue));
                rb_hash_aset( lsapi_env,rb_tainted_str_new("REQUEST_PATH", 12),
                              rb_tainted_str_new(pValue, p - pValue));
                if ( *p == '?' )
                    ++p;
                rb_hash_aset( lsapi_env,rb_tainted_str_new("QUERY_STRING", 12),
                rb_tainted_str_new(p, len));
            }
            break;
        case 'S':
            if ( strcmp( pKey, "SCRIPT_NAME" ) == 0 )
            {
                pValue = "/";
                valLen = 1;
            }
            break;
        case 'P':
            if ( strcmp( pKey, "PATH_INFO" ) == 0 )
                return 1;
        default:
            break;
    }
    
    /* lsapi_ruby_setenv(pKey, pValue ); */
    
    rb_hash_aset( lsapi_env,rb_tainted_str_new(pKey, keyLen),
                  rb_tainted_str_new(pValue, valLen));
    return 1;
}

static int add_env_no_fix( const char * pKey, int keyLen, const char * pValue, int valLen,
                           void * arg )
{
    rb_hash_aset( lsapi_env,rb_tainted_str_new(pKey, keyLen),
                  rb_tainted_str_new(pValue, valLen));
    return 1;
}

typedef int (*fn_add_env)( const char * pKey, int keyLen, const char * pValue, int valLen,
                           void * arg );

fn_add_env s_fn_add_env = add_env_no_fix;

static void clear_env()
{
    /* rb_funcall( lsapi_env, rb_intern( "clear" ), 0 ); */
    rb_funcall( lsapi_env, rb_intern( "replace" ), 1, env_copy );
}

static void setup_cgi_env( lsapi_data * data )
{
    clear_env();
    
    LSAPI_ForeachHeader_r( data->req, s_fn_add_env, data );
    LSAPI_ForeachEnv_r( data->req, s_fn_add_env, data );
}

static VALUE lsapi_s_accept( VALUE self )
{
    int pid;
    if ( LSAPI_Prefork_Accept_r( &g_req ) == -1 )
        return Qnil;
    else
    {
        if (s_body.bodyBuf != NULL)
            free (s_body.bodyBuf);
        
        s_body.bodyBuf = NULL;
        s_body.bodyLen = -1;
        s_body.bodyCurrentLen = 0;
        s_body.curPos = 0;    
        
        pid = getpid();
        if ( pid != s_pid )
        {
            s_pid = pid;
            rb_funcall( Qnil, rb_intern( "srand" ), 0 );
        }
        
        setup_cgi_env( s_req_data );
        return s_req;
    }
}


static VALUE lsapi_s_accept_new_conn(VALUE self)
{
    if (LSAPI_Accept_Before_Fork(&g_req) == -1 )
        return Qnil;
    else
        return s_req;
}


static VALUE lsapi_s_postfork_child(VALUE self)
{
    LSAPI_Postfork_Child(&g_req);
    return s_req;
}


static VALUE lsapi_s_postfork_parent(VALUE self)
{
    LSAPI_Postfork_Parent(&g_req);
    return s_req;
}


/*
 * static int chdir_file( const char * pFile )
 * {
 *    char * p = strrchr( pFile, '/' );
 *    int ret;
 *    if ( !p )
 *        return -1;
 *p = 0;
 ret = chdir( pFile );
 *p = '/';
 return ret;
 }
 */

static VALUE lsapi_eval_string_wrap(VALUE self, VALUE str)
{
#if RUBY_API_VERSION_CODE < 20700
    if (rb_safe_level() >= 4)
    {
        Check_Type(str, T_STRING);
    }
    else
#endif
    {
        SafeStringValue(str);
    }
    return rb_eval_string_wrap(StringValuePtr(str), NULL);
}

static VALUE lsapi_process( VALUE self )
{
/*    lsapi_data *data;
    const char * pScriptPath;
    Data_Get_Struct(self,lsapi_data, data);
    pScriptPath = LSAPI_GetScriptFileName_r( data->req );
*/
    /*
     *   if ( chdir_file( pScriptPath ) == -1 )
     *   {
     *       lsapi_send_error( 404 );
     *   }
     *   rb_load_file( pScriptPath );
     */
    return Qnil;
}


static VALUE lsapi_putc(VALUE self, VALUE c)
{
    char ch = NUM2CHR(c);
    lsapi_data *data;
    Data_Get_Struct(self,lsapi_data, data);
    if ( (*data->fn_write)( data->req, &ch, 1 ) == 1 )
        return c;
    else
        return INT2NUM( EOF );
}


static VALUE lsapi_write( VALUE self, VALUE str )
{
    lsapi_data *data;
    int len;
    Data_Get_Struct(self,lsapi_data, data);
    /*    len = LSAPI_Write_r( data->req, RSTRING_PTR(str), RSTRING_LEN(str) ); */
    if (TYPE(str) != T_STRING)
        str = rb_obj_as_string(str);
    len = (*data->fn_write)( data->req, RSTRING_PTR(str), RSTRING_LEN(str) );
    return INT2NUM( len );
}

static VALUE lsapi_print( int argc, VALUE *argv, VALUE out )
{
    int i;
    VALUE line;
    
    /* if no argument given, print `$_' */
    if (argc == 0)
    {
        argc = 1;
        line = rb_lastline_get();
        argv = &line;
    }
    for (i = 0; i<argc; i++)
    {
        if (!NIL_P(rb_output_fs) && i>0)
        {
            lsapi_write(out, rb_output_fs);
        }
        switch (TYPE(argv[i]))
        {
            case T_NIL:
                lsapi_write(out, rb_str_new2("nil"));
                break;
            default:
                lsapi_write(out, argv[i]);
                break;
        }
    }
    if (!NIL_P(rb_output_rs))
    {
        lsapi_write(out, rb_output_rs);
    }
    
    return Qnil;
}

static VALUE lsapi_printf(int argc, VALUE *argv, VALUE out)
{
    lsapi_write(out, rb_f_sprintf(argc, argv));
    return Qnil;
}

static VALUE lsapi_puts _((int, VALUE*, VALUE));

#if RUBY_API_VERSION_CODE >= 10900
static VALUE lsapi_puts_ary(VALUE ary, VALUE out, int recur )
{
    VALUE tmp;
    long i;
    
    if (recur)
    {
        tmp = rb_str_new2("[...]");
        rb_io_puts(1, &tmp, out);
        return Qnil;
    }
    for (i=0; i<RARRAY_LEN(ary); i++) 
    {
        tmp = RARRAY_PTR(ary)[i];
        rb_io_puts(1, &tmp, out);
    }
    return Qnil;
    
}
#else
static VALUE lsapi_puts_ary(VALUE ary, VALUE out)
{
    VALUE tmp;
    int i;
    
    for (i=0; i<RARRAY_LEN(ary); i++)
    {
        tmp = RARRAY_PTR(ary)[i];
        if (rb_inspecting_p(tmp))
        {
            tmp = rb_str_new2("[...]");
        }
        lsapi_puts(1, &tmp, out);
    }
    return Qnil;
}
#endif

static VALUE lsapi_puts(int argc, VALUE *argv, VALUE out)
{
    int i;
    VALUE line;
    
    /* if no argument given, print newline. */
    if (argc == 0)
    {
        lsapi_write(out, rb_default_rs);
        return Qnil;
    }
    for (i=0; i<argc; i++)
    {
        switch (TYPE(argv[i]))
        {
            case T_NIL:
                line = rb_str_new2("nil");
                break;
            case T_ARRAY:
#if RUBY_API_VERSION_CODE >= 10900
                rb_exec_recursive(lsapi_puts_ary, argv[i], out);
#else
                rb_protect_inspect(lsapi_puts_ary, argv[i], out);
#endif
                continue;
            default:
                line = argv[i];
                break;
        }
        line = rb_obj_as_string(line);
        lsapi_write(out, line);
        if (*( RSTRING_PTR(line) + RSTRING_LEN(line) - 1 ) != '\n')
        {
            lsapi_write(out, rb_default_rs);
        }
    }
    
    return Qnil;
}


static VALUE lsapi_addstr(VALUE out, VALUE str)
{
    lsapi_write(out, str);
    return out;
}

static VALUE lsapi_flush( VALUE self )
{
    /*
     *    lsapi_data *data;
     *    Data_Get_Struct(self,lsapi_data, data);
     */
    LSAPI_Flush_r( &g_req ); 
    return Qnil;
}

static VALUE lsapi_getc( VALUE self )
{
    int ch;
    /*
     *    lsapi_data *data;
     *    Data_Get_Struct(self,lsapi_data, data);
     */
#if RUBY_API_VERSION_CODE < 20700
    if (rb_safe_level() >= 4 && !OBJ_TAINTED(self))
    {
        rb_raise(rb_eSecurityError, "Insecure: operation on untainted IO");
    }
#endif
    ch = LSAPI_ReqBodyGetChar_r( &g_req );
    if ( ch == EOF )
        return Qnil;
    return INT2NUM( ch );
}

static inline int isBodyWriteToFile()
{
    return ((s_body.bodyLen >= MAX_BODYBUF_LENGTH)? (1): (0));
}

//create a temp file and open it, if failed, fd = -1
static inline int createTempFile()
{
    int fd = -1;
    char *sfn = strdup(sTempFile);
    
    if ((fd = mkstemp(sfn)) == -1)
    {
        fprintf(stderr, "%s: %s\n", sfn, strerror(errno));
    }
    else
        unlink(sfn);
    
    free(sfn);
    return fd;
}

//return 1 if error occured!
//if already created, always OK (0)
static int createBodyBuf()
{
    int fd = -1;
    if (s_body.bodyLen == -1)
    {
        s_body.bodyLen = LSAPI_GetReqBodyLen_r(&g_req);
        //Error if get a zeor length, should not happen 
        if (s_body.bodyLen < 0)
        {
            //Wrong bode length will be treated as 0
            s_body.bodyLen = 0;
        }
        
        if (s_body.bodyLen > 0) 
        {
            if (isBodyWriteToFile())
            {
                //create file mapping
                fd = createTempFile();
                if (fd == -1)
                {
                    return 1;
                }
                if (ftruncate(fd, s_body.bodyLen) == 0)
                {
                    perror("ftruncate() failed. \n");
                    close(fd);
                    return 1;
                }
                s_body.bodyBuf = mmap(NULL, s_body.bodyLen, PROT_READ | PROT_WRITE, MAP_SHARED, fd, 0);
                if (s_body.bodyBuf == MAP_FAILED)
                {
                    perror("File mapping failed. \n");
                    close(fd);
                    return 1;
                }
                close(fd);  //close since needn't it anymore
            }
            else
            {
                s_body.bodyBuf = (char *)calloc(s_body.bodyLen, sizeof(char));
                if (s_body.bodyBuf == NULL)
                {
                    perror("Memory calloc error");
                    return 1;
                }
            }
        }
    }

    return 0;   
}

static inline int isAllBodyRead()
{
    return (s_body.bodyCurrentLen < s_body.bodyLen)? 0 : 1;
}

static inline int isEofBodyBuf()
{
    return (s_body.curPos < s_body.bodyLen) ? 0 : 1;
}
//try to read length as ti