 v = "s#{strvars.size + 1}"
        strvars << v
        v
      }
      unless strvars.empty?
        prepare << "char " << strvars.map {|v| "#{v}[1024]"}.join(", ") << "; "
      end
    when nil
      call = ""
    else
      call = "#{func}()"
      decltype = proc {|x| "void ((*#{x})())"}
    end
    if opt and !opt.empty?
      [[:to_str], [:join, " "], [:to_s]].each do |meth, *args|
        if opt.respond_to?(meth)
          break opt = opt.__send__(meth, *args)
        end
      end
      opt = "#{opt} #{libs}"
    else
      opt = libs
    end
    decltype && try_link(<<"SRC", opt, &b) or
#{headers}
/*top*/
extern int t(void);
#{MAIN_DOES_NOTHING 't'}
int t(void) { #{decltype["volatile p"]}; p = (#{decltype[]})#{func}; return !p; }
SRC
    call && try_link(<<"SRC", opt, &b)
#{headers}
/*top*/
extern int t(void);
#{MAIN_DOES_NOTHING 't'}
#{"extern void #{call};" if decltype}
int t(void) { #{prepare}#{call}; return 0; }
SRC
  end

  # You should use +have_var+ rather than +try_var+.
  def try_var(var, headers = nil, opt = "", &b)
    headers = cpp_include(headers)
    try_compile(<<"SRC", opt, &b)
#{headers}
/*top*/
extern int t(void);
#{MAIN_DOES_NOTHING 't'}
int t(void) { const volatile void *volatile p; p = &(&#{var})[0]; return !p; }
SRC
  end

  # :startdoc:

  # Returns whether or not the +src+ can be preprocessed with the C
  # preprocessor and matches with +pat+.
  #
  # If a block given, it is called with the source before compilation. You can
  # modify the source in the block.
  #
  # [+pat+] a Regexp or a String
  # [+src+] a String which contains a C source
  # [+opt+] a String which contains preprocessor options
  #
  # NOTE: When pat is a Regexp the matching will be checked in process,
  # otherwise egrep(1) will be invoked to check it.
  def egrep_cpp(pat, src, opt = "", &b)
    src = create_tmpsrc(src, &b)
    xpopen(cpp_command('', opt)) do |f|
      if Regexp === pat
        puts("    ruby -ne 'print if #{pat.inspect}'")
        f.grep(pat) {|l|
          puts "#{f.lineno}: #{l}"
          return true
        }
        false
      else
        puts("    egrep '#{pat}'")
        begin
          stdin = $stdin.dup
          $stdin.reopen(f)
          system("egrep", pat)
        ensure
          $stdin.reopen(stdin)
        end
      end
    end
  ensure
    MakeMakefile.rm_f "#{CONFTEST}*"
    log_src(src)
  end

  # :stopdoc:

  # This is used internally by the have_macro? method.
  def macro_defined?(macro, src, opt = "", &b)
    src = src.sub(/[^\n]\z/, "\\&\n")
    try_compile(src + <<"SRC", opt, &b)
/*top*/
#ifndef #{macro}
# error
|:/ === #{macro} undefined === /:|
#endif
SRC
  end

  # Returns whether or not:
  # * the +src+ can be compiled as a C source,
  # * the result object can be linked with its depending libraries
  #   successfully,
  # * the linked file can be invoked as an executable
  # * and the executable exits successfully
  #
  # +opt+ is passed to the linker as options. Note that <tt>$CFLAGS</tt> and
  # <tt>$LDFLAGS</tt> are also passed to the linker.
  #
  # If a block given, it is called with the source before compilation. You can
  # modify the source in the block.
  #
  # [+src+] a String which contains a C source
  # [+opt+] a String which contains linker options
  #
  # Returns true when the executable exits successfully, false when it fails,
  # or nil when preprocessing, compilation or link fails.
  def try_run(src, opt = "", &b)
    raise "cannot run test program while cross compiling" if CROSS_COMPILING
   