ruby/English.rb                                                                                     0000644                 00000013050 15040313425 0007437 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
#  Include the English library file in a Ruby script, and you can
#  reference the global variables such as <code>$_</code> using less
#  cryptic names, listed below.
#
#  Without 'English':
#
#      $\ = ' -- '
#      "waterbuffalo" =~ /buff/
#      print $', $$, "\n"
#
#  With English:
#
#      require "English"
#
#      $OUTPUT_FIELD_SEPARATOR = ' -- '
#      "waterbuffalo" =~ /buff/
#      print $POSTMATCH, $PID, "\n"
#
#  Below is a full list of descriptive aliases and their associated global
#  variable:
#
#  $ERROR_INFO::              $!
#  $ERROR_POSITION::          $@
#  $FS::                      $;
#  $FIELD_SEPARATOR::         $;
#  $OFS::                     $,
#  $OUTPUT_FIELD_SEPARATOR::  $,
#  $RS::                      $/
#  $INPUT_RECORD_SEPARATOR::  $/
#  $ORS::                     $\
#  $OUTPUT_RECORD_SEPARATOR:: $\
#  $INPUT_LINE_NUMBER::       $.
#  $NR::                      $.
#  $LAST_READ_LINE::          $_
#  $DEFAULT_OUTPUT::          $>
#  $DEFAULT_INPUT::           $<
#  $PID::                     $$
#  $PROCESS_ID::              $$
#  $CHILD_STATUS::            $?
#  $LAST_MATCH_INFO::         $~
#  $ARGV::                    $*
#  $MATCH::                   $&
#  $PREMATCH::                $`
#  $POSTMATCH::               $'
#  $LAST_PAREN_MATCH::        $+
#
module English end if false

# The exception object passed to +raise+.
alias $ERROR_INFO              $!

# The stack backtrace generated by the last
# exception. See Kernel#caller for details. Thread local.
alias $ERROR_POSITION          $@

# The default separator pattern used by String#split.  May be set from
# the command line using the <code>-F</code> flag.
alias $FS                      $;
alias $FIELD_SEPARATOR         $;

# The separator string output between the parameters to methods such
# as Kernel#print and Array#join. Defaults to +nil+, which adds no
# text.

# The separator string output between the parameters to methods such
# as Kernel#print and Array#join. Defaults to +nil+, which adds no
# text.
alias $OFS                     $,
alias $OUTPUT_FIELD_SEPARATOR  $,

# The input record separator (newline by default). This is the value
# that routines such as Kernel#gets use to determine record
# boundaries. If set to +nil+, +gets+ will read the entire file.
alias $RS                      $/
alias $INPUT_RECORD_SEPARATOR  $/

# The string appended to the output of every call to methods such as
# Kernel#print and IO#write. The default value is +nil+.
alias $ORS                     $\
alias $OUTPUT_RECORD_SEPARATOR $\

# The number of the last line read from the current input file.
alias $NR                      $.
alias $INPUT_LINE_NUMBER       $.

# The last line read by Kernel#gets or
# Kernel#readline. Many string-related functions in the
# Kernel module operate on <code>$_</code> by default. The variable is
# local to the current scope. Thread local.
alias $LAST_READ_LINE          $_

# The destination of output for Kernel#print
# and Kernel#printf. The default value is
# <code>$stdout</code>.
alias $DEFAULT_OUTPUT          $>

# An object that provides access to the concatenation
# of the contents of all the files
# given as command-line arguments, or <code>$stdin</code>
# (in the case where there are no
# arguments). <code>$<</code> supports methods similar to a
# File object:
# +inmode+, +close+,
# <code>closed?</code>, +each+,
# <code>each_byte</code>, <code>each_line</code>,
# +eof+, <code>eof?</code>, +file+,
# +filename+, +fileno+,
# +getc+, +gets+, +lineno+,
# <code>lineno=</code>, +path+,
# +pos+, <code>pos=</code>,
# +read+, +readchar+,
# +readline+, +readlines+,
# +rewind+, +seek+, +skip+,
# +tell+, <code>to_a</code>, <code>to_i</code>,
# <code>to_io</code>, <code>to_s</code>, along with the
# methods in Enumerable. The method +file+
# returns a File object for the file currently
# being read. This may change as <code>$<</code> reads
# through the files on the command line. Read only.
alias $DEFAULT_INPUT           $<

# The process number of the program being executed. Read only.
alias $PID                     $$
alias $PROCESS_ID              $$

# The exit status of the last child process to terminate. Read
# only. Thread local.
alias $CHILD_STATUS            $?

# A +MatchData+ object that encapsulates the results of a successful
# pattern match. The variables <code>$&</code>, <code>$`</code>, <code>$'</code>,
# and <code>$1</code> to <code>$9</code> are all derived from
# <code>$~</code>. Assigning to <code>$~</code> changes the values of these
# derived variables.  This variable is local to the current
# scope.
alias $LAST_MATCH_INFO         $~

# An array of strings containing the command-line
# options from the invocation of the program. Options
# used by the Ruby interpreter will have been
# removed. Read only. Also known simply as +ARGV+.
alias $ARGV                    $*

# The string matched by the last successful pattern
# match. This variable is local to the current
# scope. Read only.
alias $MATCH                   $&

# The string preceding the match in the last
# successful pattern match. This variable is local to
# the current scope. Read only.
alias $PREMATCH                $`

# The string following the match in the last
# successful pattern match. This variable is local to
# the current scope. Read only.
alias $POSTMATCH               $'

# The contents of the highest-numbered group matched in the last
# successful pattern match. Thus, in <code>"cat" =~ /(c|a)(t|z)/</code>,
# <code>$+</code> will be set to "t".  This variable is local to the
# current scope. Read only.
alias $LAST_PAREN_MATCH        $+
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ruby/cgi/cookie.rb                                                                                  0000644                 00000015116 15040313425 0010066 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
require_relative 'util'
class CGI
  # Class representing an HTTP cookie.
  #
  # In addition to its specific fields and methods, a Cookie instance
  # is a delegator to the array of its values.
  #
  # See RFC 2965.
  #
  # == Examples of use
  #   cookie1 = CGI::Cookie.new("name", "value1", "value2", ...)
  #   cookie1 = CGI::Cookie.new("name" => "name", "value" => "value")
  #   cookie1 = CGI::Cookie.new('name'     => 'name',
  #                             'value'    => ['value1', 'value2', ...],
  #                             'path'     => 'path',   # optional
  #                             'domain'   => 'domain', # optional
  #                             'expires'  => Time.now, # optional
  #                             'secure'   => true,     # optional
  #                             'httponly' => true      # optional
  #                             )
  #
  #   cgi.out("cookie" => [cookie1, cookie2]) { "string" }
  #
  #   name     = cookie1.name
  #   values   = cookie1.value
  #   path     = cookie1.path
  #   domain   = cookie1.domain
  #   expires  = cookie1.expires
  #   secure   = cookie1.secure
  #   httponly = cookie1.httponly
  #
  #   cookie1.name     = 'name'
  #   cookie1.value    = ['value1', 'value2', ...]
  #   cookie1.path     = 'path'
  #   cookie1.domain   = 'domain'
  #   cookie1.expires  = Time.now + 30
  #   cookie1.secure   = true
  #   cookie1.httponly = true
  class Cookie < Array
    @@accept_charset="UTF-8" unless defined?(@@accept_charset)

    TOKEN_RE = %r"\A[[!-~]&&[^()<>@,;:\\\"/?=\[\]{}]]+\z"
    PATH_VALUE_RE = %r"\A[[ -~]&&[^;]]*\z"
    DOMAIN_VALUE_RE = %r"\A\.?(?<label>(?!-)[-A-Za-z0-9]+(?<!-))(?:\.\g<label>)*\z"

    # Create a new CGI::Cookie object.
    #
    # :call-seq:
    #   Cookie.new(name_string,*value)
    #   Cookie.new(options_hash)
    #
    # +name_string+::
    #   The name of the cookie; in this form, there is no #domain or
    #   #expiration.  The #path is gleaned from the +SCRIPT_NAME+ environment
    #   variable, and #secure is false.
    # <tt>*value</tt>::
    #   value or list of values of the cookie
    # +options_hash+::
    #   A Hash of options to initialize this Cookie.  Possible options are:
    #
    #   name:: the name of the cookie.  Required.
    #   value:: the cookie's value or list of values.
    #   path:: the path for which this cookie applies.  Defaults to
    #          the value of the +SCRIPT_NAME+ environment variable.
    #   domain:: the domain for which this cookie applies.
    #   expires:: the time at which this cookie expires, as a +Time+ object.
    #   secure:: whether this cookie is a secure cookie or not (default to
    #            false).  Secure cookies are only transmitted to HTTPS
    #            servers.
    #   httponly:: whether this cookie is a HttpOnly cookie or not (default to
    #            false).  HttpOnly cookies are not available to javascript.
    #
    #   These keywords correspond to attributes of the cookie object.
    def initialize(name = "", *value)
      @domain = nil
      @expires = nil
      if name.kind_of?(String)
        self.name = name
        self.path = (%r|\A(.*/)| =~ ENV["SCRIPT_NAME"] ? $1 : "")
        @secure = false
        @httponly = false
        return super(value)
      end

      options = name
      unless options.has_key?("name")
        raise ArgumentError, "`name' required"
      end

      self.name = options["name"]
      value = Array(options["value"])
      # simple support for IE
      self.path = options["path"] || (%r|\A(.*/)| =~ ENV["SCRIPT_NAME"] ? $1 : "")
      self.domain = options["domain"]
      @expires = options["expires"]
      @secure = options["secure"] == true
      @httponly = options["httponly"] == true

      super(value)
    end

    # Name of this cookie, as a +String+
    attr_reader :name
    # Set name of this cookie
    def name=(str)
      if str and !TOKEN_RE.match?(str)
        raise ArgumentError, "invalid name: #{str.dump}"
      end
      @name = str
    end

    # Path for which this cookie applies, as a +String+
    attr_reader :path
    # Set path for which this cookie applies
    def path=(str)
      if str and !PATH_VALUE_RE.match?(str)
        raise ArgumentError, "invalid path: #{str.dump}"
      end
      @path = str
    end

    # Domain for which this cookie applies, as a +String+
    attr_reader :domain
    # Set domain for which this cookie applies
    def domain=(str)
      if str and ((str = str.b).bytesize > 255 or !DOMAIN_VALUE_RE.match?(str))
        raise ArgumentError, "invalid domain: #{str.dump}"
      end
      @domain = str
    end

    # Time at which this cookie expires, as a +Time+
    attr_accessor :expires
    # True if this cookie is secure; false otherwise
    attr_reader :secure
    # True if this cookie is httponly; false otherwise
    attr_reader :httponly

    # Returns the value or list of values for this cookie.
    def value
      self
    end

    # Replaces the value of this cookie with a new value or list of values.
    def value=(val)
      replace(Array(val))
    end

    # Set whether the Cookie is a secure cookie or not.
    #
    # +val+ must be a boolean.
    def secure=(val)
      @secure = val if val == true or val == false
      @secure
    end

    # Set whether the Cookie is a httponly cookie or not.
    #
    # +val+ must be a boolean.
    def httponly=(val)
      @httponly = !!val
    end

    # Convert the Cookie to its string representation.
    def to_s
      val = collect{|v| CGI.escape(v) }.join("&")
      buf = "#{@name}=#{val}".dup
      buf << "; domain=#{@domain}" if @domain
      buf << "; path=#{@path}"     if @path
      buf << "; expires=#{CGI.rfc1123_date(@expires)}" if @expires
      buf << "; secure"            if @secure
      buf << "; HttpOnly"          if @httponly
      buf
    end

    # Parse a raw cookie string into a hash of cookie-name=>Cookie
    # pairs.
    #
    #   cookies = CGI::Cookie.parse("raw_cookie_string")
    #     # { "name1" => cookie1, "name2" => cookie2, ... }
    #
    def self.parse(raw_cookie)
      cookies = Hash.new([])
      return cookies unless raw_cookie

      raw_cookie.split(/;\s?/).each do |pairs|
        name, values = pairs.split('=',2)
        next unless name and values
        values ||= ""
        values = values.split('&').collect{|v| CGI.unescape(v,@@accept_charset) }
        if cookies.has_key?(name)
          cookies[name].concat(values)
        else
          cookies[name] = Cookie.new(name, *values)
        end
      end

      cookies
    end

    # A summary of cookie string.
    def inspect
      "#<CGI::Cookie: #{self.to_s.inspect}>"
    end

  end # class Cookie
end


                                                                                                                                                                                                                                                                                                                                                                                                                                                  ruby/cgi/html.rb                                                                                    0000644                 00000104217 15040313425 0007562 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
class CGI
  # Base module for HTML-generation mixins.
  #
  # Provides methods for code generation for tags following
  # the various DTD element types.
  module TagMaker # :nodoc:

    # Generate code for an element with required start and end tags.
    #
    #   - -
    def nn_element(element, attributes = {})
      s = nOE_element(element, attributes)
      if block_given?
        s << yield.to_s
      end
      s << "</#{element.upcase}>"
    end

    def nn_element_def(attributes = {}, &block)
      nn_element(__callee__, attributes, &block)
    end

    # Generate code for an empty element.
    #
    #   - O EMPTY
    def nOE_element(element, attributes = {})
      attributes={attributes=>nil} if attributes.kind_of?(String)
      s = "<#{element.upcase}".dup
      attributes.each do|name, value|
        next unless value
        s << " "
        s << CGI.escapeHTML(name.to_s)
        if value != true
          s << '="'
          s << CGI.escapeHTML(value.to_s)
          s << '"'
        end
      end
      s << ">"
    end

    def nOE_element_def(attributes = {}, &block)
      nOE_element(__callee__, attributes, &block)
    end


    # Generate code for an element for which the end (and possibly the
    # start) tag is optional.
    #
    #   O O or - O
    def nO_element(element, attributes = {})
      s = nOE_element(element, attributes)
      if block_given?
        s << yield.to_s
        s << "</#{element.upcase}>"
      end
      s
    end

    def nO_element_def(attributes = {}, &block)
      nO_element(__callee__, attributes, &block)
    end

  end # TagMaker


  # Mixin module providing HTML generation methods.
  #
  # For example,
  #   cgi.a("http://www.example.com") { "Example" }
  #     # => "<A HREF=\"http://www.example.com\">Example</A>"
  #
  # Modules Html3, Html4, etc., contain more basic HTML-generation methods
  # (+#title+, +#h1+, etc.).
  #
  # See class CGI for a detailed example.
  #
  module HtmlExtension


    # Generate an Anchor element as a string.
    #
    # +href+ can either be a string, giving the URL
    # for the HREF attribute, or it can be a hash of
    # the element's attributes.
    #
    # The body of the element is the string returned by the no-argument
    # block passed in.
    #
    #   a("http://www.example.com") { "Example" }
    #     # => "<A HREF=\"http://www.example.com\">Example</A>"
    #
    #   a("HREF" => "http://www.example.com", "TARGET" => "_top") { "Example" }
    #     # => "<A HREF=\"http://www.example.com\" TARGET=\"_top\">Example</A>"
    #
    def a(href = "") # :yield:
      attributes = if href.kind_of?(String)
                     { "HREF" => href }
                   else
                     href
                   end
      super(attributes)
    end

    # Generate a Document Base URI element as a String.
    #
    # +href+ can either by a string, giving the base URL for the HREF
    # attribute, or it can be a has of the element's attributes.
    #
    # The passed-in no-argument block is ignored.
    #
    #   base("http://www.example.com/cgi")
    #     # => "<BASE HREF=\"http://www.example.com/cgi\">"
    def base(href = "") # :yield:
      attributes = if href.kind_of?(String)
                     { "HREF" => href }
                   else
                     href
                   end
      super(attributes)
    end

    # Generate a BlockQuote element as a string.
    #
    # +cite+ can either be a string, give the URI for the source of
    # the quoted text, or a hash, giving all attributes of the element,
    # or it can be omitted, in which case the element has no attributes.
    #
    # The body is provided by the passed-in no-argument block
    #
    #   blockquote("http://www.example.com/quotes/foo.html") { "Foo!" }
    #     #=> "<BLOCKQUOTE CITE=\"http://www.example.com/quotes/foo.html\">Foo!</BLOCKQUOTE>
    def blockquote(cite = {})  # :yield:
      attributes = if cite.kind_of?(String)
                     { "CITE" => cite }
                   else
                     cite
                   end
      super(attributes)
    end


    # Generate a Table Caption element as a string.
    #
    # +align+ can be a string, giving the alignment of the caption
    # (one of top, bottom, left, or right).  It can be a hash of
    # all the attributes of the element.  Or it can be omitted.
    #
    # The body of the element is provided by the passed-in no-argument block.
    #
    #   caption("left") { "Capital Cities" }
    #     # => <CAPTION ALIGN=\"left\">Capital Cities</CAPTION>
    def caption(align = {}) # :yield:
      attributes = if align.kind_of?(String)
                     { "ALIGN" => align }
                   else
                     align
                   end
      super(attributes)
 