  #     expect(lines[0].to_s).to eq(source)
    #     expect(lines[1].to_s).to eq("")
    #
    # The one known case this doesn't handle is:
    #
    #     Ripper.lex <<~EOM
    #       a &&
    #        b ||
    #        c
    #     EOM
    #
    # For some reason this introduces `on_ignore_newline` but with BEG type
    #
    def join_consecutive!
      consecutive_groups = @document.select(&:ignore_newline_not_beg?).map do |code_line|
        take_while_including(code_line.index..) do |line|
          line.ignore_newline_not_beg?
        end
      end

      join_groups(consecutive_groups)
      self
    end

    # Join lines with a trailing slash
    #
    #     source = <<~'EOM'
    #       it "code can be split" \
    #          "across multiple lines" do
    #     EOM
    #
    #     lines = CleanDocument.new(source: source).join_consecutive!.lines
    #     expect(lines[0].to_s).to eq(source)
    #     expect(lines[1].to_s).to eq("")
    def join_trailing_slash!
      trailing_groups = @document.select(&:trailing_slash?).map do |code_line|
        take_while_including(code_line.index..) { |x| x.trailing_slash? }
      end
      join_groups(trailing_groups)
      self
    end

    # Helper method for joining "groups" of lines
    #
    # Input is expected to be type Array<Array<CodeLine>>
    #
    # The outer array holds the various "groups" while the
    # inner array holds code lines.
    #
    # All code lines are "joined" into the first line in
    # their group.
    #
    # To preserve document size, empty lines are placed
    # in the place of the lines that were "joined"
    def join_groups(groups)
      groups.each do |lines|
        line = lines.first

        # Handle the case of multiple groups in a row
        # if one is already replaced, move on
        next if @document[line.index].empty?

        # Join group into the first line
        @document[line.index] = CodeLine.new(
          lex: lines.map(&:lex).flatten,
          line: lines.join,
          index: line.index
        )

        # Hide the rest of the lines
        lines[1..].each do |line|
          # The above lines already have newlines in them, if add more
          # then there will be double newline, use an empty line instead
          @document[line.index] = CodeLine.new(line: "", index: line.index, lex: [])
        end
      end
      self
    end

    # Helper method for grabbing elements from document
    #
    # Like `take_while` except when it stops
    # iterating, it also returns the line
    # that caused it to stop
    def take_while_including(range = 0..)
      take_next_and_stop = false
      @document[range].take_while do |line|
        next if take_next_and_stop

        take_next_and_stop = !(yield line)
        true
      end
    end
  end
end
                                                                                                                                                                                                                                                                                 ruby/syntax_suggest/parse_blocks_from_indent_line.rb                                                0000644                 00000003001 15040313425 0017172 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # This class is responsible for generating initial code blocks
  # that will then later be expanded.
  #
  # The biggest concern when guessing code blocks, is accidentally
  # grabbing one that contains only an "end". In this example:
  #
  #   def dog
  #     begonn # misspelled `begin`
  #     puts "bark"
  #     end
  #   end
  #
  # The following lines would be matched (from bottom to top):
  #
  #   1) end
  #
  #   2) puts "bark"
  #      end
  #
  #   3) begonn
  #      puts "bark"
  #      end
  #
  # At this point it has no where else to expand, and it will yield this inner
  # code as a block
  class ParseBlocksFromIndentLine
    attr_reader :code_lines

    def initialize(code_lines:)
      @code_lines = code_lines
    end

    # Builds blocks from bottom up
    def each_neighbor_block(target_line)
      scan = AroundBlockScan.new(code_lines: code_lines, block: CodeBlock.new(lines: target_line))
        .force_add_empty
        .force_add_hidden
        .scan_while { |line| line.indent >= target_line.indent }

      neighbors = scan.code_block.lines

      block = CodeBlock.new(lines: neighbors)
      if neighbors.length <= 2 || block.valid?
        yield block
      else
        until neighbors.empty?
          lines = [neighbors.pop]
          while (block = CodeBlock.new(lines: lines)) && block.invalid? && neighbors.any?
            lines.prepend neighbors.pop
          end

          yield block if block
        end
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ruby/syntax_suggest/capture/falling_indent_lines.rb                                                 0000644                 00000003127 15040313425 0016753 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  module Capture
    # Shows the context around code provided by "falling" indentation
    #
    # If this is the original code lines:
    #
    #   class OH
    #     def hello
    #       it "foo" do
    #     end
    #   end
    #
    # And this is the line that is captured
    #
    #       it "foo" do
    #
    # It will yield its surrounding context:
    #
    #   class OH
    #     def hello
    #     end
    #   end
    #
    # Example:
    #
    #   FallingIndentLines.new(
    #       block: block,
    #       code_lines: @code_lines
    #   ).call do |line|
    #     @lines_to_output << line
    #   end
    #
    class FallingIndentLines
      def initialize(code_lines:, block:)
        @lines = nil
        @scanner = ScanHistory.new(code_lines: code_lines, block: block)
        @original_indent = block.current_indent
      end

      def call(&yieldable)
        last_indent_up = @original_indent
        last_indent_down = @original_indent

        @scanner.commit_if_changed
        @scanner.scan(
          up: ->(line, _, _) {
            next true if line.empty?

            if line.indent < last_indent_up
              yieldable.call(line)
              last_indent_up = line.indent
            end
            true
          },
          down: ->(line, _, _) {
            next true if line.empty?

            if line.indent < last_indent_down
              yieldable.call(line)
              last_indent_down = line.indent
            end
            true
          }
        )
        @scanner.stash_changes
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                         ruby/syntax_suggest/capture/before_after_keyword_ends.rb                                            0000644                 00000004244 15040313425 0020005 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  module Capture
    # Shows surrounding kw/end pairs
    #
    # The purpose of showing these extra pairs is due to cases
    # of ambiguity when only one visible line is matched.
    #
    # For example:
    #
    #     1  class Dog
    #     2    def bark
    #     4    def eat
    #     5    end
    #     6  end
    #
    # In this case either line 2 could be missing an `end` or
    # line 4 was an extra line added by mistake (it happens).
    #
    # When we detect the above problem it shows the issue
    # as only being on line 2
    #
    #     2    def bark
    #
    # Showing "neighbor" keyword pairs gives extra context:
    #
    #     2    def bark
    #     4    def eat
    #     5    end
    #
    #
    # Example:
    #
    #   lines = BeforeAfterKeywordEnds.new(
    #     block: block,
    #     code_lines: code_lines
    #   ).call()
    #
    class BeforeAfterKeywordEnds
      def initialize(code_lines:, block:)
        @scanner = ScanHistory.new(code_lines: code_lines, block: block)
        @original_indent = block.current_indent
      end

      def call
        lines = []

        @scanner.scan(
          up: ->(line, kw_count, end_count) {
            next true if line.empty?
            break if line.indent < @original_indent
            next true if line.indent != @original_indent

            # If we're going up and have one complete kw/end pair, stop
            if kw_count != 0 && kw_count == end_count
              lines << line
              break
            end

            lines << line if line.is_kw? || line.is_end?
            true
          },
          down: ->(line, kw_count, end_count) {
            next true if line.empty?
            break if line.indent < @original_indent
            next true if line.indent != @original_indent

            # if we're going down and have one complete kw/end pair,stop
            if kw_count != 0 && kw_count == end_count
              lines << line
              break
            end

            lines << line if line.is_kw? || line.is_end?
            true
          }
        )
        @scanner.stash_changes

        lines
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                            ruby/syntax_suggest/code_block.rb                                                                   0000644                 00000004207 15040313425 0013225 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Multiple lines form a singular CodeBlock
  #
  # Source code is made of multiple CodeBlocks.
  #
  # Example:
  #
  #   code_block.to_s # =>
  #     #   def foo
  #     #     puts "foo"
  #     #   end
  #
  #   code_block.valid? # => true
  #   code_block.in_valid? # => false
  #
  #
  class CodeBlock
    UNSET = Object.new.freeze
    attr_reader :lines, :starts_at, :ends_at

    def initialize(lines: [])
      @lines = Array(lines)
      @valid = UNSET
      @deleted = false
      @starts_at = @lines.first.number
      @ends_at = @lines.last.number
    end

    def delete
      @deleted = true
    end

    def deleted?
      @deleted
    end

    def visible_lines
      @lines.select(&:visible?).select(&:not_empty?)
    end

    def mark_invisible
      @lines.map(&:mark_invisible)
    end

    def is_end?
      to_s.strip == "end"
    end

    def hidden?
      @lines.all?(&:hidden?)
    end

    # This is used for frontier ordering, we are searching from
    # the largest indentation to the smallest. This allows us to
    # populate an array with multiple code blocks then call `sort!`
    # on it without having to specify the sorting criteria
    def <=>(other)
      out = current_indent <=> other.current_indent
      return out if out != 0

      # Stable sort
      starts_at <=> other.starts_at
    end

    def current_indent
      @current_indent ||= lines.select(&:not_empty?).map(&:indent).min || 0
    end

    def invalid?
      !valid?
    end

    def valid?
      if @valid == UNSET
        # Performance optimization
        #
        # If all the lines were previously hidden
        # and we expand to capture additional empty
        # lines then the result cannot be invalid
        #
        # That means there's no reason to re-check all
        # lines with the parser (which is expensive).
        # Benchmark in commit message
        @valid = if lines.all? { |l| l.hidden? || l.empty? }
          true
        else
          SyntaxSuggest.valid?(lines.map(&:original).join)
        end
      else
        @valid
      end
    end

    def to_s
      @lines.join
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                         ruby/syntax_suggest/display_code_with_line_numbers.rb                                               0000644                 00000003424 15040313425 0017375 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Outputs code with highlighted lines
  #
  # Whatever is passed to this class will be rendered
  # even if it is "marked invisible" any filtering of
  # output should be done before calling this class.
  #
  #   DisplayCodeWithLineNumbers.new(
  #     lines: lines,
  #     highlight_lines: [lines[2], lines[3]]
  #   ).call
  #   # =>
  #       1
  #       2  def cat
  #     > 3    Dir.chdir
  #     > 4    end
  #       5  end
  #       6
  class DisplayCodeWithLineNumbers
    TERMINAL_HIGHLIGHT = "\e[1;3m" # Bold, italics
    TERMINAL_END = "\e[0m"

    def initialize(lines:, highlight_lines: [], terminal: false)
      @lines = Array(lines).sort
      @terminal = terminal
      @highlight_line_hash = Array(highlight_lines).each_with_object({}) { |line, h| h[line] = true }
      @digit_count = @lines.last&.line_number.to_s.length
    end

    def call
      @lines.map do |line|
        format_line(line)
      end.join
    end

    private def format_line(code_line)
      # Handle trailing slash lines
      code_line.original.lines.map.with_index do |contents, i|
        format(
          empty: code_line.empty?,
          number: (code_line.number + i).to_s,
          contents: contents,
          highlight: @highlight_line_hash[code_line]
        )
      end.join
    end

    private def format(contents:, number:, empty:, highlight: false)
      string = +""
      string << if highlight
        "> "
      else
        "  "
      end

      string << number.rjust(@digit_count).to_s
      if empty
        string << contents
      else
        string << "  "
        string << TERMINAL_HIGHLIGHT if @terminal && highlight
        string << contents
        string << TERMINAL_END if @terminal
      end
      string
    end
  end
end
                                                                                                                                                                                                                                            ruby/syntax_suggest/lex_all.rb                                                                      0000644                 00000003250 15040313425 0012556 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Ripper.lex is not guaranteed to lex the entire source document
  #
  # This class guarantees the whole document is lex-ed by iteratively
  # lexing the document where ripper stopped.
  #
  # Prism likely doesn't have the same problem. Once ripper support is removed
  # we can likely reduce the complexity here if not remove the whole concept.
  #
  # Example usage:
  #
  #   lex = LexAll.new(source: source)
  #   lex.each do |value|
  #     puts value.line
  #   end
  class LexAll
    include Enumerable

    def initialize(source:, source_lines: nil)
      @lex = self.class.lex(source, 1)
      lineno = @lex.last[0][0] + 1
      source_lines ||= source.lines
      last_lineno = source_lines.length

      until lineno >= last_lineno
        lines = source_lines[lineno..]

        @lex.concat(
          self.class.lex(lines.join, lineno + 1)
        )

        lineno = @lex.last[0].first + 1
      end

      last_lex = nil
      @lex.map! { |elem|
        last_lex = LexValue.new(elem[0].first, elem[1], elem[2], elem[3], last_lex)
      }
    end

    if SyntaxSuggest.use_prism_parser?
      def self.lex(source, line_number)
        Prism.lex_compat(source, line: line_number).value.sort_by { |values| values[0] }
      end
    else
      def self.lex(source, line_number)
        Ripper::Lexer.new(source, "-", line_number).parse.sort_by(&:pos)
      end
    end

    def to_a
      @lex
    end

    def each
      return @lex.each unless block_given?
      @lex.each do |x|
        yield x
      end
    end

    def [](index)
      @lex[index]
    end

    def last
      @lex.last
    end
  end
end

require_relative "lex_value"
                                                                                                                                                                                                                                                                                                                                                        ruby/syntax_suggest/code_line.rb                                                                    0000644                 00000015176 15040313425 0013071 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Represents a single line of code of a given source file
  #
  # This object contains metadata about the line such as
  # amount of indentation, if it is empty or not, and
  # lexical data, such as if it has an `end` or a keyword
  # in it.
  #
  # Visibility of lines can be toggled off. Marking a line as invisible
  # indicates that it should not be used for syntax checks.
  # It's functionally the same as commenting it out.
  #
  # Example:
  #
  #   line = CodeLine.from_source("def foo\n").first
  #   line.number => 1
  #   line.empty? # => false
  #   line.visible? # => true
  #   line.mark_invisible
  #   line.visible? # => false
  #
  class CodeLine
    TRAILING_SLASH = ("\\" + $/).freeze

    # Returns an array of CodeLine objects
    # from the source string
    def self.from_source(source, lines: nil)
      lines ||= source.lines
      lex_array_for_line = LexAll.new(source: source, source_lines: lines).each_with_object(Hash.new { |h, k| h[k] = [] }) { |lex, hash| hash[lex.line] << lex }
      lines.map.with_index do |line, index|
        CodeLine.new(
          line: line,
          index: index,
          lex: lex_array_for_line[index + 1]
        )
      end
    end

    attr_reader :line, :index, :lex, :line_number, :indent
    def initialize(line:, index:, lex:)
      @lex = lex
      @line = line
      @index = index
      @original = line
      @line_number = @index + 1
      strip_line = line.dup
      strip_line.lstrip!

      @indent = if (@empty = strip_line.empty?)
        line.length - 1 # Newline removed from strip_line is not "whitespace"
      else
        line.length - strip_line.length
      end

      set_kw_end
    end

    # Used for stable sort via indentation level
    #
    # Ruby's sort is not "stable" meaning that when
    # multiple elements have the same value, they are
    # not guaranteed to return in the same order they
    # were put in.
    #
    # So when multiple code lines have the same indentation
    # level, they're sorted by their index value which is unique
    # and consistent.
    #
    # This is mostly needed for consistency of the test suite
    def indent_index
      @indent_index ||= [indent, index]
    end
    alias_method :number, :line_number

    # Returns true if the code line is determined
    # to contain a keyword that matches with an `end`
    #
    # For example: `def`, `do`, `begin`, `ensure`, etc.
    def is_kw?
      @is_kw
    end

    # Returns true if the code line is determined
    # to contain an `end` keyword
    def is_end?
      @is_end
    end

    # Used to hide lines
    #
    # The search alorithm will group lines into blocks
    # then if those blocks are determined to represent
    # valid code they will be hidden
    def mark_invisible
      @line = ""
    end

    # Means the line was marked as "invisible"
    # Confusingly, "empty" lines are visible...they
    # just don't contain any source code other than a newline ("\n").
    def visible?
      !line.empty?
    end

    # Opposite or `visible?` (note: different than `empty?`)
    def hidden?
      !visible?
    end

    # An `empty?` line is one that was originally left
    # empty in the source code, while a "hidden" line
    # is one that we've since marked as "invisible"
    def empty?
      @empty
    end

    # Opposite of `empty?` (note: different than `visible?`)
    def not_empty?
      !empty?
    end

    # Renders the given line
    #
    # Also allows us to represent source code as
    # an array of code lines.
    #
    # When we have an array of code line elements
    # calling `join` on the array will call `to_s`
    # on each element, which essentially converts
    # it back into it's original source string.
    def to_s
      line
    end

    # When the code line is marked invisible
    # we retain the original value of it's line
    # this is useful for debugging and for
    # showing extra context
    #
    # DisplayCodeWithLineNumbers will render
    # all lines given to it, not just visible
    # lines, it uses the original method to
    # obtain them.
    attr_reader :original

    # Comparison operator, needed for equality
    # and sorting
    def <=>(other)
      index <=> other.index
    end

    # [Not stable API]
    #
    # Lines that have a `on_ignored_nl` type token and NOT
    # a `BEG` type seem to be a good proxy for the ability
    # to join multiple lines into one.
    #
    # This predicate method is used to determine when those
    # two criteria have been met.
    #
    # The one known case this doesn't handle is:
    #
    #     Ripper.lex <<~EOM
    #       a &&
    #        b ||
    #        c
    #     EOM
    #
    # For some reason this introduces `on_ignore_newline` but wi