ne by looking mostly at the "state" (last value):
    #
    #   ENDFN -> BEG (token = '=' ) -> END
    #
    private def set_kw_end
      oneliner_count = 0
      in_oneliner_def = nil

      kw_count = 0
      end_count = 0

      @ignore_newline_not_beg = false
      @lex.each do |lex|
        kw_count += 1 if lex.is_kw?
        end_count += 1 if lex.is_end?

        if lex.type == :on_ignored_nl
          @ignore_newline_not_beg = !lex.expr_beg?
        end

        if in_oneliner_def.nil?
          in_oneliner_def = :ENDFN if lex.state.allbits?(Ripper::EXPR_ENDFN)
        elsif lex.state.allbits?(Ripper::EXPR_ENDFN)
          # Continue
        elsif lex.state.allbits?(Ripper::EXPR_BEG)
          in_oneliner_def = :BODY if lex.token == "="
        elsif lex.state.allbits?(Ripper::EXPR_END)
          # We found an endless method, count it
          oneliner_count += 1 if in_oneliner_def == :BODY

          in_oneliner_def = nil
        else
          in_oneliner_def = nil
        end
      end

      kw_count -= oneliner_count

      @is_kw = (kw_count - end_count) > 0
      @is_end = (end_count - kw_count) > 0
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                  ruby/syntax_suggest/pathname_from_message.rb                                                        0000644                 00000002660 15040313425 0015466 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Converts a SyntaxError message to a path
  #
  # Handles the case where the filename has a colon in it
  # such as on a windows file system: https://github.com/ruby/syntax_suggest/issues/111
  #
  # Example:
  #
  #    message = "/tmp/scratch:2:in `require_relative': /private/tmp/bad.rb:1: syntax error, unexpected `end' (SyntaxError)"
  #    puts PathnameFromMessage.new(message).call.name
  #    # => "/tmp/scratch.rb"
  #
  class PathnameFromMessage
    EVAL_RE = /^\(eval.*\):\d+/
    STREAMING_RE = /^-:\d+/
    attr_reader :name

    def initialize(message, io: $stderr)
      @line = message.lines.first
      @parts = @line.split(":")
      @guess = []
      @name = nil
      @io = io
    end

    def call
      if skip_missing_file_name?
        if ENV["SYNTAX_SUGGEST_DEBUG"]
          @io.puts "SyntaxSuggest: Could not find filename from #{@line.inspect}"
        end
      else
        until stop?
          @guess << @parts.shift
          @name = Pathname(@guess.join(":"))
        end

        if @parts.empty?
          @io.puts "SyntaxSuggest: Could not find filename from #{@line.inspect}"
          @name = nil
        end
      end

      self
    end

    def stop?
      return true if @parts.empty?
      return false if @guess.empty?

      @name&.exist?
    end

    def skip_missing_file_name?
      @line.match?(EVAL_RE) || @line.match?(STREAMING_RE)
    end
  end
end
                                                                                ruby/syntax_suggest/block_expand.rb                                                                 0000644                 00000011600 15040313425 0013565 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # This class is responsible for taking a code block that exists
  # at a far indentaion and then iteratively increasing the block
  # so that it captures everything within the same indentation block.
  #
  #   def dog
  #     puts "bow"
  #     puts "wow"
  #   end
  #
  # block = BlockExpand.new(code_lines: code_lines)
  #   .call(CodeBlock.new(lines: code_lines[1]))
  #
  # puts block.to_s
  # # => puts "bow"
  #      puts "wow"
  #
  #
  # Once a code block has captured everything at a given indentation level
  # then it will expand to capture surrounding indentation.
  #
  # block = BlockExpand.new(code_lines: code_lines)
  #   .call(block)
  #
  # block.to_s
  # # => def dog
  #        puts "bow"
  #        puts "wow"
  #      end
  #
  class BlockExpand
    def initialize(code_lines:)
      @code_lines = code_lines
    end

    # Main interface. Expand current indentation, before
    # expanding to a lower indentation
    def call(block)
      if (next_block = expand_neighbors(block))
        next_block
      else
        expand_indent(block)
      end
    end

    # Expands code to the next lowest indentation
    #
    # For example:
    #
    #   1 def dog
    #   2   print "dog"
    #   3 end
    #
    # If a block starts on line 2 then it has captured all it's "neighbors" (code at
    # the same indentation or higher). To continue expanding, this block must capture
    # lines one and three which are at a different indentation level.
    #
    # This method allows fully expanded blocks to decrease their indentation level (so
    # they can expand to capture more code up and down). It does this conservatively
    # as there's no undo (currently).
    def expand_indent(block)
      now = AroundBlockScan.new(code_lines: @code_lines, block: block)
        .force_add_hidden
        .stop_after_kw
        .scan_adjacent_indent

      now.lookahead_balance_one_line

      now.code_block
    end

    # A neighbor is code that is at or above the current indent line.
    #
    # First we build a block with all neighbors. If we can't go further
    # then we decrease the indentation threshold and expand via indentation
    # i.e. `expand_indent`
    #
    # Handles two general cases.
    #
    # ## Case #1: Check code inside of methods/classes/etc.
    #
    # It's important to note, that not everything in a given indentation level can be parsed
    # as valid code even if it's part of valid code. For example:
    #
    #   1 hash = {
    #   2   name: "richard",
    #   3   dog: "cinco",
    #   4 }
    #
    # In this case lines 2 and 3 will be neighbors, but they're invalid until `expand_indent`
    # is called on them.
    #
    # When we are adding code within a method or class (at the same indentation level),
    # use the empty lines to denote the programmer intended logical chunks.
    # Stop and check each one. For example:
    #
    #   1 def dog
    #   2   print "dog"
    #   3
    #   4   hash = {
    #   5 end
    #
    # If we did not stop parsing at empty newlines then the block might mistakenly grab all
    # the contents (lines 2, 3, and 4) and report them as being problems, instead of only
    # line 4.
    #
    # ## Case #2: Expand/grab other logical blocks
    #
    # Once the search algorithm has converted all lines into blocks at a given indentation
    # it will then `expand_indent`. Once the blocks that generates are expanded as neighbors
    # we then begin seeing neighbors being other logical blocks i.e. a block's neighbors
    # may be another method or class (something with keywords/ends).
    #
    # For example:
    #
    #   1 def bark
    #   2
    #   3 end
    #   4
    #   5 def sit
    #   6 end
    #
    # In this case if lines 4, 5, and 6 are in a block when it tries to expand neighbors
    # it will expand up. If it stops after line 2 or 3 it may cause problems since there's a
    # valid kw/end pair, but the block will be checked without it.
    #
    # We try to resolve this edge case with `lookahead_balance_one_line` below.
    def expand_neighbors(block)
      now = AroundBlockScan.new(code_lines: @code_lines, block: block)

      # Initial scan
      now
        .force_add_hidden
        .stop_after_kw
        .scan_neighbors_not_empty

      # Slurp up empties
      now
        .scan_while { |line| line.empty? }

      # If next line is kw and it will balance us, take it
      expanded_lines = now
        .lookahead_balance_one_line
        .lines

      # Don't allocate a block if it won't be used
      #
      # If nothing was taken, return nil to indicate that status
      # used in `def call` to determine if
      # we need to expand up/out (`expand_indent`)
      if block.lines == expanded_lines
        nil
      else
        CodeBlock.new(lines: expanded_lines)
      end
    end

    # Manageable rspec errors
    def inspect
      "#<SyntaxSuggest::CodeBlock:0x0000123843lol >"
    end
  end
end
                                                                                                                                ruby/syntax_suggest/display_invalid_blocks.rb                                                       0000644                 00000003405 15040313425 0015650 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "capture_code_context"
require_relative "display_code_with_line_numbers"

module SyntaxSuggest
  # Used for formatting invalid blocks
  class DisplayInvalidBlocks
    attr_reader :filename

    def initialize(code_lines:, blocks:, io: $stderr, filename: nil, terminal: DEFAULT_VALUE)
      @io = io
      @blocks = Array(blocks)
      @filename = filename
      @code_lines = code_lines

      @terminal = (terminal == DEFAULT_VALUE) ? io.isatty : terminal
    end

    def document_ok?
      @blocks.none? { |b| !b.hidden? }
    end

    def call
      if document_ok?
        return self
      end

      if filename
        @io.puts("--> #{filename}")
        @io.puts
      end
      @blocks.each do |block|
        display_block(block)
      end

      self
    end

    private def display_block(block)
      # Build explanation
      explain = ExplainSyntax.new(
        code_lines: block.lines
      ).call

      # Enhance code output
      # Also handles several ambiguious cases
      lines = CaptureCodeContext.new(
        blocks: block,
        code_lines: @code_lines
      ).call

      # Build code output
      document = DisplayCodeWithLineNumbers.new(
        lines: lines,
        terminal: @terminal,
        highlight_lines: block.lines
      ).call

      # Output syntax error explanation
      explain.errors.each do |e|
        @io.puts e
      end
      @io.puts

      # Output code
      @io.puts(document)
    end

    private def code_with_context
      lines = CaptureCodeContext.new(
        blocks: @blocks,
        code_lines: @code_lines
      ).call

      DisplayCodeWithLineNumbers.new(
        lines: lines,
        terminal: @terminal,
        highlight_lines: @invalid_lines
      ).call
    end
  end
end
                                                                                                                                                                                                                                                           ruby/syntax_suggest/core_ext.rb                                                                     0000644                 00000005225 15040313425 0012752 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

# Ruby 3.2+ has a cleaner way to hook into Ruby that doesn't use `require`
if SyntaxError.method_defined?(:detailed_message)
  module SyntaxSuggest
    # SyntaxSuggest.module_for_detailed_message [Private]
    #
    # Used to monkeypatch SyntaxError via Module.prepend
    def self.module_for_detailed_message
      Module.new {
        def detailed_message(highlight: true, syntax_suggest: true, **kwargs)
          return super unless syntax_suggest

          require "syntax_suggest/api" unless defined?(SyntaxSuggest::DEFAULT_VALUE)

          message = super

          if path
            file = Pathname.new(path)
            io = SyntaxSuggest::MiniStringIO.new

            SyntaxSuggest.call(
              io: io,
              source: file.read,
              filename: file,
              terminal: highlight
            )
            annotation = io.string

            annotation += "\n" unless annotation.end_with?("\n")

            annotation + message
          else
            message
          end
        rescue => e
          if ENV["SYNTAX_SUGGEST_DEBUG"]
            $stderr.warn(e.message)
            $stderr.warn(e.backtrace)
          end

          # Ignore internal errors
          message
        end
      }
    end
  end

  SyntaxError.prepend(SyntaxSuggest.module_for_detailed_message)
else
  autoload :Pathname, "pathname"

  #--
  # Monkey patch kernel to ensure that all `require` calls call the same
  # method
  #++
  module Kernel
    # :stopdoc:

    module_function

    alias_method :syntax_suggest_original_require, :require
    alias_method :syntax_suggest_original_require_relative, :require_relative
    alias_method :syntax_suggest_original_load, :load

    def load(file, wrap = false)
      syntax_suggest_original_load(file)
    rescue SyntaxError => e
      require "syntax_suggest/api" unless defined?(SyntaxSuggest::DEFAULT_VALUE)

      SyntaxSuggest.handle_error(e)
    end

    def require(file)
      syntax_suggest_original_require(file)
    rescue SyntaxError => e
      require "syntax_suggest/api" unless defined?(SyntaxSuggest::DEFAULT_VALUE)

      SyntaxSuggest.handle_error(e)
    end

    def require_relative(file)
      if Pathname.new(file).absolute?
        syntax_suggest_original_require file
      else
        relative_from = caller_locations(1..1).first
        relative_from_path = relative_from.absolute_path || relative_from.path
        syntax_suggest_original_require File.expand_path("../#{file}", relative_from_path)
      end
    rescue SyntaxError => e
      require "syntax_suggest/api" unless defined?(SyntaxSuggest::DEFAULT_VALUE)

      SyntaxSuggest.handle_error(e)
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                           ruby/syntax_suggest/around_block_scan.rb                                                            0000644                 00000015635 15040313426 0014617 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "scan_history"

module SyntaxSuggest
  # This class is useful for exploring contents before and after
  # a block
  #
  # It searches above and below the passed in block to match for
  # whatever criteria you give it:
  #
  # Example:
  #
  #   def dog         # 1
  #     puts "bark"   # 2
  #     puts "bark"   # 3
  #   end             # 4
  #
  #   scan = AroundBlockScan.new(
  #     code_lines: code_lines
  #     block: CodeBlock.new(lines: code_lines[1])
  #   )
  #
  #   scan.scan_while { true }
  #
  #   puts scan.before_index # => 0
  #   puts scan.after_index  # => 3
  #
  class AroundBlockScan
    def initialize(code_lines:, block:)
      @code_lines = code_lines
      @orig_indent = block.current_indent

      @stop_after_kw = false
      @force_add_empty = false
      @force_add_hidden = false
      @target_indent = nil

      @scanner = ScanHistory.new(code_lines: code_lines, block: block)
    end

    # When using this flag, `scan_while` will
    # bypass the block it's given and always add a
    # line that responds truthy to `CodeLine#hidden?`
    #
    # Lines are hidden when they've been evaluated by
    # the parser as part of a block and found to contain
    # valid code.
    def force_add_hidden
      @force_add_hidden = true
      self
    end

    # When using this flag, `scan_while` will
    # bypass the block it's given and always add a
    # line that responds truthy to `CodeLine#empty?`
    #
    # Empty lines contain no code, only whitespace such
    # as leading spaces a newline.
    def force_add_empty
      @force_add_empty = true
      self
    end

    # Tells `scan_while` to look for mismatched keyword/end-s
    #
    # When scanning up, if we see more keywords then end-s it will
    # stop. This might happen when scanning outside of a method body.
    # the first scan line up would be a keyword and this setting would
    # trigger a stop.
    #
    # When scanning down, stop if there are more end-s than keywords.
    def stop_after_kw
      @stop_after_kw = true
      self
    end

    # Main work method
    #
    # The scan_while method takes a block that yields lines above and
    # below the block. If the yield returns true, the @before_index
    # or @after_index are modified to include the matched line.
    #
    # In addition to yielding individual lines, the internals of this
    # object give a mini DSL to handle common situations such as
    # stopping if we've found a keyword/end mis-match in one direction
    # or the other.
    def scan_while
      stop_next_up = false
      stop_next_down = false

      @scanner.scan(
        up: ->(line, kw_count, end_count) {
          next false if stop_next_up
          next true if @force_add_hidden && line.hidden?
          next true if @force_add_empty && line.empty?

          if @stop_after_kw && kw_count > end_count
            stop_next_up = true
          end

          yield line
        },
        down: ->(line, kw_count, end_count) {
          next false if stop_next_down
          next true if @force_add_hidden && line.hidden?
          next true if @force_add_empty && line.empty?

          if @stop_after_kw && end_count > kw_count
            stop_next_down = true
          end

          yield line
        }
      )

      self
    end

    # Scanning is intentionally conservative because
    # we have no way of rolling back an aggressive block (at this time)
    #
    # If a block was stopped for some trivial reason, (like an empty line)
    # but the next line would have caused it to be balanced then we
    # can check that condition and grab just one more line either up or
    # down.
    #
    # For example, below if we're scanning up, line 2 might cause
    # the scanning to stop. This is because empty lines might
    # denote logical breaks where the user intended to chunk code
    # which is a good place to stop and check validity. Unfortunately
    # it also means we might have a "dangling" keyword or end.
    #
    #   1 def bark
    #   2
    #   3 end
    #
    # If lines 2 and 3 are in the block, then when this method is
    # run it would see it is unbalanced, but that acquiring line 1
    # would make it balanced, so that's what it does.
    def lookahead_balance_one_line
      kw_count = 0
      end_count = 0
      lines.each do |line|
        kw_count += 1 if line.is_kw?
        end_count += 1 if line.is_end?
      end

      return self if kw_count == end_count # nothing to balance

      @scanner.commit_if_changed # Rollback point if we don't find anything to optimize

      # Try to eat up empty lines
      @scanner.scan(
        up: ->(line, _, _) { line.hidden? || line.empty? },
        down: ->(line, _, _) { line.hidden? || line.empty? }
      )

      # More ends than keywords, check if we can balance expanding up
      next_up = @scanner.next_up
      next_down = @scanner.next_down
      case end_count - kw_count
      when 1
        if next_up&.is_kw? && next_up.indent >= @target_indent
          @scanner.scan(
            up: ->(line, _, _) { line == next_up },
            down: ->(line, _, _) { false }
          )
          @scanner.commit_if_changed
        end
      when -1
        if next_down&.is_end? && next_down.indent >= @target_indent
          @scanner.scan(
            up: ->(line, _, _) { false },
            down: ->(line, _, _) { line == next_down }
          )
          @scanner.commit_if_changed
        end
      end
      # Rollback any uncommitted changes
      @scanner.stash_changes

      self
    end

    # Finds code lines at the same or greater indentation and adds them
    # to the block
    def scan_neighbors_not_empty
      @target_indent = @orig_indent
      scan_while { |line| line.not_empty? && line.indent >= @target_indent }
    end

    # Scan blocks based on indentation of next line above/below block
    #
    # Determines indentaion of the next line above/below the current block.
    #
    # Normally this is called when a block has expanded to capture all "neighbors"
    # at the same (or greater) indentation and needs to expand out. For example
    # the `def/end` lines surrounding a method.
    def scan_adjacent_indent
      before_after_indent = []

      before_after_indent << (@scanner.next_up&.indent || 0)
      before_after_indent << (@scanner.next_down&.indent || 0)

      @target_indent = before_after_indent.min
      scan_while { |line| line.not_empty? && line.indent >= @target_indent }

      self
    end

    # Return the currently matched lines as a `CodeBlock`
    #
    # When a `CodeBlock` is created it will gather metadata about
    # itself, so this is not a free conversion. Avoid allocating
    # more CodeBlock's than needed
    def code_block
      CodeBlock.new(lines: lines)
    end

    # Returns the lines matched by the current scan as an
    # array of CodeLines
    def lines
      @scanner.lines
    end

    # Manageable rspec errors
    def inspect
      "#<#{self.class}:0x0000123843lol >"
    end
  end
end
                                                                                                   ruby/syntax_suggest/priority_queue.rb                                                               0000644                 00000003776 15040313426 0014241 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Holds elements in a priority heap on insert
  #
  # Instead of constantly calling `sort!`, put
  # the element where it belongs the first time
  # around
  #
  # Example:
  #
  #   queue = PriorityQueue.new
  #   queue << 33
  #   queue << 44
  #   queue << 1
  #
  #   puts queue.peek # => 44
  #
  class PriorityQueue
    attr_reader :elements

    def initialize
      @elements = []
    end

    def <<(element)
      @elements << element
      bubble_up(last_index, element)
    end

    def pop
      exchange(0, last_index)
      max = @elements.pop
      bubble_down(0)
      max
    end

    def length
      @elements.length
    end

    def empty?
      @elements.empty?
    end

    def peek
      @elements.first
    end

    def to_a
      @elements
    end

    # Used for testing, extremely not performant
    def sorted
      out = []
      elements = @elements.dup
      while (element = pop)
        out << element
      end
      @elements = elements
      out.reverse
    end

    private def last_index
      @elements.size - 1
    end

    private def bubble_up(index, element)
      return if index <= 0

      parent_index = (index - 1) / 2
      parent = @elements[parent_index]

      return if (parent <=> element) >= 0

      exchange(index, parent_index)
      bubble_up(parent_index, element)
    end

    private def bubble_down(index)
      child_index = (index * 2) + 1

      return if child_index > last_index

      not_the_last_element = child_index < last_index
      left_element = @elements[child_index]
      right_element = @elements[child_index + 1]

      child_index += 1 if not_the_last_element && (right_element <=> left_element) == 1

      return if (@elements[index] <=> @elements[child_index]) >= 0

      exchange(index, child_index)
      bubble_down(child_index)
    end

    def exchange(source, target)
      a = @elements[source]
      b = @elements[target]
      @elements[source] = b
      @elements[target] = a
    end
  end
end
  ruby/syntax_suggest/code_frontier.rb                                                                0000644                 00000013164 15040313426 0013766 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # The main function of the frontier is to hold the edges of our search and to
  # evaluate when we can stop searching.

  # There are three main phases in the algorithm:
  #
  # 1. Sanitize/format input source
  # 2. Search for invalid blocks
  # 3. Format invalid blocks into something meaningful
  #
  # The Code frontier is a critical part of the second step
  #
  # ## Knowing where we've been
  #
  # Once a code block is generated it is added onto the frontier. Then it will be
  # sorted by indentation and frontier can be filtered. Large blocks that fully enclose a
  # smaller block will cause the smaller block to be evicted.
  #
  #   CodeFrontier#<<(block) # Adds block to frontier
  #   CodeFrontier#pop # Removes block from frontier
  #
  # ## Knowing where we can go
  #
  # Internally the frontier keeps track of "unvisited" lines which are exposed via `next_indent_line`
  # when called, this method returns, a line of code with the highest indentation.
  #
  # The returned line of code can be used to build a CodeBlock and then that code block
  # is added back to the frontier. Then, the lines are removed from the
  # "unvisited" so we don't double-create the same block.
  #
  #   CodeFrontier#next_indent_line # Shows next line
  #   CodeFrontier#register_indent_block(block) # Removes lines from unvisited
  #
  # ## Knowing when to stop
  #
  # The frontier knows how to check the entire document for a syntax error. When blocks
  # are added onto the frontier, they're removed from the document. When all code containing
  # syntax errors has been added to the frontier, the document will be parsable without a
  # syntax error and the search can stop.
  #
  #   CodeFrontier#holds_all_syntax_errors? # Returns true when frontier holds all syntax errors
  #
  # ## Filtering false positives
  #
  # Once the search is completed, the frontier may have multiple blocks that do not contain
  # the syntax error. To limit the result to the smallest subset of "invalid blocks" call:
  #
  #   CodeFrontier#detect_invalid_blocks
  #
  class CodeFrontier
    def initialize(code_lines:, unvisited: UnvisitedLines.new(code_lines: code_lines))
      @code_lines = code_lines
      @unvisited = unvisited
      @queue = PriorityEngulfQueue.new

      @check_next = true
    end

    def count
      @queue.length
    end

    # Performance optimization
    #
    # Parsing with ripper is expensive
    # If we know we don't have any blocks with invalid
    # syntax, then we know we cannot have found
    # the incorrect syntax yet.
    #
    # When an invalid block is added onto the frontier
    # check document state
    private def can_skip_check?
      check_next = @check_next
      @check_next = false

      if check_next
        false
      else
        true
      end
    end

    # Returns true if the document is valid with all lines
    # removed. By default it checks all blocks in present in
    # the frontier array, but can be used for arbitrary arrays
    # of codeblocks as well
    def holds_all_syntax_errors?(block_array = @queue, can_cache: true)
      return false if can_cache && can_skip_check?

      without_lines = block_array.to_a.flat_map do |block|
        block.lines
      end

      SyntaxSuggest.valid_without?(
        without_lines: without_lines,
        code_lines: @code_lines
      )
    end

    # Returns a code block with the largest indentation possible
    def pop
      @queue.pop
    end

    def next_indent_line
      @unvisited.peek
    end

    def expand?
      return false if @queue.empty?
      return true if @unvisited.empty?

      frontier_indent = @queue.peek.current_indent
      unvisited_indent = next_indent_line.indent

      if ENV["SYNTAX_SUGGEST_DEBUG"]
        puts "```"
        puts @queue.peek
        puts "```"
        puts "  @frontier indent:  #{frontier_indent}"
        puts "  @unvisited indent: #{unvisited_indent}"
      end

      # Expand all blocks before moving to unvisited lines
      frontier_indent >= unvisited_indent
    end

    # Keeps track of what lines have been added to blocks and which are not yet
    # visited.
    def register_indent_block(block)
      @unvisited.visit_block(block)
      self
    end

    # When one element fully encapsulates another we remove the smaller
    # block from the frontier. This prevents double expansions and all-around
    # weird behavior. However this guarantee is quite expensive to maintain
    def register_engulf_block(block)
    end

    # Add a block to the frontier
    #
    # This method ensures the frontier always remains sorted (in indentation order)
    # and that each code block's lines are removed from the indentation hash so we
    # don't re-evaluate the same line multiple times.
    def <<(block)
      @unvisited.visit_block(block)

      @queue.push(block)

      @check_next = true if block.invalid?

      self
    end

    # Example:
    #
    #   combination([:a, :b, :c, :d])
    #   # => [[:a], [:b], [:c], [:d], [:a, :b], [:a, :c], [:a, :d], [:b, :c], [:b, :d], [:c, :d], [:a, :b, :c], [:a, :b, :d], [:a, :c, :d], [:b, :c, :d], [:a, :b, :c, :d]]
    def self.combination(array)
      guesses = []
      1.upto(array.length).each do |size|
        guesses.concat(array.combination(size).to_a)
      end
      guesses
    end

    # Given that we know our syntax error exists somewhere in our frontier, we want to find
    # the smallest possible set of blocks that contain all the syntax errors
    def detect_invalid_blocks
      self.class.combination(@queue.to_a.select(&:invalid?)).detect do |block_array|
        holds_all_syntax_errors?(block_array, can_cache: false)
      end || []
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                            ruby/syntax_suggest/left_right_lex_count.rb                                                         0000644                 00000010074 15040313426 0015350 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Find mis-matched syntax based on lexical count
  #
  # Used for detecting missing pairs of elements
  # each keyword needs an end, each '{' needs a '}'
  # etc.
  #
  # Example:
  #
  #   left_right = LeftRightLexCount.new
  #   left_right.count_kw
  #   left_right.missing.first
  #   # => "end"
  #
  #   left_right = LeftRightLexCount.new
  #   source = "{ a: b, c: d" # Note missing '}'
  #   LexAll.new(source: source).each do |lex|
  #     left_right.count_lex(lex)
  #   end
  #   left_right.missing.first
  #   # => "}"
  class LeftRightLexCount
    def initialize
      @kw_count = 0
      @end_count = 0

      @count_for_char = {
        "{" => 0,
        "}" => 0,
        "[" => 0,
        "]" => 0,
        "(" => 0,
        ")" => 0,
        "|" => 0
      }
    end

    def count_kw
      @kw_count += 1
    end

    def count_end
      @end_count += 1
    end

    # Count source code characters
    #
    # Example:
    #
    #   left_right = LeftRightLexCount.new
    #   left_right.count_lex(LexValue.new(1, :on_lbrace, "{", Ripper::EXPR_BEG))
    #   left_right.count_for_char("{")
    #   # => 1
    #   left_right.count_for_char("}")
    #   # => 0
    def count_lex(lex)
      case lex.type
      when :on_tstring_content
        # ^^^
        # Means it's a string or a symbol `"{"` rather than being
        # part of a data structure (like a hash) `{ a: b }`
        # ignore it.
      when :on_words_beg, :on_symbos_beg, :on_qwords_beg,
           :on_qsymbols_beg, :on_regexp_beg, :on_tstring_beg
        # ^^^
        # Handle shorthand syntaxes like `%Q{ i am a string }`
        #
        # The start token will be the full thing `%Q{` but we
        # need to count it as if it's a `{`. Any token
        # can be used
        char = lex.token[-1]
        @count_for_char[char] += 1 if @count_for_char.key?(char)
      when :on_embexpr_beg
        # ^^^
        # Embedded string expressions like `"#{foo} <-embed"`
        # are parsed with chars:
        #
        # `#{` as :on_embexpr_beg
        #  `}` as :on_embexpr_end
        #
        # We cannot ignore both :on_emb_expr_beg and :on_embexpr_end
        # because sometimes the lexer thinks something is an embed
        # string end, when it is not like `lol = }` (no clue why).
        #
        # When we see `#{` count it as a `{` or we will
        # have a mis-match count.
        #
        case lex.token
        when "\#{"
          @count_for_char["{"] += 1
        end
      else
        @end_count += 1 if lex.is_end?
        @kw_count += 1 if lex.is_kw?
        @count_for_char[lex.token] += 1 if @count_for_char.key?(lex.token)
      end
    end

    def count_for_char(char)
      @count_for_char[char]
    end

    # Returns an array of missing syntax characters
    # or `"end"` or `"keyword"`
    #
    #   left_right.missing
    #   # => ["}"]
    def missing
      out = missing_pairs
      out << missing_pipe
      out << missing_keyword_end
      out.compact!
      out
    end

    PAIRS = {
      "{" => "}",
      "[" => "]",
      "(" => ")"
    }.freeze

    # Opening characters like `{` need closing characters # like `}`.
    #
    # When a mis-match count is detected, suggest the
    # missing member.
    #
    # For example if there are 3 `}` and only two `{`
    # return `"{"`
    private def missing_pairs
      PAIRS.map do |(left, right)|
        case @count_for_char[left] <=> @count_for_char[right]
        when 1
          right
        when 0
          nil
        when -1
          left
        end
      end
    end

    # Keywords need ends and ends need keywords
    #
    # If we have more keywords, there's a missing `end`
    # if we have more `end`-s, there's a missing keyword
    private def missing_keyword_end
      case @kw_count <=> @end_count
      when 1
        "end"
      when 0
        nil
      when -1
        "keyword"
      end
    end

    # Pipes come in pairs.
    # If there's an odd number of pipes then we
    # are missing one
    private def missing_pipe
      if @count_for_char["|"].odd?
        "|"
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ruby/syntax_suggest/api.rb                                                                          0000644                 00000014155 15040313426 0011716 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "version"

require "tmpdir"
require "stringio"
require "pathname"
require "timeout"

# We need Ripper loaded for `Prism.lex_compat` even if we're using Prism
# for lexing and parsing
require "ripper"

# Prism is the new pars