evaluating
  #
  #   SyntaxSuggest.valid?(
  #     [
  #       "def foo\n",
  #       "end\n"
  #     ]
  #   ) # => true
  #
  #   SyntaxSuggest.valid?(
  #     [
  #       "def foo\n",
  #       "  def bar\n", # Syntax error here
  #       "end\n"
  #     ]
  #   ) # => false
  #
  # As an FYI the CodeLine class instances respond to `to_s`
  # so passing a CodeLine in as an object or as an array
  # will convert it to it's code representation.
  def self.valid?(source)
    !invalid?(source)
  end
end

# Integration
require_relative "cli"

# Core logic
require_relative "code_search"
require_relative "code_frontier"
require_relative "explain_syntax"
require_relative "clean_document"

# Helpers
require_relative "lex_all"
require_relative "code_line"
require_relative "code_block"
require_relative "block_expand"
require_relative "mini_stringio"
require_relative "priority_queue"
require_relative "unvisited_lines"
require_relative "around_block_scan"
require_relative "priority_engulf_queue"
require_relative "pathname_from_message"
require_relative "display_invalid_blocks"
require_relative "parse_blocks_from_indent_line"
                                                                                                                                                                                                                                                                                                                                                                                                                   ruby/syntax_suggest/lex_value.rb                                                                    0000644                 00000002775 15040313426 0013136 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Value object for accessing lex values
  #
  # This lex:
  #
  #   [1, 0], :on_ident, "describe", CMDARG
  #
  # Would translate into:
  #
  #  lex.line # => 1
  #  lex.type # => :on_indent
  #  lex.token # => "describe"
  class LexValue
    attr_reader :line, :type, :token, :state

    def initialize(line, type, token, state, last_lex = nil)
      @line = line
      @type = type
      @token = token
      @state = state

      set_kw_end(last_lex)
    end

    private def set_kw_end(last_lex)
      @is_end = false
      @is_kw = false
      return if type != :on_kw

      return if last_lex && last_lex.fname? # https://github.com/ruby/ruby/commit/776759e300e4659bb7468e2b97c8c2d4359a2953

      case token
      when "if", "unless", "while", "until"
        # Only count if/unless when it's not a "trailing" if/unless
        # https://github.com/ruby/ruby/blob/06b44f819eb7b5ede1ff69cecb25682b56a1d60c/lib/irb/ruby-lex.rb#L374-L375
        @is_kw = true unless expr_label?
      when "def", "case", "for", "begin", "class", "module", "do"
        @is_kw = true
      when "end"
        @is_end = true
      end
    end

    def fname?
      state.allbits?(Ripper::EXPR_FNAME)
    end

    def ignore_newline?
      type == :on_ignored_nl
    end

    def is_end?
      @is_end
    end

    def is_kw?
      @is_kw
    end

    def expr_beg?
      state.anybits?(Ripper::EXPR_BEG)
    end

    def expr_label?
      state.allbits?(Ripper::EXPR_LABEL)
    end
  end
end
   ruby/syntax_suggest/unvisited_lines.rb                                                              0000644                 00000001301 15040313426 0014336 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Tracks which lines various code blocks have expanded to
  # and which are still unexplored
  class UnvisitedLines
    def initialize(code_lines:)
      @unvisited = code_lines.sort_by(&:indent_index)
      @visited_lines = {}
      @visited_lines.compare_by_identity
    end

    def empty?
      @unvisited.empty?
    end

    def peek
      @unvisited.last
    end

    def pop
      @unvisited.pop
    end

    def visit_block(block)
      block.lines.each do |line|
        next if @visited_lines[line]
        @visited_lines[line] = true
      end

      while @visited_lines[@unvisited.last]
        @unvisited.pop
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                               ruby/syntax_suggest/code_search.rb                                                                  0000644                 00000007501 15040313426 0013401 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Searches code for a syntax error
  #
  # There are three main phases in the algorithm:
  #
  # 1. Sanitize/format input source
  # 2. Search for invalid blocks
  # 3. Format invalid blocks into something meaninful
  #
  # This class handles the part.
  #
  # The bulk of the heavy lifting is done in:
  #
  #  - CodeFron