move_entry_secure.
  # - <tt>verbose: true</tt> - prints an equivalent command:
  #
  #     FileUtils.rm_r(['src0.dat', 'src0.txt'], noop: true, verbose: true)
  #     FileUtils.rm_r('src1', noop: true, verbose: true)
  #
  #   Output:
  #
  #     rm -r src0.dat src0.txt
  #     rm -r src1
  #
  # Related: {methods for deleting}[rdoc-ref:FileUtils@Deleting].
  #
  def rm_r(list, force: nil, noop: nil, verbose: nil, secure: nil)
    list = fu_list(list)
    fu_output_message "rm -r#{force ? 'f' : ''} #{list.join ' '}" if verbose
    return if noop
    list.each do |path|
      if secure
        remove_entry_secure path, force
      else
        remove_entry path, force
      end
    end
  end
  module_function :rm_r

  # Equivalent to:
  #
  #   FileUtils.rm_r(list, force: true, **kwargs)
  #
  # Argument +list+ or its elements
  # should be {interpretable as paths}[rdoc-ref:FileUtils@Path+Arguments].
  #
  # May cause a local vulnerability if not called with keyword argument
  # <tt>secure: true</tt>;
  # see {Avoiding the TOCTTOU Vulnerability}[rdoc-ref:FileUtils@Avoiding+the+TOCTTOU+Vulnerability].
  #
  # See FileUtils.rm_r for keyword arguments.
  #
  # FileUtils.rmtree is an alias for FileUtils.rm_rf.
  #
  # Related: {methods for deleting}[rdoc-ref:FileUtils@Deleting].
