py_file(src, dest, preserve = false, dereference = true)
    ent = Entry_.new(src, nil, dereference)
    ent.copy_file dest
    ent.copy_metadata dest if preserve
  end
  module_function :copy_file

  # Copies \IO stream +src+ to \IO stream +dest+ via
  # {IO.copy_stream}[rdoc-ref:IO.copy_stream].
  #
  # Related: {methods for copying}[rdoc-ref:FileUtils@Copying].
  #
  def copy_stream(src, dest)
    IO.copy_stream(src, dest)
  end
  module_function :copy_stream

  # Moves entries.
  #
  # Arguments +src+ (a single path or an array of paths)
  # and +dest+ (a single path)
  # should be {interpretable as paths}[rdoc-ref:FileUtils@Path+Arguments].
  #
  # If +src+ and +dest+ are on different file systems,
  # first copies, then removes +src+.
  #
  # May cause a local vulnerability if not called with keyword argument
  # <tt>secure: true</tt>;
  # see {Avoiding the TOCTTOU Vulnerability}[rdoc-ref:FileUtils@Avoiding+the+TOCTTOU+Vulnerability].
  #
  # If +src+ is the path to a single file or directory and +dest+ does not exist,
  # moves +src+ to +dest+:
  #
  #   tree('src0')
  #   # => src0
  #   #    |-- src0.txt
  #   #    `-- src1.txt
  #   File.exist?('dest0') # => false
  #   FileUtils.mv('src0', 'dest0')
  #   File.exist?('src0')  # => false
  #   tree('dest0')
  #   # => dest0
