uld be {interpretable as paths}[rdoc-ref:FileUtils@Path+Arguments].
  #
  # If +src+ is the path to a file, copies +src+ to +dest+:
  #
  #   FileUtils.touch('src0.txt')
  #   File.exist?('dest0.txt') # => false
  #   FileUtils.copy_entry('src0.txt', 'dest0.txt')
  #   File.file?('dest0.txt')  # => true
  #
  # If +src+ is a directory, recursively copies +src+ to +dest+:
  #
  #   tree('src1')
  #   # => src1
  #   #    |-- dir0
  #   #    |   |-- src0.txt
  #   #    |   `-- src1.txt
  #   #    `-- dir1
  #   #        |-- src2.txt
  #   #        `-- src3.txt
  #   FileUtils.copy_entry('src1', 'dest1')
  #   tree('dest1')
  #   # => dest1
  #   #    |-- dir0
  #   #    |   |-- src0.txt
  #   #    |   `-- src1.txt
  #   #    `-- dir1
  #   #        |-- src2.txt
  #   #        `-- src3.txt
  #
  # The recursive copying preserves file types for regular files,
  # directories, and symbolic links;
  # other file types (FIFO streams, device files, etc.) are not supported.
  #
  # Keyword arguments:
  #
  # - <tt>dereference_root: true</tt> - if +src+ is a symbolic link,
  #   follows the link.
  # - <tt>preserve: true</tt> - preserves file times.
  # - <tt>remove_destination: true</tt> - removes +dest+ before copying files.
  #
  # Related: {methods for copying}[rdoc-ref:FileUtils@Copying].
  #
  def copy_entry(src, dest, preserve = false, dereference_root = false, remove_destination = false)
    if dereference_root
      src = File.realpath(src)
    end

    Entry_.new(src, nil, false).wrap_traverse(proc do |ent|
      destent = Entry_.new(dest, ent.rel, false)
      File.unlink destent.path if remove_destination && (File.file?(destent.path) || File.symlink?(destent.path))
      ent.copy destent.path
    end, proc do |ent|
      destent = Entry_.new(dest, ent.rel, false)
      ent.copy_metadata destent.path 