c1.txt
  #   #    `-- dir1
  #   #    |-- src2.txt
  #   #    `-- src3.txt
  #   FileUtils.mkdir('dest3')
  #   FileUtils.cp_r('src3', 'dest3')
  #   tree('dest3')
  #   # => dest3
  #   #    `-- src3
  #   #      |-- dir0
  #   #      |   |-- src0.txt
  #   #      |   `-- src1.txt
  #   #      `-- dir1
  #   #          |-- src2.txt
  #   #          `-- src3.txt
  #
  # If +src+ is an array of paths and +dest+ is a directory,
  # recursively copies from each path in +src+ to +dest+;
  # the paths in +src+ may point to files and/or directories.
  #
  # Keyword arguments:
  #
  # - <tt>dereference_root: false</tt> - if +src+ is a symbolic link,
  #   does not dereference it.
  # - <tt>noop: true</tt> - does not copy files.
  # - <tt>preserve: true</tt> - preserves file times.
  # - <tt>remove_destination: true</tt> - removes +dest+ before copying files.
  # - <tt>verbose: true</tt> - prints an equivalent command:
  #
  #     FileUtils.cp_r('src0.txt', 'dest0.txt', noop: true, verbose: true)
  #     FileUtils.cp_r('src1.txt', 'dest1', noop: true, verbose: true)
  #     FileUtils.cp_r('src2', 'dest2', noop: true, verbose: true)
  #     FileUtils.cp_r('src3', 'dest3', noop: true, verbose: true)
  #
  #   Output:
  #
  #     cp -r src0.txt dest0.txt
  #     cp -r src1.txt dest1
  #     cp -r src2 dest2
  #     cp -r src3 dest3
  #
  # Raises an exception of +