alias for FileUtils.cp.
  #
  # Related: {methods for copying}[rdoc-ref:FileUtils@Copying].
  #
  def cp(src, dest, preserve: nil, noop: nil, verbose: nil)
    fu_output_message "cp#{preserve ? ' -p' : ''} #{[src,dest].flatten.join ' '}" if verbose
    return if noop
    fu_each_src_dest(src, dest) do |s, d|
      copy_file s, d, preserve
    end
  end
  module_function :cp

  alias copy cp
  module_function :copy

  # Recursively copies files.
  #
  # Arguments +src+ (a single path or an array of paths)
  # and +dest+ (a single path)
  # should be {interpretable as paths}[rdoc-ref:FileUtils@Path+Arguments].
  #
  # The mode, owner, and group are retained in the copy;
  # to change those, use FileUtils.install instead.
  #
  # If +src+ is the path to a file and +dest+ is not the path to a directory,
  # copies +src+ to +dest+:
  #
  #   FileUtils.touch('src0.txt')
  #   File.exist?('dest0.txt') # => false
  #   FileUtils.cp_r('src0.txt', 'dest0.txt')
  #   File.file?('dest0.txt')  # => true
  #
  # If +src+ is the path to a file and +dest+ is the path to a directory,
  # copies +src+ to <tt>dest/src</tt>:
  #
  #   FileUtils.touch('src1.txt')
  #   FileUtils.mkdir('dest1')
  #   FileUtils.cp_r('src1.txt', 'dest1')
  #   File.file?('dest1/src1.txt') # => true
  #
  # If +src+ i