e: nil, noop: nil, verbose: nil)
    fu_output_message "ln#{force ? ' -f' : ''} #{[src,dest].flatten.join ' '}" if verbose
    return if noop
    fu_each_src_dest0(src, dest) do |s,d|
      remove_file d, true if force
      File.link s, d
    end
  end
  module_function :ln

  alias link ln
  module_function :link

  # Creates {hard links}[https://en.wikipedia.org/wiki/Hard_link].
  #
  # Arguments +src+ (a single path or an array of paths)
  # and +dest+ (a single path)
  # should be {interpretable as paths}[rdoc-ref:FileUtils@Path+Arguments].
  #
  # If +src+ is the path to a directory and +dest+ does not exist,
  # creates links +dest+ and descendents pointing to +src+ and its descendents:
  #
  #   tree('src0')
  #   # => src0
  #   #    |-- sub0
  #   #    |   |-- src0.txt
  #   #    |   `-- src1.txt
  #   #    `-- sub1
  #   #        |-- src2.txt
  #   #        `-- src3.txt
  #   File.exist?('dest0') # => false
  #   FileUtils.cp_lr('src0', 'dest0')
  #   tree('dest0')
  #   # => dest0
  #   #    |-- sub0
  #   #    |   |-- src0.txt
  #   #    |   `-- src1.txt
  #   #    `-- sub1
  #   #        |-- src2.txt
  #   #        `-- src3.txt
  #
  # If +src+ and +dest+ are both paths to directories,
  # creates links <tt>dest/src</tt> and descendents
  # pointing to +src+ and its descendents:
  #
  #   tree('src1')
  #   # => src1
  #   #    |-- sub0
  #   #    |   |-- src0.txt
  #   #    |   `-- src1.txt
  #   #    `-- sub1
  #   #        |-- src2.txt
  #   #        `-- src3.txt
  #   FileUtils.mkdir('dest1')
  #   FileUtils.cp_lr('src1', 'dest1')
  #   tree('dest1')
  #   # => dest1
  #   #    `-- src1
  #   #        |-- sub0
  #   #        |   |-- src0.txt
  #   #        |   `-- src1.txt
  #   #        `-- sub1
  #   #            |-- src2.txt
  #   #            `-- src3.txt
  #
  # If +src+ is an array of paths to entries and +dest+ is the path to a directory,
  # for each path +filepath+ in +src+, creates a link at <tt>dest/filepath</tt>
  # pointing to that path:
  #
  #   tree('src2')
  #   # => src2
  #   #    |-- sub0
  #   #    |   |-- src0.txt
  #   #    |   `-- src1.txt
  #   #