                                                        ustar 00                                                                                                                                                                                                                                                       ruby/syntax_suggest/lex_all.rb                                                                      0000644                 00000002171 15040313425 0012557 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       CodeWithLineNumbers
    TERMINAL_HIGHLIGHT = "\e[1;3m" # Bold, italics
    TERMINAL_END = "\e[0m"

    def initialize(lines:, highlight_lines: [], terminal: false)
      @lines = Array(lines).sort
      @terminal = terminal
      @highlight_line_hash = Array(highlight_lines).each_with_object({}) { |line, h| h[line] = true }
      @digit_count = @lines.last&.line_number.to_s.length
    end

    def call
      @lines.map do |line|
        format_line(line)
      end.join
    end

    private def format_line(code_line)
      # Handle trailing slash lines
      code_line.original.lines.map.with_index do |contents, i|
        format(
          empty: code_line.empty?,
          number: (code_line.number + i).to_s,
          contents: contents,
          highlight: @highlight_line_hash[code_line]
        )
      end.join
    end

    private def format(contents:, number:, empty:, highlight: false)
      string = +""
      string << if highlight
        "> "
      else
        "  "
      end

      string << number.rjust(@digit_count).to_s
      if empty
        string << contents
      else
        string << "  "
        string << TE                                                                                                                                                                                                                                                                                                                                                                                                       ruby/syntax_suggest/code_line.rb                                                                    0000644                 00000014727 15040313425 0013072 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Ripper.lex is not guaranteed to lex the entire source document
  #
  # lex = LexAll.new(source: source)
  # lex.each do |value|
  #   puts value.line
  # end
  class LexAll
    include Enumerable

    def initialize(source:, source_lines: nil)
      @lex = Ripper::Lexer.new(source, "-", 1).parse.sort_by(&:pos)
      lineno = @lex.last.pos.first + 1
      source_lines ||= source.lines
      last_lineno = source_lines.length

      until lineno >= last_lineno
        lines = source_lines[lineno..-1]

        @lex.concat(
          Ripper::Lexer.new(lines.join, "-", lineno + 1).parse.sort_by(&:pos)
        )
        lineno = @lex.last.pos.first + 1
      end

      last_lex = nil
      @lex.map! { |elem|
        last_lex = LexValue.new(elem.pos.first, elem.event, elem.tok, elem.state, last_lex)
      }
    end

    def to_a
      @lex
    end

    def each
      return @lex.each unless block_given?
      @lex.each do |x|
  