turns pipes for $stdin, $stdout, and/or $stderr:
#
#   - Open3.popen2: Executes the command;
#     returns pipes for $stdin and $stdout.
#   - Open3.popen2e: Executes the command;
#     returns pipes for $stdin and merged $stdout and $stderr.
#   - Open3.popen3: Executes the command;
#     returns pipes for $stdin, $stdout, and $stderr.
#
# - Each of these methods executes one or more commands in processes and/or subshells,
#   returns pipes for the first $stdin, the last $stdout, or both:
#
#   - Open3.pipeline_r: Returns a pipe for the last $stdout.
#   - Open3.pipeline_rw: Returns pipes for the first $stdin and the last $stdout.
#   - Open3.pipeline_w: Returns a pipe for the first $stdin.
#   - Open3.pipeline_start: Does not wait for processes to complete.
#   - Open3.pipeline: Waits for processes to complete.
#
# Each of the methods above accepts:
#
# - An optional hash of environment variable names and values;
#   see {Execution Environment}[rdoc-ref:Process@Execution+Environment].
# - A required string argument that is a +command_line+ or +exe_path+;
#   see {Argument command_line or exe_path}[rdoc-ref:Process@Argument+command_line+or+exe_path].
# - An optional hash of execution options;
#   see {Execution Options}[rdoc-ref:Process@Execution+Options].
#
module Open3

  # :call-seq:
  #   Open3.popen3([env, ] command_line, options = {}) -> [stdin, stdout, stderr, wait_thread]
  #   Open3.popen3([env, ] exe_path, *args, options = {}) -> [stdin, stdout, stderr, wait_thread]
  #   Open3.popen3([env, ] command_line, options = {}) {|stdin, stdout, stderr, wait_thread| ... } -> object
  #   Open3.popen3([env, ] exe_path, *args, options = {}) {|stdin, stdout, stderr, wait_thread| ... } -> object
  #
  # Basically a wrapper for
  # {Process.spawn}[rdoc-ref:Process.spawn]
  # that:
  #
  # - Creates a child process, by calling Process.spawn with the given arguments.
  # - Creates streams +stdin+, +stdout+, and +stderr+,
  #   which are the standard input, standard output, and standard error streams
  #   in the child process.
  # - Creates thread +wait_thread+ that waits for the child process to exit;
  #   the thread has method +pid+, which returns the process ID
  #   of the child process.
  #
  # With no block given, returns the array
  # <tt>[stdin, stdout, stderr, wait_thread]</tt>.
  # The caller should close each of the three returned streams.
  #
  #   stdin, stdout, stderr, wait_thread = Open3.popen3('echo')
  #   # => [#<IO:fd 8>, #<IO:fd 10>, #<IO:fd 12>, #<Process::Waiter:0x00007f58d5428f58 run>]
  #   stdin.close
  #   stdout.close
  #   stderr.close
  #   wait_thread.pid   # => 2210481
  #   wait_thread.value # => #<Process::Status: pid 2210481 exit 0>
  #
  # With a block given, calls the block with the four variables
  # (three streams and the wait thread)
  # and returns the block's return value.
  # The caller need not close the streams:
  #
  #   Open3.popen3('echo') do |stdin, stdout, stderr, wait_thread|
  #     p stdin
  #     p stdout
  #     p stderr
  #     p wait_thread
  #     p wait_thread.pid
  # 