ve? # server may be `false'
          invoke_service(name)
          @cond.wait
        end
      end
    end

    def register(name, ro)
      synchronize do
        @servers[name] = ro
        @cond.signal
      end
      self
    end
    alias regist register

    def unregister(name)
      synchronize do
        @servers.delete(name)
      end
    end
    alias unregist unregister

    private
    def invoke_thread
      Thread.new do
        while name = @queue.pop
          invoke_service_command(name, @@command[name])
        end
      end
    end

    def invoke_service(name)
      @queue.push(name)
    end

    def invoke_service_command(name, command)
      raise "invalid command. name: #{name}" unless command
      synchronize do
        return if @servers.include?(name)
        @servers[name] = false
      end
      uri = @uri || DRb.uri
      if command.respond_to? :to_ary
        command = command.to_ary + [uri, name]
        pid = spawn(*command)
      else
        pid = spawn("#{command} #{uri} #{name}")
      end
      th = Process.detach(pid)
      th[:drb_service] = name
      th
    end
  end
end
                                                                                                                                                                                                         ruby/drb/gw.rb                                                                                      0000644                 00000006005 15040313424 0007233 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: false
require_relative 'drb'
require 'monitor'

module DRb

  # Gateway id conversion forms a gateway between different DRb protocols or
  # networks.
  #
  # The gateway needs to install this id conversion and create servers for
  # each of the protocols or networks it will be a gateway between.  It then
  # needs to create a server that attaches to each of these networks.  For
  # example:
  #
  #   require 'drb/drb'
  #   require 'drb/unix'
  #   require 'drb/gw'
  #
  #   DRb.install_id_conv DRb::GWIdConv.new
  #   gw = DRb::GW.new
  #   s1 = DRb::DRbServer.new 'drbunix:/path/to/gateway', gw
  #   s2 = DRb::DRbServer.new 'druby://example:10000', gw
  #
  #   s1.thread.join
  #   s2.thread.join
  #
  # Each client must register services with the gateway, for example:
  #
  #   DRb.start_service 'drbunix:', nil # an anonymous server
  #   gw = DRbObject.new nil, 'drbunix:/path/to/gateway'
  #   gw[:unix] = some_service
  #   DRb.thread.join

  class GWIdConv < DRbIdConv
    def to_obj(re                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ruby/drb/acl.rb                                                                                     0000644                 00000011161 15040313424 0007354 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ef]) # ??
        end
      else
        Marshal.dump([DRb.uri, [:DRbObject, @uri                                                                                                                        ruby/optionparser.rb                                                                                0000644                 00000000073 15040313423 0010572 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: false
require_relative 'optparse'
                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ruby/coverage.rb                                                                                    0000644                 00000000560 15040313423 0007641 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       require "coverage.so"

module Coverage
  def self.line_stub(file)
    lines = File.foreach(file).map { nil }
    iseqs = [RubyVM::InstructionSequence.compile_file(file)]
    until iseqs.empty?
      iseq = iseqs.pop
      iseq.trace_points.each {|n, type| lines[n - 1] = 0 if type == :line }
      iseq.each_child {|child| iseqs << child }
    end
    lines
  end
end
                                                                                                                                                ruby/random/formatter.rb                                                                            0000644                 00000030460 15040313423 0011333 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # -*- coding: us-ascii -*-
# frozen_string_literal: true

# == \Random number formatter.
#
# Formats generated random numbers in many manners. When <tt>'random/formatter'</tt>
# is required, several methods are added to empty core module <tt>Random::Formatter</tt>,
# making them available as Random's instance and module methods.
#
# Standard library SecureRandom is also extended with the module, and the methods
# described below are available as a module methods in it.
#
# === Examples
#
# Generate random hexadecimal strings:
#
#   require 'random/formatter'
#
#   prng = Random.new
#   prng.hex(10) #=> "52750b30ffbc7de3b362"
#   prng.hex(10) #=> "92b15d6c8dc4beb5f559"
#   prng.hex(13) #=> "39b290146bea6ce975c37cfc23"
#   # or just
#   Random.hex #=> "1aed0c631e41be7f77365415541052ee"
#
# Generate random base64 strings:
#
#   prng.base64(10) #=> "EcmTPZwWRAozdA=="
#   prng.base64(10) #=> "KO1nIU+p9DKxGg=="
#   prng.base64(12) #=> "7kJSM/MzBJI+75j8"
#   Random.base64(4) #=> "bsQ3fQ=="
#
# Generate random binary strings:
#
#   prng.random_bytes(10) #=> "\016\t{\370g\310pbr\301"
#   prng.random_bytes(10) #=> "\323U\030TO\234\357\020\a\337"
#   Random.random_bytes(6) #=> "\xA1\xE6Lr\xC43"
#
# Generate alphanumeric strings:
#
#   prng.alphanumeric(10) #=> "S8baxMJnPl"
#   prng.alphanumeric(10) #=> "aOxAg8BAJe"
#   Random.alphanumeric #=> "TmP9OsJHJLtaZYhP"
#
# Generate UUIDs:
#
#   prng.uuid #=> "2d931510-d99f-494a-8c67-87feb05e1594"
#   prng.uuid #=> "bad85eb9-0713-4da7-8d36-07a8e4b00eab"
#   Random.uuid #=> "f14e0271-de96-45cc-8911-8910292a42cd"
#
# All methods are available in the standard library SecureRandom, too:
#
#   SecureRandom.hex #=> "05b45376a30c67238eb93b16499e50cf"

module Random::Formatter

  # Generate a random binary string.
  #
  # The argument _n_ specifies the length of the result string.
  #
  # If _n_ is not specified or is nil, 16 is assumed.
  # It may be larger in future.
  #
  # The result may contain any byte: "\x00" - "\xff".
  #
  #   require 'random/formatter'
  #
  #   Random.random_bytes #=> "\xD8\\\xE0\xF4\r\xB2\xFC*WM\xFF\x83\x18\xF45\xB6"
  #   # or
  #   prng = Random.new
  #  