+..
#
# Converter +:date+ converts each field that Date::parse accepts:
#   data = '2001-02-03,x'
#   # Without the converter
#   csv = CSV.parse_line(data)
#   csv # => ["2001-02-03", "x"]
#   # With the converter
#   csv = CSV.parse_line(data, converters: :date)
#   csv # => [#<Date: 2001-02-03 ((2451944j,0s,0n),+0s,2299161j)>, "x"]
#
# Converter +:date_time+ converts each field that DateTime::parse accepts:
#   data = '2020-05-07T14:59:00-05:00,x'
#   # Without the converter
#   csv = CSV.parse_line(data)
#   csv # => ["2020-05-07T14:59:00-05:00", "x"]
#   # With the converter
#   csv = CSV.parse_line(data, converters: :date_time)
#   csv # => [#<DateTime: 2020-05-07T14:59:00-05:00 ((2458977j,71940s,0n),-18000s,2299161j)>, "x"]
#
# Converter +:numeric+ converts with both +:date_time+ and +:numeric+..
#
# As seen above, method #convert adds \converters to a \CSV instance,
# and method #converters returns an \Array of the \converters in effect:
#   csv = CSV.new('0,1,2')
#   csv.converters # => []
#   csv.convert(:integer)
#   csv.converters # => [:integer]
#   csv.convert(:date)
#   csv.converters # => [:integer, :date]
#
# ===== Custom Field \Converters
#
# You can define a custom field converter:
#   strip_converter = proc {|field| field.strip }
#   string = " foo , 0 \n bar , 1 \n baz , 2 \n"
#   array = CSV.parse(string, converters: strip_converter)
#   array # => [["foo", "0"], ["bar", "1"], ["baz", "2"]]
# You can register the converter in \Converters \Hash,
# which allows you to refer to it by name:
#   CSV::Converters[:strip] = strip_converter
#   string = " foo , 0 \n bar , 1 \n baz , 2 \n"
#   array = CSV.parse(string, converters: :strip)
#   array # => [["foo", "0"], ["bar", "1"], ["baz", "2"]]
#
# ==== Header \Converters
#
# Header converters operate only on headers (and not on other rows).
#
# There are three ways to use header \converters;
# these examples use built-in header converter +:downcase+,
# which downcases each parsed header.
#
# - Option +header_converters+ with a singleton parsing method:
#     string = "Name,Count\nFoo,0\n,Bar,1\nBaz,2"
#     tbl = CSV.parse(string, headers: true, header_converters: :downcase)
#     tbl.class # => CSV::Table
#     tbl.headers # => ["name", "count"]
#
# - Option +header_converters+ with a new \CSV instance:
#     csv = CSV.new(string, header_converters: :downcase)
#     # Header converters in effect:
#     csv.header_converters # => [:downcase]
#     tbl = CSV.parse(string, headers: true)
#     tbl.headers # => ["Name", "Count"]
#
# - Method #header_convert adds a header converter to a \CSV instance:
#     csv = CSV.new(string)
#     # Add a header converter.
#     csv.header_convert(:downcase)
#     csv.header_converters # => [:downcase]
#     tbl = CSV.parse(string, headers: true)
#     tbl.headers # => ["Name", "Count"]
#
# ===== Built-In Header \Converters
#
# The built-in header \converters are in \Hash CSV::HeaderConverters.
# The keys there are the names of the \converters:
#   CSV::HeaderConverters.keys # => [:downcase, :symbol]
#
# Converter +:downcase+ converts each header by downcasing it:
#   string = "Name,Count\nFoo,0\n,Bar,1\nBaz,2"
#   tbl = CSV.parse(string, headers: true, header_converters: :downcase)
#   tbl.class # => CSV::Table
#   tbl.headers # => ["name", "count"]
#
# Converter +:symbol+ converts each header by making it into a \Symbol:
#   string = "Name,Count\nFoo,0\n,Bar,1\nBaz,2"
#   tbl = CSV.parse(string, headers: true, header_converters: :symbol)
#   tbl.headers # => [:name, :count]
# Details:
# - Strips leading and trailing whitespace.
# - Downcases the header.
# - Replaces embedded spaces with underscores.
# - Removes non-word characters.
# - Makes the string into a \Symbol.
#
# ===== Custom Header \Converters
#
# You can define a custom header converter:
#   upcase_converter = proc {|header| header.upcase }
#   string = "Name,Value\nfoo,0\nbar,1\nbaz,2\n"
#   table = CSV.parse(string, headers: true, header_converters: upcase_converter)
#   table # => #<CSV::Table mode:col_or_row row_count:4>
#   table.headers # => ["NAME", "VALUE"]
# You can register the converter in \HeaderConverters \Hash,
# which allows you to refer to it by name:
#   CSV::HeaderConverters[:upcase] = upcase_converter
#   table = CSV.parse(string, headers: true, header_converters: :upcase)
#   table # => #<CSV::Table mode:col_or_row row_count:4>
#   table.headers # => ["NAME", "VALUE"]
#
# ===== Write \Converters
#
# When you specify a write converter for generating \CSV,
# each field to be written is passed to the converter;
# its return value becomes the new value for the field.
# A converter might, for example, strip whitespace from a field.
#
# Using no write converter (all fields unmodified):
#   output_string = CSV.generate do |csv|
#     csv << [' foo ', 0]
#     csv << [' bar ', 1]
#     csv << [' baz ', 2]
#   end
#   output_string # => " foo ,0\n bar ,1\n baz ,2\n"
# Using option +write_converters+ with two custom write converters:
#   strip_converter = proc {|field| field.respond_to?(:strip) ? field.strip : field }
#   upcase_converter = proc {|field| field.respond_to?(:upcase) ? field.upcase : field }
#   write_converters = [strip_converter, upcase_converter]
#   output_string = CSV.generate(write_converters: write_converters) do |csv|
#     csv << [' foo ', 0]
#     csv << [' bar ', 1]
#     csv << [' baz ', 2]
#   end
#   output_string # => "FOO,0\nBAR,1\nBAZ,2\n"
#
# === Character Encodings (M17n or Multilingualizati                                                                                                                                        ruby/csv/delete_suffix.rb                                                                           0000644                 00000000566 15040313426 0011500 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       this
# makes the entire process feel transparent, since CSV's defaults should just
# magically work for your data. However, you can set these values manually in
# the target Encoding to avoid the translation.
#
# It's also important to note that while all of CSV's core parser is now
# Encoding agnostic, some features are not. For example, the built-in
# converters will tr                                                                                                                                          ruby/csv/parser.rb                                                                                  0000644                 00000111310 15040313426 0010134 0                                                                                                    ustar 0