 f.chmod 0700
      }
    rescue Errno::EISDIR # JRuby in non-native mode can't open files as dirs
      File.lstat(dot_file).tap {|fstat|
        unless fu_stat_identical_entry?(st, fstat)
          # symlink (TOC-to-TOU attack?)
          File.unlink fullpath
          return
        end
        File.chown euid, -1, dot_file
        File.chmod 0700, dot_file
      }
    end

    unless fu_stat_identical_entry?(st, File.lstat(fullpath))
      # TOC-to-TOU attack?
      File.unlink fullpath
      return
    end

    # ---- tree root is frozen ----
    root = Entry_.new(path)
    root.preorder_traverse do |ent|
      if ent.directory?
        ent.chown euid, -1
        ent.chmod 0700
      end
    end
    root.postorder_traverse do |ent|
      begin
        ent.remove
      rescue
        raise unless force
      end
    end
  rescue
    raise unless force
  end
  module_function :remove_entry_secure

  def fu_have_symlink?   #:nodoc:
    File.symlink nil, nil
  rescue NotImplementedError
    return false
  rescue TypeError
    return true
  end
  private_module_function :fu_have_symlink?

  def fu_stat_identical_entry?(a, b)   #:nodoc:
    a.dev == b.dev and a.ino == b.ino
  end
  private_module_function :fu_stat_identical_entry?

  # Removes the entry given by +path+,
  # which should be the entry for a regular file, a symbolic link,
  # or a directory.
  #
  # Argument +path+
  # should be {interpretable as a path}[rdoc-ref:FileUtils@Path+Arguments].
  #
  # Optional argument +force+ specifies whether to ignore
  # raised exceptions of StandardError and its descendants.
  #
  # Related: FileUtils.remove_entry_secure.
  #
  def remove_entry(path, force = false)
    Entry_.new(path).postorder_traverse do |ent|
      begin
        ent.remove
      rescue
        raise unless force
      end
    end
  rescue
    raise unless force
  end
  module_function :remove_entry

  # Removes the file entry given by +path+,
  # which should be the entry for a regular file or a symbolic link.
  #
  # Argument +path+
  # should be {interpretable as a path}[rdoc-ref:FileUtils@Path+Arguments].
  #
  # Optional argument +force+ specifies whether to ignore
  # raised exceptions of StandardError and its descendants.
  #
  # Related: {methods for deleting}[rdoc-ref:FileUtils@Deleting].
  #
  def remove_file(path, force = false)
    Entry_.new(path).remove_file
  