# frozen_string_literal: true

# This class is the base class for \Net::HTTP request classes.
# The class should not be used directly;
# instead you should use its subclasses, listed below.
#
# == Creating a Request
#
# An request object may be created with either a URI or a string hostname:
#
#   require 'net/http'
#   uri = URI('https://jsonplaceholder.typicode.com/')
#   req = Net::HTTP::Get.new(uri)          # => #<Net::HTTP::Get GET>
#   req = Net::HTTP::Get.new(uri.hostname) # => #<Net::HTTP::Get GET>
#
# And with any of the subclasses:
#
#   req = Net::HTTP::Head.new(uri) # => #<Net::HTTP::Head HEAD>
#   req = Net::HTTP::Post.new(uri) # => #<Net::HTTP::Post POST>
#   req = Net::HTTP::Put.new(uri)  # => #<Net::HTTP::Put PUT>
#   # ...
#
# The new instance is suitable for use as the argument to Net::HTTP#request.
#
# == 