_sock = s
          end
          proxy_sock = BufferedIO.new(proxy_sock, read_timeout: @read_timeout,
                                      write_timeout: @write_timeout,
                                      continue_timeout: @continue_timeout,
                                      debug_output: @debug_output)
          buf = +"CONNECT #{conn_address}:#{@port} HTTP/#{HTTPVersion}\r\n" \
            "Host: #{@address}:#{@port}\r\n"
          if proxy_user
            credential = ["#{proxy_user}:#{proxy_pass}"].pack('m0')
            buf << "Proxy-Authorization: Basic #{credential}\r\n"
          end
          buf << "\r\n"
          proxy_sock.write(buf)
          HTTPResponse.read_new(proxy_sock).value
          # assuming nothing left in buffers after successful CONNECT response
        end

        ssl_parameters = Hash.new
        iv_list = instance_variables
        SSL_IVNAMES.each_with_index do |ivname, i|
          if iv_list.include?(ivname)
            value = instance_variable_get(ivname)
            unless value.nil?
              ssl_parameters[SSL_ATTRIBUTES[i]] = value
            end
          end
        end
        @ssl_context.set_params(ssl_parameters)
        unless @ssl_context.session_cache_mode.nil? # a dummy method on JRuby
          @ssl_context.session_cache_mode =
              OpenSSL::SSL::SSLContext::SESSION_CACHE_CLIENT |
                  OpenSSL::SSL::SSLContext::SESSION_CACHE_NO_INTERNAL_STORE
        end
        if @ssl_context.respond_to?(:session_new_cb) # not implemented under JRuby
          @ssl_context.session_new_cb = proc {|sock, sess| @ssl_session = sess }
        end

        # Still do the post_connection_check below even if connecting
        # to IP address
        verify_hostname = @ssl_context.verify_hostname

        # Server Name Indication (SNI) RFC 3546/6066
        case @address
        when Resolv::IPv4::Regex, Resolv::IPv6::Regex
          # don't set SNI, as IP addresses in SNI is not valid
          # per RFC 6066, section 3.

          # Avoid openssl warning
          @ssl_context.verify_hostname = false
        else
          ssl_host_address = @address
        end

        debug "starting SSL for #{conn_addr}:#{conn_port}..."
        s = OpenSSL::SSL::SSLSocket.new(s, @ssl_context)
        s.sync_close = true
        s.hostname = ssl_host_address if s.respond_to?(:hostname=) && ssl_host_address

        if @ssl_session and
           Process.clock_gettime(Process::CLOCK_REALTIME) < @ssl_session.time.to_f + @ssl_session.timeout
          s.session = @ssl_session
        end
        ssl_socket_connect(s, @open_timeout)
        if (@ssl_context.verify_mode != OpenSSL::SSL::VERIFY_NONE) && verify_hostname
          s.post_connection_check(@address)
        end
        debug "SSL established, protocol: #{s.ssl_version}, cipher: #{s.cipher[0]}"
      end
      @socket = BufferedIO.new(s, read_timeout: @read_timeout,
                               write_timeout: @write_timeout,
                               continue_timeout: @continue_timeout,
                               debug_output: @debug_output)
      @last_communicated = nil
      on_connect
    rescue => exception
      if s
        debug "Conn close because of connect error #{exception}"
        s.close
      end
      raise
    end
    private :connect

    def on_connect
    end
    private :on_connect

    # Finishes the \HTTP session:
    #
    #   http = Net::HTTP.new(hostname)
    #   http.start
    #   http.started? # => true
    #   http.finish   # => nil
    #   http.started? # => false
    #
    # Raises IOError if not in a session.
    def finish
      raise IOError, 'HTTP session not yet started' unless started?
      do_finish
    end

    def do_finish
      @started = false
      @socket.close if @socket
      @socket = nil
    end
    private :do_finish

    #
    # proxy
    #

    public

    # no proxy
    @is_proxy_class = false
    @proxy_from_env = false
    @proxy_addr = nil
    @proxy_port = nil
    @proxy_user = nil
    @proxy_pass = nil
    @proxy_use_ssl = nil

    # Creates an \HTTP proxy class which behaves like \Net::HTTP, but
    # performs all access via the specified proxy.
    #
    # This class is obsolete.  You may pass these same parameters directly to
    # \Net::HTTP.new.  See Net::HTTP.new for details of the arguments.
    def HTTP.Proxy(p_addr = :ENV, p_port = nil, p_user = nil, p_pass = nil, p_use_ssl = nil) #:nodoc:
      return self unless p_addr

      Class.new(self) {
        @is_proxy_class = true

        if p_addr == :ENV then
          @proxy_from_env = true
          @proxy_address = nil
          @proxy_port    = nil
        else
          @proxy_from_env = false
          @proxy_address = p_addr
          @proxy_port    = p_port || default_port
        end

        @proxy_user = p_user
        @proxy_pass = p_pass
        @proxy_use_ssl = p_use_ssl
      }
    end

    class << HTTP
      # Returns true if self is a class which was created by HTTP::Proxy.
      def proxy_class?
        defined?(@is_proxy_class) ? @is_proxy_class : false
      end

      # Returns the address of the proxy host, or +nil+ if none;
      # see Net::HTTP@Proxy+Server.
      attr_reader :proxy_address

      # Returns the port number of the proxy host, or +nil+ if none;
      # see Net::HTTP@Proxy+Server.
      attr_reader :proxy_port

      # Returns the user name for accessing the proxy, or +nil+ if none;
      # see Net::HTTP@Proxy+Server.
      attr_reader :proxy_user

      # Returns the password for accessing the proxy, or +nil+ if none;
      # see Net::HTTP@Proxy+Server.
      attr_reader :proxy_pass

      # Use SSL when talking to the proxy. If Net::HTTP does not use a proxy, nil.
      attr_reader :proxy_use_ssl
    end

    # Returns +true+ if a proxy server is defined, +false+ otherwise;
    # see {Proxy Server}[rdoc-ref:Net::HTTP@Proxy+Server].
    def proxy?
      !!(@proxy_from_env ? proxy_uri : @proxy_address)
    end

    # Returns +true+ if the proxy server is defined in the environment,
    # +false+ otherwise;
    # see {Proxy Server}[rdoc-ref:Net::HTTP@Proxy+Server].
    def proxy_from_env?
      @proxy_from_env
    end

    # The proxy URI determined from the environment for this connection.
    def proxy_uri # :nodoc:
      return if @proxy_uri == false
      @proxy_uri ||= URI::HTTP.new(
        "http", nil, address, port, nil, nil, nil, nil, nil
      ).find_proxy || false
      @proxy_uri || nil
    end

    # Returns the address of the proxy server, if defined, +nil+ otherwise;
    # see {Proxy Server}[rdoc-ref:Net::HTTP@Proxy+Server].
    def proxy_address
      if @proxy_from_env then
        proxy_uri&.hostname
      else
        @proxy_address
      end
    end

    # Returns the port number of the proxy server, if defined, +nil+ otherwise;
    # see {Proxy Server}[rdoc-ref:Net::HTTP@Proxy+Server].
    def proxy_port
      if @proxy_from_env then
        proxy_uri&.port
      else
        @proxy_port
      end
    end

    # Returns the user name of the proxy server, if defined, +nil+ otherwise;
    # see {Proxy Server}[rdoc-ref:Net::HTTP@Proxy+Server].
    def proxy_user
      if @proxy_from_env
        user = proxy_uri&.user
        unescape(user) if user
      else
        @proxy_user
      end
    end

    # Returns the password of the proxy server, if defined, +nil+ otherwise;
    # see {Proxy Server}[rdoc-ref:Net::HTTP@Proxy+Server].
    def proxy_pass
      if @proxy_from_env
        pass = proxy_uri&.password
        unescape(pass) if pass
      else
        @proxy_pass
      end
    end

    alias proxyaddr proxy_address   #:nodoc: obsolete
    alias proxyport proxy_port      #:nodoc: obsolete

    private

    def unescape(value)
      require 'cgi/util'
      CGI.unescape(value)
    end

    # without proxy, obsolete

    def conn_address # :nodoc:
      @ipaddr || address()
    end

    def conn_port # :nodoc:
      port()
    end

    def edit_path(path)
      if proxy?
        if path.start_with?("ftp://") || use_ssl?
          path
        else
          "http://#{addr_port}#{path}"
        end
      else
        path
      end
    end

    #
    # HTTP operations
    #

    public

    # :call-seq:
    #    get(path, initheader = nil) {|res| ... }
    #
    # Sends a GET request to the server;
    # returns an instance of a subclass of Net::HTTPResponse.
    #
    # The request is based on the Net::HTTP::Get object
    # created from string +path+ and initial headers hash +initheader+.
    #
    # With a block given, calls the block with the response body:
    #
    #   http = Net::HTTP.new(hostname)
    #   http.get('/todos/1') do |res|
    #     p res
    #   end # => #<Net::HTTPOK 200 OK readbody=true>
    #
    # Output:
    #
    #   "{\n  \"userId\": 1,\n  \"id\": 1,\n  \"title\": \"delectus aut autem\",\n  \"completed\": false\n}"
    #
    # With no block given, simply returns the response object:
    #
    #   http.get('/') # => #<Net::HTTPOK 200 OK readbody=true>
    #
    # Related:
    #
    # - Net::HTTP::Get: request class for \HTTP method GET.
    # - Net::HTTP.get: sends GET request, returns response body.
    #
    def get(path, initheader = nil, dest = nil, &block) # :yield: +body_segment+
      res = nil

      request(Get.new(path, initheader)) {|r|
        r.read_body dest, &block
        res = r
      }
      res
    end

    # Sends a HEAD request to the server;
    # returns an instance of a subclass of Net::HTTPResponse.
    #
    # The request is based on the Net::HTTP::Head object
    # created from string +path+ and initial headers hash +initheader+:
    #
    #   res = http.head('/todos/1') # => #<Net::HTTPOK 200 OK readbody=true>
    #   res.body                    # => nil
    #   res.to_hash.take(3)
    #   # =>
    #   [["date", ["Wed, 15 Feb 2023 15:25:42 GMT"]],
    #    ["content-type", ["application/json; charset=utf-8"]],
    #    ["connection", ["close"]]]
    #
    def head(path, initheader = nil)
      request(Head.new(path, initheader))
    end

    # :call-seq:
    #    post(path, data, initheader = nil) {|res| ... }
    #
    # Sends a POST request to the server;
    # returns an instance of a subclass of Net::HTTPResponse.
    #
    # The request is based on the Net::HTTP::Post object
    # created from string +path+, string +data+, and initial headers hash +initheader+.
    #
    # With a block given, calls the block with the response body:
    #
    #   data = '{"userId": 1, "id": 1, "title": "delectus aut autem", "completed": false}'
    #   http = Net::HTTP.new(hostname)
    #   http.post('/todos', data) do |res|
    #     p res
    #   end # => #<Net::HTTPCreated 201 Created readbody=true>
    #
    # Output:
    #
    #   "{\n  \"{\\\"userId\\\": 1, \\\"id\\\": 1, \\\"title\\\": \\\"delectus aut autem\\\", \\\"completed\\\": false}\": \"\",\n  \"id\": 201\n}"
    #
    # With no block given, simply returns the response object:
    #
    #   http.post('/todos', data) # => #<Net::HTTPCreated 201 Created readbody=true>
    #
    # Related:
    #
    # - Net::HTTP::Post: request class for \HTTP method POST.
    # - Net::HTTP.post: sends POST request, returns response body.
    #
    def post(path, data, initheader = nil, dest = nil, &block) # :yield: +body_segment+
      send_entity(path, data, initheader, dest, Post, &block)
    end

    # :call-seq:
    #    patch(path, data, initheader = nil) {|res| ... }
    #
    # Sends a PATCH request to the server;
    # returns an instance of a subclass of Net::HTTPResponse.
    #
    # The request is based on the Net::HTTP::Patch object
    # created from string +path+, string +data+, and initial headers hash +initheader+.
    #
    # With a block given, calls the block with the response body:
    #
    #   data = '{"userId": 1, "id": 1, "title": "delectus aut autem", "completed": false}'
    #   http = Net::HTTP.new(hostname)
    #   http.patch('/todos/1', data) do |res|
    #     p res
    #   end # => #<Net::HTTPOK 200 OK readbody=true>
    #
    # Output:
    #
    #   "{\n  \"userId\": 1,\n  \"id\": 1,\n  \"title\": \"delectus aut autem\",\n  \"completed\": false,\n  \"{\\\"userId\\\": 1, \\\"id\\\": 1, \\\"title\\\": \\\"delectus aut autem\\\", \\\"completed\\\": false}\": \"\"\n}"
    #
    # With no block given, simply returns the response object:
    #
    #   http.pa