r \Float) number of seconds
    # to keep the connection open after a request is sent;
    # initially 2.
    # If a new request is made during the given interval,
    # the still-open connection is used;
    # otherwise the connection will have been closed
    # and a new connection is opened.
    attr_accessor :keep_alive_timeout

    # Sets or returns whether to ignore end-of-file when reading a response body
    # with <tt>Content-Length</tt> headers;
    # initially +true+.
    attr_accessor :ignore_eof

    # Returns +true+ if the \HTTP session has been started:
    #
    #   http = Net::HTTP.new(hostname)
    #   http.started? # => false
    #   http.start
    #   http.started? # => true
    #   http.finish # => nil
    #   http.started? # => false
    #
    #   Net::HTTP.start(hostname) do |http|
    #     http.started?
    #   end # => true
    #   http.started? # => false
    #
    def started?
      @started
    end

    alias active? started?   #:nodoc: obsolete

    # Sets or returns whether to close the connection when the response is empty;
    # initially +false+.
    attr_accessor :close_on_empty_response

    # Returns +true+ if +self+ uses SSL, +false+ otherwise.
    # See Net::HTTP#use_ssl=.
    def use_ssl?
      @use_ssl
    end

    # Sets whether a new session is to use
    # {Transport Layer Security}[https://en.wikipedia.org/wiki/Transport_Layer_Security]:
    #
    # Raises IOError if attempting to change during a session.
    #
    # Raises OpenSSL::SSL::SSLError if the port is not an HTTPS port.
    def use_ssl=(flag)
      flag = flag ? true : false
      if started? and @use_ssl != flag
        raise IOError, "use_ssl value changed, but session already started"
      end
      @use_ssl = flag
    end

    SSL_ATTRIBUTES = [
      :ca_file,
      :ca_path,
      :cert,
      :cert_store,
      :ciphers,
      :extra_chain_cert,
      :key,
      :ssl_timeout,
      :ssl_version,
      :min_version,
      :max_version,
      :verify_callback,
      :verify_depth,
      :verify_mode,
      :verify_hostname,
    ] # :nodoc:

    SSL_IVNAMES = SSL_ATTRIBUTES.map { |a| "@#{a}".to_sym } # :nodoc:

    # Sets or returns the path to a CA certification file in PEM format.
    attr_accessor :ca_file

    # Sets or returns the path of to CA directory
    # containing certification files in PEM format.
    attr_accessor :ca_path

    # Sets or returns the OpenSSL::X509::Certificate object
    # to be used for client certification.
    attr_accessor :cert

    # Sets or returns the X509::Store to be used for verifying peer certificate.
    attr_accessor :cert_store

    # Sets or returns the available SSL ciphers.
    # See {OpenSSL::SSL::SSLContext#ciphers=}[OpenSSL::SSL::SSL::Context#ciphers=].
    attr_accessor :ciphers

    # Sets or returns the extra X509 certificates to be added to the certifica