rg/rfc/rfc2518#section-10.1].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#102].
  #
  class HTTPProcessing < HTTPInformation
    HAS_BODY = false
  end

  # Response class for <tt>Early Hints</tt> responses (status code 103).
  #
  # The <tt>Early Hints</tt> indicates that the server has received
  # and is processing the request, and contains certain headers;
  # the final response is not available yet.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/103].
  # - {RFC 8297}[https://www.rfc-editor.org/rfc/rfc8297.html#section-2].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#103].
  #
  class HTTPEarlyHints < HTTPInformation
    HAS_BODY = false
  end

  # Response class for +OK+ responses (status code 200).
  #
  # The +OK+ response indicates that the server has received
  # a request and has responded successfully.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/200].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-200-ok].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#200].
  #
  class HTTPOK < HTTPSuccess
    HAS_BODY = true
  end

  # Response class for +Created+ responses (status code 201).
  #
  # The +Created+ response indicates that the server has received
  # and has fulfilled a request to create a new resource.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/201].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-201-created].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#201].
  #
  class HTTPCreated < HTTPSuccess
    HAS_BODY = true
  end

  # Response class for +Accepted+ responses (status code 202).
  #
  # The +Accepted+ response indicates that the server has received
  # and is processing a request, but the processing has not yet been completed.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/202].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-202-accepted].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#202].
  #
  class HTTPAccepted < HTTPSuccess
    HAS_BODY = true
  end

  # Response class for <tt>Non-Authoritative Information</tt> responses (status code 203).
  #
  # The <tt>Non-Authoritative Information</tt> response indicates that the server
  # is a transforming proxy (such as a Web accelerator)
  # that received a 200 OK response from its origin,
  # and is returning a modified version of the origin's response.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/203].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-203-non-authoritative-infor].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#203].
  #
  class HTTPNonAuthoritativeInformation < HTTPSuccess
    HAS_BODY = true
  end

  # Response class for <tt>No Content</tt> responses (status code 204).
  #
  # The <tt>No Content</tt> response indicates that the server
  # successfully processed the request, and is not returning any content.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/204].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-204-no-content].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#204].
  #
  class HTTPNoContent < HTTPSuccess
    HAS_BODY = false
  end

  # Response class for <tt>Reset Content</tt> responses (status code 205).
  #
  # The <tt>Reset Content</tt> response indicates that the server
  # successfully processed the request,
  # asks that the client reset its document view, and is not returning any content.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/205].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-205-reset-content].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#205].
  #
  class HTTPResetContent < HTTPSuccess
    HAS_BODY = false
  end

  # Response class for <tt>Partial Content</tt> responses (status code 206).
  #
  # The <tt>Partial Content</tt> response indicates that the server is delivering
  # only part of the resource (byte serving)
  # due to a Range header in the request.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/206].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-206-partial-content].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#206].
  #
  class HTTPPartialContent < HTTPSuccess
    HAS_BODY = true
  end

  # Response class for <tt>Multi-Status (WebDAV)</tt> responses (status code 207).
  #
  # The <tt>Multi-Status (WebDAV)</tt> response indicates that the server
  # has received the request,
  # and that the message body can contain a number of separate response codes.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {RFC 4818}[https://www.rfc-editor.org/rfc/rfc4918#section-11.1].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#207].
  #
  class HTTPMultiStatus < HTTPSuccess
    HAS_BODY = true
  end

  # Response class for <tt>Already Reported (WebDAV)</tt> responses (status code 208).
  #
  # The <tt>Already Reported (WebDAV)</tt> response indicates that the server
  # has received the request,
  # and that the members of a DAV binding have already been enumerated
  # in a preceding part of the (multi-status) response,
  # and are not being included again.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {RFC 5842}[https://www.rfc-editor.org/rfc/rfc5842.html#section-7.1].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#208].
  #
  class HTTPAlreadyReported < HTTPSuccess
    HAS_BODY = true
  end

  # Response class for <tt>IM Used</tt> responses (status code 226).
  #
  # The <tt>IM Used</tt> response indicates that the server has fulfilled a request
  # for the resource, and the response is a representation of the result
  # of one or more instance-manipulations applied to the current instance.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {RFC 3229}[https://www.rfc-editor.org/rfc/rfc3229.html#section-10.4.1].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#226].
  #
  class HTTPIMUsed < HTTPSuccess
    HAS_BODY = true
  end

  # Response class for <tt>Multiple Choices</tt> responses (status code 300).
  #
  # The <tt>Multiple Choices</tt> response indicates that the server
  # offers multiple options for the resource from which the client may choose.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/300].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-300-multiple-choices].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#300].
  #
  class HTTPMultipleChoices < HTTPRedirection
    HAS_BODY = true
  end
  HTTPMultipleChoice = HTTPMultipleChoices

  # Response class for <tt>Moved Permanently</tt> responses (status code 301).
  #
  # The <tt>Moved Permanently</tt> response indicates that links or records
  # returning this response should be updated to use the given URL.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/301].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-301-moved-permanently].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#301].
  #
  class HTTPMovedPermanently < HTTPRedirection
    HAS_BODY = true
  end

  # Response class for <tt>Found</tt> responses (status code 302).
  #
  # The <tt>Found</tt> response indicates that the client
  # should look at (browse to) another URL.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/302].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-302-found].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#302].
  #
  class HTTPFound < HTTPRedirection
    HAS_BODY = true
  end
  HTTPMovedTemporarily = HTTPFound

  # Response class for <tt>See Other</tt> responses (status code 303).
  #
  # The response to the request can be found under another URI using the GET method.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/303].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-303-see-other].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#303].
  #
  class HTTPSeeOther < HTTPRedirection
    HAS_BODY = true
  end

  # Response class for <tt>Not Modified</tt> responses (status code 304).
  #
  # Indicates that the resource has not been modified since the version
  # specified by the request headers.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/304].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-304-not-modified].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#304].
  #
  class HTTPNotModified < HTTPRedirection
    HAS_BODY = false
  end

  # Response class for <tt>Use Proxy</tt> responses (status code 305).
  #
  # The requested resource is available only through a proxy,
  # whose address is provided in the response.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-305-use-proxy].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#305].
  #
  class HTTPUseProxy < HTTPRedirection
    HAS_BODY = false
  end

  # Response class for <tt>Temporary Redirect</tt> responses (status code 307).
  #
  # The request should be repeated with another URI;
  # however, future requests should still use the original URI.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/307].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-307-temporary-redirect].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#307].
  #
  class HTTPTemporaryRedirect < HTTPRedirection
    HAS_BODY = true
  end

  # Response class for <tt>Permanent Redirect</tt> responses (status code 308).
  #
  # This and all future requests should be directed to the given URI.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/308].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-308-permanent-redirect].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#308].
  #
  class HTTPPermanentRedirect < HTTPRedirection
    HAS_BODY = true
  end

  # Response class for <tt>Bad Request</tt> responses (status code 400).
  #
  # The server cannot or will not process the request due to an apparent client error.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/400].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-400-bad-request].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#400].
  #
  class HTTPBadRequest < HTTPClientError
    HAS_BODY = true
  end

  # Response class for <tt>Unauthorized</tt> responses (status code 401).
  #
  # Authentication is required, but either was not provided or failed.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/401].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-401-unauthorized].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#401].
  #
  class HTTPUnauthorized < HTTPClientError
    HAS_BODY = true
  end

  # Response class for <tt>Payment Required</tt> responses (status code 402).
  #
  # Reserved for future use.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/402].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-402-payment-required].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#402].
  #
  class HTTPPaymentRequired < HTTPClientError
    HAS_BODY = true
  end

  # Response class for <tt>Forbidden</tt> responses (status code 403).
  #
  # The request contained valid data and was understood by the server,
  # but the server is refusing action.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/403].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-403-forbidden].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#403].
  #
  class HTTPForbidden < HTTPClientError
    HAS_BODY = true
  end

  # Response class for <tt>Not Found</tt> responses (status code 404).
  #
  # The requested resource could not be found but may be available in the future.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/404].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-404-not-found].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#404].
  #
  class HTTPNotFound < HTTPClientError
    HAS_BODY = true
  end

  # Response class for <tt>Method Not Allowed</tt> responses (status code 405).
  #
  # The request method is not supported for the requested resource.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/405].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-405-method-not-allowed].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#405].
  #
  class HTTPMethodNotAllowed < HTTPClientError
    HAS_BODY = true
  end

  # Response class for <tt>Not Acceptable</tt> responses (status code 406).
  #
  # The requested resource is capable of generating only content
  # that not acceptable according to the Accept headers sent in the request.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/406].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-406-not-acceptable].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#406].
  #
  class HTTPNotAcceptable < HTTPClientError
    HAS_BODY = true
  end

  # Response class for <tt>Proxy Authentication Required</tt> responses (status code 407).
  #
  # The client must first authenticate itself with the proxy.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/407].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-407-proxy-authentication-re].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#407].
  #
  class HTTPProxyAuthenticationRequired < HTTPClientError
    HAS_BODY = true
  end

  # Response class for <tt>Request Timeout</tt> responses (status code 408).
  #
  # The server timed out waiting for the request.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/408].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-408-request-timeout].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#408].
  #
  class HTTPRequestTimeout < HTTPClientError
    HAS_BODY = true
  end
  HTTPRequestTimeOut = HTTPRequestTimeout

  # Response class for <tt>Conflict</tt> responses (status code 409).
  #
  # The request could not be processed because of conflict in the current state of the resource.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/409].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-409-conflict].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#409].
  #
  class HTTPConflict < HTTPClientError
    HAS_BODY = true
  end

  # Response class for <tt>Gone</tt> responses (status code 410).
  #
  # The resource requested was previously in use but is no longer available
  # and will not be available again.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/410].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-410-gone].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#410].
  #
  class HTTPGone < HTTPClientError
    HAS_BODY = true
  end

  # Response class for <tt>Length Required</tt> responses (status code 411).
  #
  # The request did not specify the length of its content,
  # which is required by the requested resource.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/411].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-411-length-required].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#411].
  #
  class HTTPLengthRequired < HTTPClientError
    HAS_BODY = true
  end

  # Response class for <tt>Precondition Failed</tt> responses (status code 412).
  #
  # The server does not meet one of the preconditions
  # specified in the request headers.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/412].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-412-precondition-failed].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#412].
  #
  class HTTPPreconditionFailed < HTTPClientError
    HAS_BODY = true
  end

  # Response class for <tt>Payload Too Large</tt> responses (status code 413).
  #
  # The request is larger than the server is willing or able to process.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/413].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-413-content-too-large].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#413].
  #
  class 