options)
      self.generate(**options) do |csv|
        rows.each do |row|
          csv << row
        end
      end
    end

    #
    # :call-seq:
    #   open(file_path, mode = "rb", **options ) -> new_csv
    #   open(io, mode = "rb", **options ) -> new_csv
    #   open(file_path, mode = "rb", **options ) { |csv| ... } -> object
    #   open(io, mode = "rb", **options ) { |csv| ... } -> object
    #
    # possible options elements:
    #   keyword form:
    #     :invalid => nil      # raise error on invalid byte sequence (default)
    #     :invalid => :replace # replace invalid byte sequence
    #     :undef => :replace   # replace undefined conversion
    #     :replace => string   # replacement string ("?" or "\uFFFD" if not specified)
    #
    # * Argument +path+, if given, must be the path to a file.
    # :include: ../doc/csv/arguments/io.rdoc
    # * Argument +mode+, if given, must be a \File mode
    #   See {Open Mode}[IO.html#method-c-new-label-Open+Mode].
    # * Arguments <tt>**options</tt> must be keyword options.
    #   See {Options for Generating}[#class-CSV-label-Options+for+Generating].
    # * This method optionally accepts an additional <tt>:encoding</tt> option
    #   that you can use to specify the Encoding of the data read from +path+ or +io+.
    #   You must provide this unless your data is in the encoding
    #   given by <tt>Encoding::default_external</tt>.
    #   Parsing will use this to determine how to parse the data.
    #   You may provide a second Encoding to
    #   have the data transcoded as it is read. For example,
    #     encoding: 'UTF-32BE:UTF-8'
    #   would read +UTF-32BE+ data from the fi