v_sec})"
        }
        q.comma_breakable
        q.group {
          t = self.ctime
          q.text "ctime="; q.pp t
          q.breakable; q.text "(#{t.tv_sec})"
        }
      }
    end
  end
end

class MatchData # :nodoc:
  def pretty_print(q) # :nodoc:
    nc = []
    self.regexp.named_captures.each {|name, indexes|
      indexes.each {|i| nc[i] = name }
    }
    q.object_group(self) {
      q.breakable
      q.seplist(0...self.size, lambda { q.breakable }) {|i|
        if i == 0
          q.pp self[i]
        else
          if nc[i]
            q.text nc[i]
          else
            q.pp i
          end
          q.text ':'
          q.pp self[i]
        end
      }
    }
  end
end

if defined?(RubyVM::AbstractSyntaxTree)
  class RubyVM::AbstractSyntaxTree::Node # :nodoc:
    def pretty_print_children(q, names = [])
      children.zip(names) do |c, n|
        if n
          q.breakable
          q.text "#{n}:"
        end
        q.group(2) do
          q.breakable
          q.pp c
        end
      end
    end

    def pretty_print(q)
      q.group(1, "(#{type}@#{first_lineno}:#{first_column}-#{last_lineno}:#{last_column}", ")") {
        case type
        when :SCOPE
          pretty_print_children(q, %w"tbl args body")
        when :ARGS
          pretty_print_children(q, %w[pre_num pre_init opt first_post post_num post_init rest kw kwrest block])
        when :DEFN
          pretty_print_children(q, %w[mid body])
        when :ARYPTN
          pretty_print_children(q, %w[const pre rest post])
        when :HSHPTN
          pretty_print_children(q, %w[const kw kwrest])
        else
          pretty_print_children(q)
        end
      }
    end
  end
end

class Object < BasicObject # :nodoc:
  include PP::ObjectMixin
end

[Numeric, Symbol, FalseClass, TrueClass, NilClass, Module].each {|c|
  c.class_eval {
    def pretty_print_cycle(q)
      q.text inspect
    end
  }
}

[Numeric, FalseClass, TrueClass, Module].each {|c|
  c.class_eval {
    def pretty_print(q)
      q.text inspect
    end
  }
}

module Kernel
  # Returns a pretty printed object as a string.
  #
  # See the PP module for more information.
  def pretty_inspect
    PP.pp(self, ''.dup)
  end

  # prints arguments in pretty form.
  #
  # +#pp+ returns argument(s).
  def pp(*objs)
    objs.each {|obj|
      PP.pp(obj)
    }
    objs.size <= 1 ? objs.first : objs
  end
  module_function :pp
end
                                                                                                                                               