ion
    # named +symbol+.
    #
    # Raises a DLError if the handle is closed.
    def sym(symbol)
      @handlers.each{|handle|
        if( handle )
          begin
            addr = handle.sym(symbol)
            return addr
          rescue DLError
          end
        end
      }
      return nil
    end

    # See Fiddle::CompositeHandler.sym
    def [](symbol)
      sym(symbol)
    end
  end

  # A DSL that provides the means to dynamically load libraries and build
  # modules around them including calling extern functions within the C
  # library that has been loaded.
  #
  # == Example
  #
  #   require 'fiddle'
  #   require 'fiddle/import'
  #
  #   module LibSum
  #   	extend Fiddle::Importer
  #   	dlload './libsum.so'
  #   	extern 'double sum(double*, int)'
  #   	extern 'double split(double)'
  #   end
  #
  module Importer
    include Fiddle
    include CParser
    extend Importer

    attr_reader :type_alias
    private :type_alias

    # Creates an array of handlers for the given +libs+, can be an instance of
    # Fiddle::Handle, Fiddle::Importer, or will create a new instance of
    # Fiddle::Handle using Fiddle.dlopen
    #
    # Raises a DLError if the library cannot be loaded.
    #
    # See Fiddle.dlopen
    def dlload(*libs)
      handles = libs.collect{|lib|
        case lib
        when nil
          nil
        when Handle
          lib
        when Importer
          lib.handlers
        else
          Fiddle.dlopen(lib)
        end
      }.flatten()
      @handler = CompositeHandler.new(handles)
      @func_map = {}
      @type_alias = {}
    end

    # Sets the type alias for +alias_type+ as +orig_type+
    def typealias(alias_type, orig_type)
      @type_alias[alias_type] = orig_type
    end

    # Returns the sizeof +ty+, using Fiddle::Importer.parse_ctype to determine
    # the C type and the appropriate Fiddle constant.
    def sizeof(ty)
      case ty
      when String
        ty = parse_ctype(ty, type_alias).abs()
        case ty
        when TYPE_CHAR
          return SIZEOF_CHAR
    