 "    reg_cfp = ec->cfp;\n" # work on the new frame
    src << "    reg_cfp->pc = current_pc;\n"
    src << "    reg_cfp->sp = current_sp;\n"
    (0...body.stack_max).each do |i| # should be always `status->local_stack_p`
      src << "    *(vm_base_ptr(reg_cfp) + #{i}) = stack[#{i}];\n"
    end
    # We're not just returning Qundef here so that caller's normal cancel handler can
    # push back `stack` to `cfp->sp`.
    src << "    return vm_exec(ec, false);\n"
  end

  # Print the block to cancel JIT execution.
  def compile_cancel_handler(src, body, status)
    if status.inlined_iseqs.nil? # the current ISeq is being inlined
      compile_inlined_cancel_handler(src, body, status.inline_context)
      return
    end

    src << "\nsend_cancel:\n"
    src << "    rb_mjit_recompile_send(original_iseq);\n"
    src << "    goto cancel;\n"

    src << "\nivar_cancel:\n"
    src << "    rb_mjit_recompile_ivar(original_iseq);\n"
    src << "    goto cancel;\n"

    src << "\nexivar_cancel:\n"
    src << "    rb_mjit_recompile_exivar(original_iseq);\n"
    src << "    goto cancel;\n"

    src << "\nconst_cancel:\n"
    src << "    rb_mjit_recompile_const(original_iseq);\n"
    src << "    goto cancel;\n"

    src << "\ncancel:\n"
    if status.local_stack_p
      (0...body.stack_max).each do |i|
        src << "    *(vm_base_ptr(reg_cfp) + #{i}) = stack[#{i}];\n"
      end
    end
    src << "    return Qundef;\n"
  end

  def precompile_inlinable_child_iseq(src, child_iseq, status, ci, cc, pos)
    child_status = C.compile_status.new # not freed for now
    child_status.compiled_iseq = status.compiled_iseq
    child_status.compiled_id = status.compiled_id
    init_compile_status(child_status, child_iseq.body, false) # not freed for now
    child_status.inline_context.orig_argc = C.vm_ci_argc(ci)
    child_status.inline_context.me = vm_cc_cme(cc).to_i
    child_status.inline_context.param_size = child_iseq.body.param.size
    child_status.inline_context.local_size = child_iseq.body.local_table_size
    if child_iseq.body.ci_size > 0 && child_status.cc_entries_index == -1
      return false
    end

    src << "ALWAYS_INLINE(static VALUE _mjit#{status.compiled_id}_inlined_#{pos}(rb_execution_context_t *ec, rb_control_frame_t *reg_cfp, const VALUE orig_self, const rb_iseq_t *original_iseq));\n"
    src << "static inline VALUE\n_mjit#{status.compiled_id}_inlined_#{pos}(rb_execution_context_t *ec, rb_control_frame_t *reg_cfp, const VALUE orig_self, const rb_iseq_t *original_iseq)\n{\n"
    src << "    const VALUE *orig_pc = reg_cfp->pc;\n"
    src << "    VALUE *orig_sp = reg_cfp->sp;\n"

    success = compile_body(src, child_iseq, child_status)

    src << "\n} /* end of _mjit#{status.compiled_id}_inlined_#{pos} */\n\n"

    return success;
  end

  def precompile_inlinable_iseqs(src, iseq, status)
    body = iseq.body
    pos = 0
    while pos < body.iseq_size
      insn = INSNS.fetch(C.rb_vm_insn_decode(body.iseq_encoded[pos]))
      if insn.name == :opt_send_without_block || insn.name == :opt_size # `compile_inlined_cancel_handler` supports only `opt_send_without_block`
        cd = C.CALL_DATA.new(body.iseq_encoded[pos + 1])
        ci = cd.ci
        cc = captured_cc_entries(status)[call_data_index(cd, body)] # use copy to avoid race condition

        if (child_iseq = rb_mjit_inlinable_iseq(ci, cc)) != nil
          status.inlined_iseqs[pos] = child_iseq.body

          if C.mjit_opts.verbose >= 1 # print beforehand because ISeq may be GCed during copy job.
            child_location = child_iseq.body.location
            $stderr.puts "JIT inline: #{child_location.label}@#{C.rb_iseq_path(child_iseq)}:#{C.rb_iseq_first_lineno(child_iseq)} " \
              "=> #{iseq.body.location.label}@#{C.rb_iseq_path(iseq)}:#{C.rb_iseq_first_lineno(iseq)}"
          end
          if !precompile_inlinable_child_iseq(src, child_iseq, status, ci, cc, pos)
            return false
          end
        end
      end
      pos += insn.len
    end
    return true
  end

  def init_compile_status(status, body, compile_root_p)
    status.stack_size_for_pos = Fiddle.malloc(Fiddle::SIZEOF_INT * body.iseq_size)
    body.iseq_size.times do |i|
      status.stack_size_for_pos[i] = C.NOT_COMPILED_STACK_SIZE
    end
    if compile_root_p
      status.inlined_iseqs = Fiddle.malloc(Fiddle::SIZEOF_VOIDP * body.iseq_size)
      body.iseq_size.times do |i|
        status.inlined_iseqs[i] = nil
      end
    end
    if body.ci_size > 0
      status.cc_entries_index = C.mjit_capture_cc_entries(status.compiled_iseq, body)
    else
      status.cc_entries_index = -1
    end
    if compile_root_p
      status.compile_info = rb_mjit_iseq_compile_info(body)
    else
      status.compile_info = Fiddle.malloc(C.rb_mjit_compile_info.sizeof)
      status.compile_info.disable_ivar_cache = false
      status.compile_info.disable_exivar_cache = false
      status.compile_info.disable_send_cache = false
      status.compile_info.disable_inlining = false
      status.compile_info.disable_const_cache = false
    end
  end

  def using_ivar?(body)
    pos = 0
    while pos < body.iseq_size
      insn = INSNS.fetch(C.rb_vm_insn_decode(body.iseq_encoded[pos]))
      case insn.name
      when :getinstancevariable, :setinstancevariable
        return true
      end
      pos += insn.len
    end
    return false
  end

  # Expand simple macro that doesn't require dynamic C code.
  def expand_simple_macros(arg_expr)
    arg_expr.dup.tap do |expr|
      # For `leave`. We can't proceed next ISeq in the same JIT function.
      expr.gsub!(/^(?<indent>\s*)RESTORE_REGS\(\);\n/) do
        indent = Regexp.last_match[:indent]
        <<-end.gsub(/^ {12}/, '')
          #if OPT_CALL_THREADED_CODE
          #{indent}rb_ec_thread_ptr(ec)->retval = val;
          #{indent}return 0;
          #else
          #{indent}return val;
          #endif
        end
      end
      expr.gsub!(/^(?<indent>\s*)NEXT_INSN\(\);\n/) do
        indent = Regexp.last_match[:indent]
        <<-end.gsub(/^ {12}/, '')
          #{indent}UNREACHABLE_RETURN(Qundef);
        end
      end
    end
  end

  def to_cstr(expr)
    expr.gsub(/^(?!#)/, '    ') # indent everything but preprocessor lines
  end

  # Interpret unsigned long as signed long (VALUE -> OFFSET)
  def cast_offset(offset)
    if offset >= 1 << 8 * Fiddle::SIZEOF_VOIDP - 1 # negative
      offset -= 1 << 8 * Fiddle::SIZEOF_VOIDP
    end
    offset
  end

  def captured_cc_entries(status)
    status.compiled_iseq.mjit_unit.cc_entries + status.cc_entries_index
  end

  def call_data_index(cd, body)
    cd - body.call_data
  end

  def vm_cc_cme(cc)
    # TODO: add VM_ASSERT like actual vm_cc_cme
    cc.cme_
  end

  def def_iseq_ptr(method_def)
    C.rb_iseq_check(method_def.body.iseq.iseqptr)
  end

  def rb_mjit_iseq_compile_info(body)
    body.mjit_unit.compile_info
  end

  def ISEQ_IS_SIZE(body)
    body.ic_size + body.ivc_size + body.ise_size + body.icvarc_size
  end

  # Return true if an object of the class may be a special const (immediate).
  # It's "maybe" because Integer and Float are not guaranteed to be an immediate.
  # If this returns false, rb_class_of could be optimzied to RBASIC_CLASS.
  def maybe_special_const?(klass)
    [
      C.rb_cFalseClass,
      C.rb_cNilClass,
      C.rb_cTrueClass,
      C.rb_cInteger,
      C.rb_cSymbol,
      C.rb_cFloat,
    ].include?(klass)
  end

  def has_valid_method_type?(cc)
    vm_cc_cme(cc) != nil
  end

  def already_compiled?(status, pos)
    status.stack_size_for_pos[pos] != C.NOT_COMPILED_STACK_SIZE
  end

  # Return an iseq pointer if cc has inlinable iseq.
  def rb_mjit_inlinable_iseq(ci, cc)
    if has_valid_method_type?(cc) &&
        C.vm_ci_flag(ci) & C.VM_CALL_TAILCALL == 0 && # inlining only non-tailcall path
        vm_cc_cme(cc).def.type == C.VM_METHOD_TYPE_ISEQ &&
        C.fastpath_applied_iseq_p(ci, cc, iseq = def_iseq_ptr(vm_cc_cme(cc).def)) &&
        inlinable_iseq_p(iseq.body) # CC_SET_FASTPATH in vm_callee_setup_arg
      return iseq
    end
    return nil
  end

  # Return true if the ISeq can be inlined without pushing a new control frame.
  def inlinable_iseq_p(body)
    # 1) If catch_except_p, caller frame should be preserved when callee catches an exception.
    # Then we need to wrap `vm_exec()` but then we can't inline the call inside it.
    #
    # 2) If `body->catch_except_p` is false and `handles_                                                                                       ruby/ruby_vm/mjit/c_type.rb                                                                         0000644                 00000004766 15040313430 0011771 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       c`
      #   * Do not read any `cfp->pc`
      if insn.name == :invokebuiltin || insn.name == :opt_invokebuiltin_delegate || insn.name == :opt_invokebuiltin_delegate_leave
        # builtin insn's inlinability is handled by `Primitive.attr! 'inline'` per iseq
        if !body.builtin_inline_p
          return false;
        end
      elsif insn.name != :leave && C.insn_may_depend_on_sp_or_pc(insn.bin, body.iseq_encoded + (pos + 1))
        return false
      end
      # At this moment, `cfp->ep` in an inlined method is not working.
      case insn.name
      when :getlocal,
           :getlocal_WC_0,
           :getlocal_WC_1,
           :setlocal,
           :setlocal_WC_0,
           :setlocal_WC_1,
           :getblockparam,
           :getblockparamproxy,
           :setblockparam
        return false
      end
      pos += insn.len
    end
    return true
  end

  # CPointer::Struct could be nil on field reference, and this is a helper to
  # handle that case while using CPointer::Struct#to_s in most cases.
  # @param struct [RubyVM::MJIT::CPointer::Struct]
  def to_addr(struct)
    struct&.to_s || 'NULL'
  end

  def parent_shape_id(shape_id)
    return shape_id if shape_id == C.INVALID_SHAPE_ID

    parent_id = C.rb_shape_get_shape_by_id(shape_id).parent_id
    parent = C.rb_shape_get_shape_by_id(parent_id)

    if parent.type == C.SHAPE_CAPACITY_CHANGE
      parent.parent_id
    else
      parent_id
    end
  end
end
                                                                                       ruby/ruby_vm/mjit/c_type.rb                                                                         0000644                 00000004766 15040313430 0011771 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       require 'fiddle'
require 'fiddle/pack'
require_relative 'c_pointer'

module RubyVM::MJIT # :nodoc: all
  module CType
    module Struct
      # @param name [String]
      # @param members [Hash{ Symbol => [Integer, RubyVM::MJIT::CType::*] }]
      def self.new(name, sizeof, **members)
        name = members.keys.join('_') if name.empty?
        CPointer.with_class_name('Struct', name) do
          CPointer::Struct.define(sizeof, members)
        end
      end
    end

    module Union
      # @par          ruby/csv.rb                                                                                         0000644                 00000270742 15040313430 0006652 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       e_type.abs
        end&.to_s
        name.delete_prefix!('TYPE_')
        if fiddle_type.negative?
          name.prepend('U')
        end
        CPointer.with_class_name('Immediate', name, cache: true) do
          CPointer::Immediate.define(fiddle_type)
        end
      end

      # @param type [String]
      def self.parse(ctype)
        new(Fiddle::Importer.parse_ctype(ctype))
      end

      def self.find(size, signed)
        fiddle_type = TYPE_MAP.fetch(size)
        fiddle_type = -fiddle_type unless signed
        new(fiddle_type)
      end

      TYPE_MAP = Fiddle::PackInfo::SIZE_MAP.map { |type, size| [size, type.abs] }.to_h
      private_constant :TYPE_MAP
    end

    module Bool
      def self.new
        CPointer::Bool
      end
    end

    class Pointer
      # This takes a block to avoid "stack level too deep" on a cyclic reference
      # @param block [Proc]
      def self.new(&block)
        CPointer.with_class_name('Pointer', block.object_id.to_s) do
          CPointer::Pointer.define(block)
        end
      end
    end

    module BitField
      # @param width [Integer]
      # @param offset [Integer]
      def self.new(width, offset)
        CPointer.with_class_name('BitField', "#{offset}_#{width}") do
          CPointer::BitField.define(width, offset)
        end
      end
    end

    # Types that are referenced but not part of code generation targets
    Stub = ::Struct.new(:name)

    # Types that it failed to figure out from the header
    Unknown = Module.new
  end
end
          ruby/csv.rb                                                                                         0000644                 00000270742 15040313430 0006652 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # encoding: US-ASCII
# frozen_string_literal: true
# = csv.rb -- CSV Reading and Writing
#
# Created by James Edward Gray II on 2005-10-31.
#
# See CSV for documentation.
#
# == Description
#
# Welcome to the new and improved CSV.
#
# This version of the CSV library began its life as FasterCSV. FasterCSV was
# intended as a replacement to Ruby's then standard CSV library. It was
# designed to address concerns users of that library had and it had three
# primary goals:
#
# 1.  Be significantly faster than CSV while remaining a pure Ruby library.
# 2.  Use a smaller and easier to maintain code base. (FasterCSV eventually
#     grew larger, was also but considerably richer in features. The parsing
#     core remains quite small.)
# 3.  Improve on the CSV interface.
#
# Obviously, the last one is subjective. I did try to defer to the original
# interface whenever I didn't have a compelling reason to change it though, so
# hopefully this won't be too radically different.
#
# We must have met our goals because FasterCSV was renamed to CSV and replaced
# the original library as of Ruby 1.9. If you are migrating code from 1.8 or
# earlier, you may have to change your code to comply with the new interface.
#
# == What's the Different From the Old CSV?
#
# I'm sure I'll miss something, but I'll try to mention most of the major
# differences I am aware of, to help others quickly get up to speed:
#
# === \CSV Parsing
#
# * This parser is m17n aware. See CSV for full details.
# * This library has a stricter parser and will throw MalformedCSVErrors on
#   problematic data.
# * This library has a less liberal idea of a line ending than CSV. What you
#   set as the <tt>:row_sep</tt> is law. It can auto-detect your line endings
#   though.
# * The old library returned empty lines as <tt>[nil]</tt>. This library calls
#   them <tt>[]</tt>.
# * This library has a much faster parser.
#
# === Interface
#
# * CSV now uses keyword parameters to set options.
# * CSV no longer has generate_row() or parse_row().
# * The old CSV's Reader and Writer classes have been dropped.
# * CSV::open() is now more like Ruby's open().
# * CSV objects now support most standard IO methods.
# * CSV now has a new() method used to wrap objects like String and IO for
#   reading and writing.
# * CSV::generate() is different from the old method.
# * CSV no longer supports partial reads. It works line-by-line.
# * CSV no longer allows the instance methods to override the separators for
#   performance reasons. They must be set in the constructor.
#
# If you use this library and find yourself missing any functionality I have
# trimmed, please {let me know}[mailto:james@grayproductions.net].
#
# == Documentation
#
# See CSV for documentation.
#
# == What is CSV, really?
#
# CSV maintains a pretty strict definition of CSV taken directly from
# {the RFC}[http://www.ietf.org/rfc/rfc4180.txt]. I relax the rules in only one
# place and that is to make using this library easier. CSV will parse all valid
# CSV.
#
# What you don't want to do is to feed CSV invalid data. Because of the way the
# CSV format works, it's common for a parser to need to read until the end of
# the file to be sure a field is invalid. This consumes a lot of time and memory.
#
# Luckily, when working with invalid CSV, Ruby's built-in methods will almost
# always be superior in every way. For example, parsing non-quoted fields is as
# easy as:
#
#   data.split(",")
#
# == Questions and/or Comments
#
# Feel free to email