ruby/reline/kill_ring.rb                                                                            0000644                 00000004575 15040313433 0011311 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       class Reline::KillRing
  include Enumerable

  module State
    FRESH = :fresh
    CONTINUED = :continued
    PROCESSED = :processed
    YANK = :yank
  end

  RingPoint = Struct.new(:backward, :forward, :str) do
    def initialize(str)
      super(nil, nil, str)
    end

    def ==(other)
      equal?(other)
    end
  end

  class RingBuffer
    attr_reader :size
    attr_reader :head

    def initialize(max = 1024)
      @max = max
      @size = 0
      @head = nil # reading head of ring-shaped tape
    end

    def <<(point)
      if @size.zero?
        @head = point
        @head.backward = @head
        @head.forward = @head
        @size = 1
      elsif @size >= @max
        tail = @head.forward
        new_tail = tail.forward
        @head.forward = point
        point.backward = @head
        new_tail.backward = point
        point.forward = new_tail
        @head = point
      else
        tail = @head.forward
        @head.forward = point
        point.backward = @head
        tail.backward = point
        point.forward = tail
        @head = point
        @size += 1
      end
    end

    def empty?
      @size.zero?
    end
  end

  def initialize(max = 1024)
    @ring = RingBuffer.new(max)
    @ring_pointer = nil
    @buffer = nil
    @state = State::FRESH
  end

  def append(string, before_p = false)
    case @state
    when State::FRESH, State::YANK
      @ring << RingPoint.new(+string)
      @state = State::CONTINUED
    when State::CONTINUED, State::PROCESSED
      if before_p
        @ring.head.str.prepend(string)
      else
        @ring.head.str.concat(string)
      end
      @state = State::CONTINUED
    end
  end

  def process
    case @state
    when State::FRESH
      # nothing to do
    when State::CONTINUED
      @state = State::PROCESSED
    when State::PROCESSED
      @state = State::FRESH
    when State::YANK
      # nothing to do
    end
  end

  def yank
    unless @ring.empty?
      @state = State::YANK
      @ring_pointer = @ring.head
      @ring_pointer.str
    else
      nil
    end
  end

  def yank_pop
    if @state == State::YANK
      prev_yank = @ring_pointer.str
      @ring_pointer = @ring_pointer.backward
      [@ring_pointer.str, prev_yank]
    else
      nil
    end
  end

  def each
    start = head = @ring.head
    loop do
      break if head.nil?
      yield head.str
      head = head.backward
      break if head == start
    end
  end
end
                                                                                                                                   ruby/reline/ansi.rb                                                                                 0000644                 00000022210 15040313433 0010253 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       /win32.h (rb_w32_fd_is_text): new function.

	* win32/win32.c (init_stdhandle): set default mode of stdin as binmode.

	* io.c (set_binary_mode_with_seek_cur): new function to replace
	  SET_BINARY_MODE_WITH_SEEK_CUR macro.  now returns previous mode of the
	  fd and take care of LF in rbuf.

	* io.c (do_writeconv): set text mode when needed.

	* io.c (io_read): need to change the mode of the IO to binmode
	  temporally when the length for IO#read, because IO#read with length
	  must behave so.

	* test/ruby/test_io_m17n.rb (TestIO_M17N#test_{read_with_length,
	  read_with_length_binmode,get[cs]_and_read_with_binmode,
	  read_with_binmode_and_get[cs],read_write_with_binmode}): tests for
	  above changes.

	all patches are written by Hiroshi Shirosaki. [ruby-core:41496]
	[Feature #5714]

Sat Feb 11 03:37:56 2012  NAKAMURA Usaku  <usa@ruby-lang.org>

	* test/rexml/test_order.rb (OrderTester#test_more_ordering): use
	  GZip::GzReader.open instead of GZip::GzReader.new with File.new.
	  fixed a test error on Windows introduced at r33946.

Sat Feb 11 03:37:34 2012  NAKAMURA Usaku  <usa@ruby-lang.org>

	* ext/zlib/zlib.c (rb_gzreader_initialize): revert a part of r33937.
	  1st, to change the mode of an IO is very sensitive problem, so
	  fixed test errors on Windows introduced at r33953.
	  the maintainer of this library should judge it.
	  2nd, usually Zlib::GzReader.new is not called directly.  #initialize
	  is called via .open, and in the method the I/O is opened in binary
	  mode, so there is no problem without changing the mode in #initialize.

	  fixed test errors on Windows introduced at r33947.
Sat Feb 11 03:23:58 2012  Luis Lavena  <luislavena@gmail.com>

	* ext/zlib/zlib.c (rb_gzreader_initialize): use binary mode by default
	  under Windows. Patch by Hiroshi Shirosaki. [ruby-core:40706]
	  [Feature #5562]

	* include/ruby/encoding.h (void rb_econv_binmode): define NEWLINE
	  decorator.

	* io.c (rb_cloexec_fcntl_dupfd): Introduce NEED_READCONV and
	  NEED_WRITECONV to replace universal newline decorator by CRLF only
	  when required to improve file reading and writing under Windows.
	  Patch by Hiroshi Shirosaki. [ruby-core:40706] [Feature #5562]
	* io.c (do_writeconv): adjust binary mode if required.
	* io.c (read_all, appendline, swallow, rb_io_getline_1): ditto.
	* io.c (io_getc, rb_io_each_codepoint, rb_io_ungetc): ditto.
	* io.c (rb_io_binmode, rb_io_ascii8bit_binmode): ditto.
	* io.c (rb_io_extract_modeenc, rb_sysopen): ditto.
	* io.c (pipe_open, prep_stdio, io_encoding_set): ditto.
	* io.c (rb_io_s_pipe, copy_stream_body): ditto.

	* test/ruby/test_io_m17n.rb (EOT): add test for pipe and stdin in
	  binary mode.

	* win32/win32.c (init_stdhandle): remove O_BINARY from stdhandle
	  initialization.
	* win32/win32.c (rb_w32_write): use FTEXT mode accordingly.

Sat Feb 11 03:20:22 2012  NAKAMURA Usaku  <usa@ruby-lang.org>

	* io.c (argf_next_argv): wrong timing of setting ecflags.
	  fixed the failure of TestArgf#test_textmode introduced at r33662.

Sat Feb 11 03:19:45 2012  NAKAMURA Usaku  <usa@ruby-lang.org>

	* test/ruby/test_io_m17n.rb
	  (TestIO_M17N#test_default_stdout_stderr_mode): new test for
	  r33627-33629.  see [backport #5565]
Sat Feb 11 03:20:22 2012  NAKAMURA Usaku  <usa@ruby-lang.org>

	* include/ruby/encoding.h (ECONV_NEWLINE_DECORATOR_READ_MASK,
	  ECONV_NEWLINE_DECORATOR_WRITE_MASK): new macro.

	* io.c (rb_io_extract_modeenc, pipe_open, prep_stdio, argf_next_argv):
	  set TEXTMODE_NEWLINE_DECORATOR_ON_WRITE for textmode on creating IO
	  if the flag is available.

	* io.c (make_writeconv): drop decorators for reading.

	* io.c (make_readconv): drop decorators for writing.

	* io.c (do_writeconv): existing writeconv is not the condition to raise
	  ArgumentError.  should check textmode or not.

	* test/ruby/test_io_m17n.rb
	  (TestIO_M17N#test_{cr,lf,crlf}_decorator_on_stdout): test above
	  changes.


Sat Feb 11 03:19:45 2012  NAKAMURA Usaku  <usa@ruby-lang.org>

	* test/ruby/test_io_m17n.rb (TestIO_M17N#test_{default_mode_on_dosish,
	  default_mode_on_unix,text_mode,binary_mode}): sorry for wrong test
	  committed in r33144.  I'd misunderstood the spec of ruby's universal
	  newline.

Sat Feb 11 03:17:41 2012  NAKAMURA Usaku  <usa@ruby-lang.org>

	* test/ruby/test_io_m17n.rb (TestIO_M17N#test_{default_mode_on_dosish,
	  default_mode_on_unix,text_mode,binary_mode}): tests for [Bug #5164].

Sat Feb 11 03:13:27 2012  Nobuyoshi Nakada  <nobu@ruby-lang.org>

	* transcode.c: enabled econv newline option.

Sat Feb 11 02:39:09 2012  CHIKANAGA Tomoyuki  <nagachika00@gmail.com>

	* variable.c (set_const_visibility): clear inine-cache when constant's
	  visibility is modified. [ruby-dev:44929]

	* test/ruby/test_module.rb (test_private_constants_clear_inlinecache):
	  add test for it.

Sat Feb 11 02:39:09 2012  Yusuke Endoh  <mame@tsg.ne.jp>

	* variable.c (set_const_visibility): print a warning when no argument
	  is passwd to Module#private_constant.  [ruby-list:48558]

	* vm_method.c (set_method_visibility): ditto for
	  Module#private_class_method.

Sat Feb 11 02:39:09 2012  Yusuke Endoh  <mame@tsg.ne.jp>

	* variable.c (set_const_visibility): Module#private_constant has
	  changed the visibility of only the first argument.  Now it changes
	  all of them.  [ruby-list:48558]

	* test/ruby/test_module.rb: add a test for above.

Sat Feb 11 02:39:09 2012  CHIKANAGA Tomoyuki  <nagachika00@gmail.com>

	* variable.c (set_const_visibility): clear inine-cache when constant's
	  visibility is modified. [ruby-dev:44929]

	* test/ruby/test_module.rb (test_private_constants_clear_inlinecache):
	  add test for it.

Sat Feb 11 02:39:09 2012  Yusuke Endoh  <mame@tsg.ne.jp>

	* variable.c (set_const_visibility): print a warning when no argument
	  is passwd to Module#private_constant.  [ruby-list:48558]

	* vm_method.c (set_method_visibility): ditto for
	  Module#private_class_method.

Sat Feb 11 02:39:09 2012  Yusuke Endoh  <mame@tsg.ne.jp>

	* variable.c (set_const_visibility): Module#private_constant has
	  changed the visibility of only the first argument.  Now it changes
	  all of them.  [ruby-list:48558]

	* test/ruby/test_module.rb: add a test for above.

Sat Feb 11 02:26:51 2012  Martin Bosslet  <Martin.Bosslet@googlemail.com>

	* lib/openssl/buffering.rb: Force multi-byte strings to be treated as
	  binary data.
	* test/openssl/test_ssl.rb: Add test for it.

	Thanks to Niklas Baumstark for reporting the issue!

	[Ruby 1.9 - Bug #5233] [ruby-core:39120]

Fri Feb 10 17:25:28 2012  Tanaka Akira  <akr@fsij.org>

	* lib/set.rb (SortedSet.setup): remove old_init after initialize
	  method is redefined.  The remove before redefinition makes the
	  warning prevention fragile.  [ruby-dev:44892]

Fri Feb 10 17:02:12 2012  okkez  <okkez000@gmail.com>

	* thread_pthread.c (rb_thread_create_timer_thread): fix memory
	  leak. [ruby-dev:44904] [Bug #5688]

Fri Feb 10 05:22:32 2012  NARUSE, Yui  <naruse@ruby-lang.org>

	* cont.c (fiber_setcontext): Use longjmp() instead of swapcontext() on
	  FreeBSD 9. [ruby-dev:41316] [Bug #3295] [Bug #5526]

Fri Feb 10 05:13:12 2012  Ayumu AIZAWA  <ayumu.aizawa@gmail.com>

	* object.c: Added examples for Object#is_a? and
	  Object#instance_of? patcheed from Manoj Kumar.
	  [Bug #5880] [ruby-core:42057]

Fri Feb 10 05:11:43 2012  NARUSE, Yui  <naruse@ruby-lang.org>

	* io.c (argf_next_argv): reset ARGF.next_p on ARGV.replace.
	  r34409 breaks replacing ARGV.
	  [ruby-dev:45160] [Bug #5952]

Fri Feb 10 05:11:43 2012  Nobuyoshi Nakada  <nobu@ruby-lang.org>

	* io.c (argf_close): skip stdin, which should be readable again.
	  [ruby-dev:45160] [Bug #5952]

	* io.c (argf_readlines): reinitialize after all read to be
	  readable again.

Fri Feb  9 01:36:19 2012  Martin Bosslet  <Martin.Bosslet@googlemail.com>

	* backport r34482 from trunk

	* ext/openssl/ossl_ssl.c: Add SSL constants and allow to unset SSL
	  option to prevent BEAST attack. See [Bug #5353].

	  In OpenSSL, OP_DONT_INSERT_EMPTY_FRAGMENTS is used to prevent
	  TLS-CBC-IV vulunerability described at
	  http://www.openssl.org/~bodo/tls-cbc.txt
	  It's known issue of TLSv1/SSLv3 but it attracts lots of attention
	  these days as BEAST attack. (CVE-2011-3389)

	  Until now ossl sets OP_ALL at SSLContext allocation and call
	  SSL_CTX_set_options at connection.  SSL_CTX_set_options updates the
	  value by using |= so bits set by OP_ALL cannot be unset afterwards.
	  This commit changes to call SSL_CTX_set_options only 1 time for each
	  SSLContext. It sets the specified value if SSLContext#options= are
	  called and sets OP_ALL if not.

	  To help users to unset bits in OP_ALL, this commit also adds several
	  constant to SSL such as
	  OpenSSL::SSL::OP_DONT_INSERT_EMPTY_FRAGMENTS.  These constants were
	  not exposed in Ruby because there's no way to unset bits in OP_ALL
	  before.

	  Following is an example to enable 0/n split for BEAST prevention.

	    ctx.options = OP_ALL & ~OP_DONT_INSERT_EMPTY_FRAGMENTS

	* test/openssl/test_ssl.rb: Test above option exists.

Thu Feb  9 17:08:20 2012  CHIKANAGA Tomoyuki  <nagachika00@gmail.com>

	* cont.c (cont_mark): mark original Thread object from saved_thread.
	  [ruby-dev:44567] [Bug #5386]

Thu Feb  9 17:05:07 2012  NARUSE, Yui  <naruse@ruby-lang.org>

	* cont.c (HAVE_GETCONTEXT): see getcontext(3) because DragonFly BSD
	  x64 port does                                                                                                                                                                                                                                                                                                                                                                                        ruby/reline/config.rb                                                                               0000644                 00000024242 15040313433 0010575 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       class Reline::Config
  attr_reader :test_mode

  KEYSEQ_PATTERN = /\\(?:C|Control)-[A-Za-z_]|\\(?:M|Meta)-[0-9A-Za-z_]|\\(?:C|Control)-\\(?:M|Meta)-[A-Za-z_]|\\(?:M|Meta)-\\(?:C|Control)-[A-Za-z_]|\\e|\\[\\\"\'abdfnrtv]|\\\d{1,3}|\\x\h{1,2}|./

  class InvalidInputrc < RuntimeError
    attr_accessor :file, :lineno
  end

  VARIABLE_NAMES = %w{
    completion-ignore-case
    convert-meta
    disable-completion
    history-size
    keyseq-timeout
    show-all-if-ambiguous
    show-mode-in-prompt
    vi-cmd-mode-string
    vi-ins-mode-string
    emacs-mode-string
    enable-bracketed-paste
    isearch-terminators
  }
  VARIABLE_NAME_SYMBOLS = VARIABLE_NAMES.map { |v| :"#{v.tr(?-, ?_)}" }
  VARIABLE_NAME_SYMBOLS.each do |v|
    attr_accessor v
  end

  attr_accessor :autocompletion

  def initialize
    reset_variables
  end

  def reset
    if editing_mode_is?(:vi_command)
      @editing_mode_label = :vi_insert
    end
    @oneshot_key_bindings.clear
  end

  def reset_variables
    @additional_key_bindings = { # from inputrc
      emacs: Reline::KeyActor::Base.new,
      vi_insert: Reline::KeyActor::Base.new,
      vi_command: Reline::KeyActor::Base.new
    }
    @oneshot_key_bindings = Reline::KeyActor::Base.new
    @editing_mode_label = :emacs
    @keymap_label = :emacs
    @keymap_prefix = []
    @default_key_bindings = {
      emacs: Reline::KeyActor::Base.new(Reline::KeyActor::EMACS_MAPPING),
      vi_insert: Reline::KeyActor::Base.new(Reline::KeyActor::VI_INSERT_MAPPING),
      vi_command: Reline::KeyActor::Base.new(Reline::KeyActor::VI_COMMAND_MAPPING)
    }
    @vi_cmd_mode_string = '(cmd)'
    @vi_ins_mode_string = '(ins)'
    @emacs_mode_string = '@'
    # https://tiswww.case.edu/php/chet/readline/readline.html#IDX25
    @history_size = -1 # unlimited
    @keyseq_timeout = 500
    @test_mode = false
    @autocompletion = false
    @convert_meta = seven_bit_encoding?(Reline::IOGate.encoding)
    @loaded = false
    @enable_bracketed_paste = true
    @show_mode_in_prompt = false
    @default_inputrc_path = nil
  end

  def editing_mode
    @default_key_bindings[@editing_mode_label]
  end

  def editing_mode=(val)
    @editing_mode_label = val
  end

  def editing_mode_is?(*val)
    val.any?(@editing_mode_label)
  end

  def keymap
    @default_key_bindings[@keymap_label]
  end

  def loaded?
    @loaded
  end

  def inputrc_path
    case ENV['INPUTRC']
    when nil, ''
    else
      return File.expand_path(ENV['INPUTRC'])
    end

    # In the XDG Specification, if ~/.config/readline/inputrc exists, then
    # ~/.inputrc should not be read, but for compatibility with GNU Readline,
    # if ~/.inputrc exists, then it is given priority.
    home_rc_path = File.expand_path('~/.inputrc')
    return home_rc_path if File.exist?(home_rc_path)

    case path = ENV['XDG_CONFIG_HOME']
    when nil, ''
    else
      path = File.join(path, 'readline/inputrc')
      return path if File.exist?(path) and path == File.expand_path(path)
    end

    path = File.expand_path('~/.config/readline/inputrc')
    return path if File.exist?(path)

    return home_rc_path
  end

  private def default_inputrc_path
    @default_inputrc_path ||= inputrc_path
  end

  def read(file = nil)
    @loaded = true
    file ||= default_inputrc_path
    begin
      if file.respond_to?(:readlines)
        lines = file.readlines
      else
        lines = File.readlines(file)
      end
    rescue Errno::ENOENT
      return nil
    end

    read_lines(lines, file)
    self
  rescue InvalidInputrc => e
    warn e.message
    nil
  end

  def key_bindings
    # The key bindings for each editing mode will be overwritten by the user-defined ones.
    Reline::KeyActor::Composite.new([@oneshot_key_bindings, @additional_key_bindings[@editing_mode_label], @default_key_bindings[@editing_mode_label]])
  end

  def add_oneshot_key_binding(keystroke, target)
    # IRB sets invalid keystroke [Reline::Key]. We should ignore it.
    return unless keystroke.all? { |c| c.is_a?(Integer) }

    @oneshot_key_bindings.add(keystroke, target)
  end

  def reset_oneshot_key_bindings
    @oneshot_key_bindings.clear
  end

  def add_default_key_binding_by_keymap(keymap, keystroke, target)
    @default_key_bindings[keymap].add(keystroke, target)
  end

  def add_default_key_binding(keystroke, target)
    add_default_key_binding_by_keymap(@keymap_label, keystroke, target)
  end

  def read_lines(lines, file = nil)
    if not lines.empty? and lines.first.encoding != Reline.encoding_system_needs
      begin
        lines = lines.map do |l|
          l.encode(Reline.encoding_system_needs)
        rescue Encoding::UndefinedConversionError
          mes = "The inputrc encoded in #{lines.first.encoding.name} can't be converted to the locale #{Reline.encoding_system_needs.name}."
          raise Reline::ConfigEncodingConversionError.new(mes)
        end
      end
    end
    if_stack = []

    lines.each_with_index do |line, no|
      next if line.match(/\A\s*#/)

      no += 1

      line = line.chomp.lstrip
      if line.start_with?('$')
        handle_directive(line[1..-1], file, no, if_stack)
        next
      end

      next if if_stack.any? { |_no, skip| skip }

      case line
      when /^set +([^ ]+) +(.+)/i
        # value ignores everything after a space, raw_value does not.
        var, value, raw_value = $1.downcase, $2.partition(' ').first, $2
        bind_variable(var, value, raw_value)
      when /^\s*(?:M|Meta)-([a-zA-Z_])\s*:\s*(.*)\s*$/o
        bind_key("\"\\M-#$1\"", $2)
      when /^\s*(?:C|Control)-([a-zA-Z_])\s*:\s*(.*)\s*$/o
        bind_key("\"\\C-#$1\"", $2)
      when /^\s*(?:(?:C|Control)-(?:M|Meta)|(?:M|Meta)-(?:C|Control))-([a-zA-Z_])\s*:\s*(.*)\s*$/o
        bind_key("\"\\M-\\C-#$1\"", $2)
      when /^\s*("#{KEYSEQ_PATTERN}+")\s*:\s*(.*)\s*$/o
        bind_key($1, $2)
      end
    end
    unless if_stack.empty?
      raise InvalidInputrc, "#{file}:#{if_stack.last[0]}: unclosed if"
    end
  end

  def handle_directive(directive, file, no, if_stack)
    directive, args = directive.split(' ')
    case directive
    when 'if'
      condition = false
      case args
      when /^mode=(vi|emacs)$/i
        mode = $1.downcase
        # NOTE: mode=vi means vi-insert mode
        mode = 'vi_insert' if mode == 'vi'
        if @editing_mode_label == mode.to_sym
          condition = true
        end
      when 'term'
      when 'version'
      else # application name
        condition = true if args == 'Ruby'
        condition = true if args == 'Reline'
      end
      if_stack << [no, !condition]
    when 'else'
      if if_stack.empty?
        raise InvalidInputrc, "#{file}:#{no}: unmatched else"
      end
      if_stack.last[1] = !if_stack.last[1]
    when 'endif'
      if if_stack.empty?
        raise InvalidInputrc, "#{file}:#{no}: unmatched endif"
      end
      if_stack.pop
    when 'include'
      read(File.expand_path(args))
    end
  end

  def bind_variable(name, value, raw_value)
    case name
    when 'history-size'
      begin
        @history_size = Integer(value)
      rescue ArgumentError
        @history_size = 500
      end
    when 'isearch-terminators'
      @isearch_terminators = retrieve_string(raw_value)
    when 'editing-mode'
      case value
      when 'emacs'
        @editing_mode_label = :emacs
        @keymap_label = :emacs
        @keymap_prefix = []
      when 'vi'
        @editing_mode_label = :vi_insert
        @keymap_label = :vi_insert
        @keymap_prefix = []
      end
    when 'keymap'
      case value
      when 'emacs', 'emacs-standard'
        @keymap_label = :emacs
        @keymap_prefix = []
      when 'emacs-ctlx'
        @keymap_label = :emacs
        @keymap_prefix = [?\C-x.ord]
      when 'emacs-meta'
        @keymap_label = :emacs
        @keymap_prefix = [?\e.ord]
      when 'vi', 'vi-move', 'vi-command'
        @keymap_label = :vi_command
        @keymap_prefix = []
      when 'vi-insert'
        @keymap_label = :vi_insert
        @keymap_prefix = []
      end
    when 'keyseq-timeout'
      @keyseq_timeout = value.to_i
    when 'show-mode-in-prompt'
      case value
      when 'off'
        @show_mode_in_prompt = false
      when 'on'
        @show_mode_in_prompt = true
      else
        @show_mode_in_prompt = false
      end
    when 'vi-cmd-mode-string'
      @vi_cmd_mode_string = retrieve_string(raw_value)
    when 'vi-ins-mode-string'
      @vi_ins_mode_string = retrieve_string(raw_value)
    when 'emacs-mode-string'
      @emacs_mode_string = retrieve_string(raw_value)
    when *VARIABLE_NAMES then
      variable_name = :"@#{name.tr(?-, ?_)}"
      instance_variable_set(variable_name, value.nil? || value == '1' || value == 'on')
    end
  end

  def retrieve_string(str)
    str = $1 if str =~ /\A"(.*)"\z/
    parse_keyseq(str).map { |c| c.chr(Reline.encoding_system_needs) }.join
  end

  def bind_key