A utility method for encoding the String _s_ as a URL.
  #
  #   require "erb"
  #   include ERB::Util
  #
  #   puts url_encode("Programming Ruby:  The Pragmatic Programmer's Guide")
  #
  # _Generates_
  #
  #   Programming%20Ruby%3A%20%20The%20Pragmatic%20Programmer%27s%20Guide
  #
  def url_encode(s)
    CGI.escapeURIComponent(s.to_s)
  end
  alias u url_encode
  module_function :u
  module_function :url_encode
end
                                                                                         ruby/erb/def_method.rb                                                                              0000644                 00000001725 15040313432 0010720 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
#--
# ERB::DefMethod
#
# Utility module to define eRuby script as instance method.
#
# === Example
#
# example.rhtml:
#   <% for item in @items %>
#   <b><%= item %></b>
#   <% end %>
#
# example.rb:
#   require 'erb'
#   class MyClass
#     extend ERB::DefMethod
#     def_erb_method('render()', 'example.rhtml')
#     def initialize(items)
#       @items = items
#     end
#   end
#   print MyClass.new([10,20,30]).render()
#
# result:
#
#   <b>10</b>
#
#   <b>20</b>
#
#   <b>30</b>
#
module ERB::DefMethod
  # define _methodname_ as instance method of current module, using ERB
  # object or eRuby file
  def def_erb_method(methodname, erb_or_fname)
    if erb_or_fname.kind_of? String
      fname = erb_or_fname
      erb = ERB.new(File.read(fname))
      erb.def_method(self, methodname, fname)
    else
      erb = erb_or_fname
      erb.def_method(self