  [:to_s, :inspect, :!~, :===, :<=>, :hash].each do |m|
      undef_method m
    end
    private_instance_methods.each do |m|
      if /\Ablock_given\?\z|\Aiterator\?\z|\A__.*__\z/ =~ m
        next
      end
      undef_method m
    end
  end
  include kernel

  # :stopdoc:
  def self.const_missing(n)
    ::Object.const_get(n)
  end
  # :startdoc:

  ##
  # :method: raise
  # Use #__raise__ if your Delegator does not have a object to delegate the
  # #raise method call.
  #

  #
  # Pass in the _obj_ to delegate method calls to.  All methods supported by
  # _obj_ will be delegated to.
  #
  def initialize(obj)
    __setobj__(obj)
  end

  #
  # Handles the magic of delegation through \_\_getobj\_\_.
  #
  ruby2_keywords def method_missing(m, *args, &block)
    r = true
    target = self.__getobj__ {r = false}

    if r && target_respond_to?(target, m, false)
      target.__send__(m, *args, &block)
    elsif ::Kernel.method_defined?(m) || ::Kernel.private_method_defined?(m)
      ::Kernel.instance_method(m).bind_call(self, *args, &block)
    else
      super(m, *args, &block)
    end
  end

  #
  # Checks for a method provided by this the delegate object by forwarding the
  # call through \_\_getobj\_\_.
  #
  def respond_to_missing?(m, include_private)
    r = true
    target = self.__getobj__ {r = false}
    r &&= target_respond_to?(target, m, include_private)
    if r && include_private && !target_respond_to?(target, m, false)
      warn "delegator does not forward private method \##{m}", uplevel: 3
      return false
    end
    r
  end

  KERNEL_RESPOND_TO = ::Kernel.instance_method(:respond_to?)
  private_constant :KERNEL_RESPOND_TO

  # Handle BasicObject instances
  private def target_respond_to?(target, m, include_private)
    case target
    when Object
      target.respond_to?(m, include_private)
    else
      if KERNEL_RESPOND_TO.bind_call(target, :respond_to?)
        target.respond_to?(m, include_private)
      else
        KERNEL_RESPOND_TO.bind_call(target, m, include_private)
      end
    end
  end

  #
  # Returns the methods available to this delegate object as the union
  # of this object's and \_\_getobj\_\_ methods.
  #
  def methods(all=true)
    __getobj__.methods(all) | super
  end

  #
  # Returns the methods available to this delegate object as the union
  # of this object's and \_\_getobj\_\_ public methods.
  #
  def public_methods(all=true)
    __getobj__.public_methods(all) | super
  end

  #
  # Returns the methods available to this delegate object as the union
  # of this object's and \_\_getobj\_\_ protected methods.
  #
  def protecte