nes.join("\n") unless eof?
  end

  def current_line
    @buffer_of_lines[@line_index]
  end

  def set_current_line(line, byte_pointer = nil)
    cursor = current_byte_pointer_cursor
    @buffer_of_lines[@line_index] = line
    if byte_pointer
      @byte_pointer = byte_pointer
    else
      calculate_nearest_cursor(cursor)
    end
    process_auto_indent
  end

  def retrieve_completion_block
    quote_characters = Reline.completer_quote_characters
    before = current_line.byteslice(0, @byte_pointer).grapheme_clusters
    quote = nil
    # Calcualte closing quote when cursor is at the end of the line
    if current_line.bytesize == @byte_pointer && !quote_characters.empty?
      escaped = false
      before.each do |c|
        if escaped
          escaped = false
          next
        elsif c == '\\'
          escaped = true
        elsif quote
          quote = nil if c == quote
        elsif quote_characters.include?(c)
          quote = c
        end
      end
    end

    word_break_characters = quote_characters + Reline.completer_word_break_characters
    break_index = before.rindex { |c| word_break_characters.include?(c) || quote_characters.include?(c) } || -1
    preposing = before.take(break_index + 1).join
    target = before.drop(break_index + 1).join
    postposing = current_line.byteslice(@byte_pointer, current_line.bytesize - @byte_pointer)
    lines = whole_lines
    if @line_index > 0
      preposing = lines[0..(@line_index - 1)].join("\n") + "\n" + preposing
    end
    if (lines.size - 1) > @line_index
      postposing = postposing + "\n" + lines[(@line_index + 1)..-1].join("\n")
    end
    [preposing.encode(encoding), target.encode(encoding), postposing.encode(encoding), quote&.encode(encoding)]
  end

  def confirm_multiline_termination
    temp_buffer = @buffer_of_lines.dup
    @confirm_multiline_termination_proc.(temp_buffer.join("\n") + "\n")
  end

  def insert_multiline_text(text)
    pre = @buffer_of_lines[@line_index].byteslice(0, @byte_pointer)
    post = @buffer_of_lines[@line_index].byteslice(@byte_pointer..)
    lines = (pre + Reline::Unicode.safe_encode(text, encoding).gsub(/\r\n?/, "\n") + post).split("\n", -1)
    lines << '' if lines.empty?
    @buffer_of_lines[@line_index, 1] = lines
    @line_index += lines.size - 1
    @byte_pointer = @buffer_of_lines[@line_index].bytesize - post.bytesize
  end

  def insert_text(text)
    if @buffer_of_lines[@line_index].by