d_object
    end

    def self.extended(c)
      # extending an object with Singleton is a bad idea
      c.singleton_class.send(:undef_method, :extend_object)
    end

    def __init__(klass) # :nodoc:
      klass.instance_eval {
        set_instance(nil)
        set_mutex(Thread::Mutex.new)
      }
      klass
    end

    private

    def append_features(mod)
      #  help out people counting on transitive mixins
      unless mod.instance_of?(Class)
        raise TypeError, "Inclusion of the OO-Singleton module in module #{mod}"
      end
      super
    end

    def included(klass)
      super
      klass.private_class_method :new, :allocate
      klass.extend module_with_class_methods
      Singleton.__init__(klass)
    end
  end
  extend SingletonClassProperties

  ##
  # :singleton-method: _load
  #  By default calls instance(). Override to retain singleton state.

  ##
  # :singleton-method: instance
  #  Returns the singleton instance.
end

if defined?(Ractor)
  module RactorLocalSingleton
    include Singleton::SingletonInstanceMethods

    module RactorLocalSingletonClassMethods
      include Singleton::SingletonClassMethods
      def instance
        set_mutex(Thread::Mutex.new) if Ractor.current[mutex_key].nil?
        return Ractor.current[instance_key] if Ractor.current[instance_key]
        Ractor.current[mutex_key].synchronize {
          return Ractor.current[instance_key] if Ractor.current[instance_key]
          set_instance(new())
        }
        Ractor.current[instance_key]
      end

      private

      def instance_key
        :"__RactorLocalSingleton_instance_with_class_id_#{object_id}__"
      end

      def mutex_key
        :"__RactorLocalSingleton_mutex_with_class_id_#{object_id}__"
      end

      def set_instance(val)
        Ractor.current[instance_key] = val
      end

      def set_mutex(val)
        Ractor.current[mutex_key] = val
      end
    end

    def self.module_with_class_methods
      RactorLocalSingletonClassMethods
    end

    extend Singleton::SingletonClassProperties
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                             