ss
#   or the super user (root).
#
# WARNING: You must ensure that *ALL* parent directories cannot be
# moved by other untrusted users.  For example, parent directories
# should not be owned by untrusted users, and should not be world
# writable except when the sticky bit is set.
#
# For details of this security vulnerability, see Perl cases:
#
# - {CVE-2005-0448}[https://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2005-0448].
# - {CVE-2004-0452}[https://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2004-0452].
#
module FileUtils
  VERSION = "1.7.0"

  def self.private_module_function(name)   #:nodoc:
    module_function name
    private_class_method name
  end

  #
  # Returns a string containing the path to the current directory:
  #
  #   FileUtils.pwd # => "/rdoc/fileutils"
  #
  # FileUtils.getwd is an alias for FileUtils.pwd.
  #
  # Related: FileUtils.cd.
  #
  def pwd
    Dir.pwd
  end
  module_function :pwd

  alias getwd pwd
  module_function :getwd

  # Changes the working directory to the given +dir+, which
  # should be {interpretable as a path}[rdoc-ref:FileUtils@Path+Arguments]:
  #
  # With no block given,
  # changes the current directory to the directory at +dir+; returns zero:
  #
  #   FileUtils.pwd # => "/rdoc/fileutils"
  #   FileUtils.cd('..')
  #   FileUtils.pwd # => "/rdoc"
  #   FileUtils.cd('fileutils')
  #
  # With a block given, changes the current directory to the directory
  # at +dir+, calls the block with argument +dir+,
  # and restores the original current directory; returns the block's value:
  #
  #   FileUtils.pwd                                     # => "/rdoc/fileutils"
  #   FileUtils.cd('..') { |arg| [arg, FileUtils.pwd] } # => ["..", "/rdoc