 return t if diff.zero?
        day += diff
        if day > 28 and day > (mday = month_days(off_year, mon))
          if (mon += 1) > 12
            raise ArgumentError, "yday #{yday} out of range"
          end
          day -= mday
        end
        return make_time(date, year, nil, mon, day, hour, min, sec, sec_fraction, zone, now)
      end

      if now and now.respond_to?(:getlocal)
        if off
          now = now.getlocal(off) if now.utc_offset != off
        else
          now = now.getlocal
        end
      end

      usec = nil
      usec = sec_fraction * 1000000 if sec_fraction

      if now
        begin
          break if year; year = now.year
          break if mon; mon = now.mon
          break if day; day = now.day
          break if hour; hour = now.hour
          break if min; min = now.min
          break if sec; sec = now.sec
          break if sec_fraction; usec = now.tv_usec
        end until true
      end

      year ||= 1970
      mon ||= 1
      day ||= 1
      hour ||= 0
      min ||= 0
      sec ||= 0
      usec ||= 0

      if year != off_year
        off = nil
        off = zone_offset(zone, year) if zone
      end

      if off
        year, mon, day, hour, min, sec =
          apply_offset(year, mon, day, hour, min, sec, off)
        t = self.utc(year, mon, day, hour, min, sec, usec)
        force_zone!(t, zone, off)
        t
      else
        self.local(year, mon, day, hour, min, sec, usec)
      end
    end
    private :make_time
    # :startdoc:

    #
    # Takes a string representation of a Time and attempts to parse it
    # using a heuristic.
    #
    # This method **does not** function as a validator.  If the input
    # string does not match valid formats strictly, you may get a
    # cryptic result.  Should consider to use Time.strptime instead
    # of this method as possible.
    #
    #     require 'time'
    #
    #     Time.parse("2010-10-31") #=> 2010-10-31 00:00:00 -0500
    #
    # Any missing pieces of the date are inferred based on the current date.
    #
    #     require 'time'
    #
    #     # assuming the current date is "2011-10-31"
    #     Time.parse("12:00") #=> 2011-10-31 12:00:00 -0500
    #
    # We can change the date used to infer our missing elements by passing a second
    # object that responds to #mon, #day and #year, such as Date, Time or DateTime.
    # We can also use our own object.
    #
    #     require 'time'
    #
    #     class MyDate
    #       attr_reader :mon, :day, :year
    #
    #       def initialize(mon, day, year)
    #         @mon, @day, @year = mon, day, year
    #       end
    #     end
    #
    #     d  = Date.parse("2010-10-28")
    #     t  = Time.parse("2010-10-29")
    #     dt = DateTime.parse("2010-10-30")
    #     md = MyDate.new(10,31,2010)
    #
    #     Time.parse("12:00", d)  #=> 2010-10-28 12:00:00 -0500
    #     Time.parse("12:00", t)  #=> 2010-10-29 12:00:00 -0500
    #     Time.parse("12:00", dt) #=> 2010-10-30 12:00:00 -0500
    #     Time.parse("12:00", md) #=> 2010-10-31 12:00:00 -0500
    #
    # If a block is given, the year described in +date+ is converted
    # by the block.  This is specifically designed for handling two
    # digit years. For example, if you wanted to treat all two digit
    # years prior to 70 as the year 2000+ you could write this:
    #
    #     require 'time'
    #
    #     Time.parse("01-10-31") {|year| year + (year < 70 ? 2000 : 1900)}
    #     #=> 2001-10-31 00:00:00 -0500
    #     Time.parse("70-10-31") {|year| year + (year < 70 ? 2000 : 1900)}
    #     #=> 1970-10-31 00:00:00 -0500
    #
    # If the upper components of the given time are broken or missing, they are
    # supplied with those of +now+.  For the lower components, the minimum
    # values (1 or 0) are assumed if broken or missing.  For example:
    #
    #     require 'time'
    #
    #     # Suppose it is "Thu Nov 29 14:33:20 2001" now and
    #     # your time zone is EST which is GMT-5.
    #     now = Time.parse("Thu Nov 29 14:33:20 2001")
    #     Time.parse("16:30", now)     #=> 2001-11-29 16:30:00 -0500
    #     Time.parse("7/23", now)      #=> 2001-07-23 00:00:00 -0500
    #     Time.parse("Aug 31", now)    #=> 2001-08-31 00:00:00 -0500
    #     Time.parse("Aug 2000", now)  #=> 2000-08-01 00:00:00 -0500
    #
    # Since there are numerous conflicts among locally defined time zone
    # abbreviations all over the world, this method is not intended to
    # understand all of them.  For example, the abbreviation "CST" is
    # used variously as:
    #
    #     -06:00 in America/Chicago,
    #     -05:00 in America/Havana,
    #     +08:00 in Asia/Harbin,
    #     +09:30 in Australia/Darwin,
    #     +10:30 in Australia/Adelaide,
    #     etc.
    #
    # Based on this fact, this method only understands the time zone
    # abbreviations described in RFC 822 and the system time zone, in the
    # order named. (i.e. a definition in RFC 822 overrides the system
    # time zone definition.)  The system time zone is taken from
    # <tt>Time.local(year, 1, 1).zone</tt> and
    # <tt>Time.local(year, 7, 1).zone</tt>.
    # If the extracted time zone abbreviation does not match any of them,
    # it is ignored and the given time is regarded as a local time.
    #
    # ArgumentError is raised if Date._parse cannot extract information from
    # +date+ or if the Time class cannot represent specified date.
    #
    # This method can be used as a fail-safe for other parsing methods as:
    #
    #   Time.rfc2822(date) rescue Time.parse(date)
    #   Time.httpdate(date) rescue Time.parse(date)
    #   Time.xmlschema(date) rescue Time.parse(date)
    #
    # A failure of Time.parse should be checked, though.
    #
    # You must require 'time' to use this method.
    #
    def parse(date, now=self.now)
      comp = !block_given?
      d = Date._parse(date, comp)
      year = d[:year]
      year = yield(year) if year && !comp
      make_time(date, year, d[:yday], d[:mon], d[:mday], d[:hour], d[:min], d[:sec], d[:sec_fraction], d[:zone], now)
    end

    #
    # Works similar to +parse+ except that instead of using a
    # heuristic to detect the format of the input string, you provide
    # a second argument that describes the format of the string.
    #
    # Raises ArgumentError if the date or format is invalid.
    #
    # If a block is given, the year described in +date+ is converted by the
    # block.  For example:
    #
    #   Time.strptime(...) {|y| y < 100 ? (y >= 69 ? y + 1900 : y + 2000) : y}
    #
    # Below is a list of the formatting options:
    #
    # %a :: The abbreviated weekday name ("Sun")
    # %A :: The  full  weekday  name ("Sunday")
    # %b :: The abbreviated month name ("Jan")
    # %B :: The  full  month  name ("January")
    # %c :: The preferred local date and time representation
    # %C :: Century (20 in 2009)
    # %d :: Day of the month (01..31)
    # %D :: \Date (%m/%d/%y)
    # %e :: Day of the month, blank-padded ( 1..31)
    # %F :: Equivalent to %Y-%m-%d (the ISO 8601 date format)
    # %g :: The last two digits of the commercial year
    # %G :: The week-based year according to ISO-8601 (week 1 starts on Monday
    #       and includes January 4)
    # %h :: Equivalent to %b
    # %H :: Hour of the day, 24-hour clock (00..23)
    # %I :: Hour of the day, 12-hour clock (01..12)
    # %j :: Day of the year (001..366)
    # %k :: hour, 24-hour clock, blank-padded ( 0..23)
    # %l :: hour, 12-hour clock, blank-padded ( 0..12)
    # %L :: Millisecond of the second (000..999)
    # %m :: Month of the year (01..12)
    # %M :: Minute of the hour (00..59)
    # %n :: Newline (\n)
    # %N :: Fractional seconds digits
    # %p :: Meridian indicator ("AM" or "PM")
    # %P :: Meridian indicator ("am" or "pm")
    # %r :: time, 12-hour (same as %I:%M:%S %p)
    # %R :: time, 24-hour (%H:%M)
    # %s :: Number of seconds since 1970-01-01 00:00:00 UTC.
    # %S :: Second of the minute (00..60)
    # %t :: Tab character (\t)
    # %T :: time, 24-hour (%H:%M:%S)
    # %u :: Day of the week as a decimal, Monday being 1. (1..7)
    # %U :: Week number of the current year, starting with the first Sunday as
    #       the first day of the first week (00..53)
    # %v :: VMS date (%e-%b-%Y)
    # %V :: Week number of year according to ISO 8601 (01..53)
    # %W :: Week  number  of the current year, starting with the first Monday
    #       as the first day of the first week (00..53)
    # %w :: Day of the week (Sunday is 0, 0..6)
    # %x :: Preferred representation for the date alone, no time
    # %X :: Preferred representation for the time alone, no date
    # %y :: Year without a century (00..99)
    # %Y :: Year which may include century, if provided
    # %z :: \Time zone as hour offset from UTC (e.g. +0900)
    # %Z :: \Time zone name
    # %% :: Literal "%" character
    # %+ :: date(1) (%a %b %e %H:%M:%S %Z %Y)
    #
    #     require 'time'
    #
    #     Time.strptime("2000-10-31", "%Y-%m-%d") #=> 2000-10-31 00:00:00 -0500
    #
    # You must require 'time' to use this method.
    #
    def strptime(date, format, now=self.now)
      d = Date._strptime(date, format)
      raise ArgumentError, "invali