ocessing. You
  # can modify the source in the block.
  #
  # [+src+] a String which contains a C source
  # [+opt+] a String which contains preprocessor options
  def try_cpp(src, opt = "", **opts, &b)
    try_do(src, cpp_command(CPPOUTFILE, opt), **opts, &b) and
      File.file?("#{CONFTEST}.i")
  ensure
    MakeMakefile.rm_f "#{CONFTEST}*"
  end

  alias try_header try_compile

  def cpp_include(header)
    if header
      header = [header] unless header.kind_of? Array
      header.map {|h| String === h ? "#include <#{h}>\n" : h}.join
    else
      ""
    end
  end

  # :startdoc:

  # Sets <tt>$CPPFLAGS</tt> to _flags_ and yields.  If the block returns a
  # falsy value, <tt>$CPPFLAGS</tt> is reset to its previous value, remains
  # set to _flags_ otherwise.
  #
  # [+flags+] a C preprocessor flag as a +String+
  #
  def with_cppflags(flags)
    cppflags = $CPPFLAGS
    $CPPFLAGS = flags.dup
    ret = yield
  ensure
    $CPPFLAGS = cppflags unless ret
  end

  # :nodoc:
  def try_cppflags(flags, werror: true, **opts)
    try_header(MAIN_DOES_NOTHING, flags, werror: werror, **opts)
  end

  # Check whether each given C preprocessor flag is acceptable and append it
  # to <tt>$CPPFLAGS</tt> if so.
  #
  # [+flags+] a C preprocessor flag as a +String+ or an +Array+ of them
  #
  def append_cppflags(flags, **opts)
    Array(flags).each do |flag|
      if checking_for("whether #{flag} is accepted as CPPFLAGS") {
           try_cppflags(flag, **opts)
         }
        $CPPFLAGS << " " << flag
      end
    end
  end

  # Sets <tt>$CFLAGS</tt> to _flags_ and yields.  If the block returns a falsy
  # value, <tt>$CFLAGS</tt> is reset to its previous value, remains set to
  # _flags_ otherwise.
  def with_cflags(flags)
    cflags = $CFLAGS
    $CFLAGS = flags.dup
    ret = yield
  ensure
    $CFLAGS = cflags unless ret
  end

  # :nodoc:
  def try_cflags(flags, werror: true, **opts)
    try_compile(MAIN_DOES_NOTHING, flags, werror: werror, **opts)
  end

  # Sets <tt>$LDFLAGS</tt> to _flags_ and yields.  If the block returns a
  # falsy value, <tt>$LDFLAGS</tt> is reset to its previous value, remains set
  # to _flags_ otherwise