                                                        ustar 00                                                                                                                                                                                                                                                         Usage: syntax_suggest <file> [options]

          Parses a ruby source file and searches for syntax error(s) such as
          unexpected `end', expecting end-of-input.

          Example:

            $ syntax_suggest dog.rb

            # ...

              > 10  defdog
              > 15  end

          ENV options:

            SYNTAX_SUGGEST_RECORD_DIR=<dir>

            Records the steps used to search for a syntax error
            to the given directory

          Options:
        EOM

        opts.version = SyntaxSuggest::VERSION

        opts.on("--help", "Help - displays this message") do |v|
          @io.puts opts
          options[:exit] = true
          @exit_obj.exit
        end

        opts.on("--record <dir>", "Records the steps used to search for a syntax error to the given directory") do |v|
          options[:record_dir] = v
        end

        opts.on("--terminal", "Enable terminal highlighting") do |v|
          options[:terminal] = true
        end

        opts.on("--no-terminal", "Disable terminal highlighting") do |v|
          options[:terminal] = false
        end
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                          ruby/syntax_suggest/scan_history.rb                                                                 0000644                 00000005657 15040313425 0013660 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Scans up/down from the given block
  #
  # You can try out a change, stash it, or commit it to save for later
  #
  # Example:
  #
  #   scanner = ScanHistory.new(code_lines: code_lines, block: block)
  #   scanner.scan(
  #     up: ->(_, _, _) { true },
  #     down: ->(_, _, _) { true }
  #   )
  #   scanner.changed? # => true
  #   expect(scanner.lines).to eq(code_lines)
  #
  #   scanner.stash_changes
  #
  #   expect(scanner.lines).to_not eq(code_lines)
  class ScanHistory
    attr_reader :before_index, :after_index

    def initialize(code_lines:, block:)
      @code_lines = code_lines
      @history = [block]
      refresh_index
    end

    def commit_if_changed
      if changed?
        @history << CodeBlock.new(lines: @code_lines[before_index..after_index])
      end

      self
    end

    # Discards any changes that have not been committed
    def stash_changes
                                                                                 ruby/syntax_suggest/priority_engulf_queue.rb                                                        0000644                 00000002417 15040313425 0015567 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       efore_lines.reverse_each.take_while do |line|
        kw_count += 1 if line.is_kw?
        end_count += 1 if line.is_end?
        up.call(line, kw_count, end_count)
      end.last&.index

      kw_count = 0
      end_count = 0

      down_index = after_lines.each.take_while do |line|
        kw_count += 1 if line.is_kw?
        end_count += 1 if line.is_end?
        down.call(line, kw_count, end_count)
      end.last&.index

      @before_index = if up_index && up_index < @before_index
        up_index
      else
        @before_index
      end

      @after_index = if down_index && down_index > @after_index
        down_index
      else
        @after_index
      end

      self
    end

    def next_up
      return nil if @before_index <= 0

      @code_lines[@before_index - 1]
    end

    def next_down
      return nil if @after_index >= @code_lines.length

      @code_lines[@after_index + 1]
    end

    def lines
      @code_lines[@before_index..@after_index]
    end

    private def before_lines
      @code_lines[0...@before_index] || []
    end

    # Returns an array of all the CodeLines that exist after
    # the currently scanned block
    private def after_lines
      @code_lines[@after_index.next..-1] || []
    end

    private def current
      @history.last
                                                                                                                                                                                                                                                   ruby/syntax_suggest/ripper_errors.rb                                                                0000644                 00000001505 15040313425 0014034 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Keeps track of what elements are in the queue in
  # priority and also ensures that when one element
  # engulfs/covers/eats another that the larger element
  # evicts the smaller element
  class PriorityEngulfQueue
    def initialize
      @queue = PriorityQueue.new
    end

    def to_a
      @queue.to_a
    end

    def empty?
      @queue.empty?
    end

    def length
      @queue.length
    end

    def peek
      @queue.peek
    end

    def pop
      @queue.pop
    end

    def push(block)
      prune_engulf(block)
      @queue << block
      flush_deleted

      self
    end

    private def flush_deleted
      while @queue&.peek&.deleted?
        @queue.pop
      end
    end

    private def prune_engulf(block)
      # If we're about to pop off the same block,                                                                                                                                                                                            ruby/syntax_suggest/clean_document.rb                                                               0000644                 00000021363 15040313425 0014123 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ruby/syntax_suggest/ripper_errors.rb                                                                0000644                 00000001505 15040313425 0014034 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Capture parse errors from ripper
  #
  # Example:
  #
  #   puts RipperErrors.new(" def foo").call.errors
  #   # => ["syntax error, unexpected end-of-input, expecting ';' or '\\n'"]
  class RipperErrors < Ripper
    attr_reader :errors

    # Comes from ripper, called
    # on every parse error, msg
    # is a string
    def on_parse_error(msg)
      @errors ||= []
      @errors << msg
    end

    alias_method :on_alias_error, :on_parse_error
    alias_method :on_assign_error, :on_parse_error
    alias_method :on_class_name_error, :on_parse_error
    alias_method :on_param_error, :on_parse_error
    alias_method :compile_error, :on_parse_error

    def call
      @run_once ||= begin
        @errors = []
        parse
        true
      end
      self
    end
  end
end
                                                                                                                                                                                           ruby/syntax_suggest/clean_document.rb                                                               0000644                 00000021363 15040313425 0014123 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Parses and sanitizes source into a lexically aware document
  #
  # Internally the document is represented by an array with each
  # index containing a CodeLine correlating to a line from the source code.
  #
  # There are three main phases in the algorithm:
  #
  # 1. Sanitize/format input source
  # 2. Search for invalid blocks
  # 3. Format invalid blocks into something meaninful
  #
  # This class handles the first part.
  #
  # The reason this class exists is to format input source
  # for better/easier/cleaner exploration.
  #
  # The CodeSearch class operates at the line level so
  # we must be careful to not introduce lines that look
  # valid by themselves, but when removed will trigger syntax errors
  # or strange behavior.
  #
  # ## Join Trailing slashes
  #
  # Code with a trailing slash is logically treated as a single line:
  #
  #     1 it "code can be split" \
  #     2    "across multiple lines" do
  #
  # In this case removing line 2 would add a syntax error. We get around
  # this by internally joining the two lines into a single "line" object
  #
  # ## Logically Consecutive lines
  #
  # Code that can be broken over multiple
  # lines such as method calls are on different lines:
  #
  #     1 User.
  #     2   where(name: "schneems").
  #     3   first
  #
  # Removing line 2 can introduce a syntax error. To fix this, all lines
  # are joined into one.
  #
  # ## Heredocs
  #
  # A heredoc is an way of defining a multi-line string. They can cause many
  # problems. If left as a single line, Ripper would try to parse the contents
  # as ruby code rather than as a string. Even without this problem, we still
  # hit an issue with indentation
  #
  #    1 foo = <<~HEREDOC
  #    2  "Be yourself; everyone else is already taken.""
  #    3    ― Oscar Wilde
  #    4      puts "I look like ruby code" # but i'm still a heredoc
  #    5 HEREDOC
  #
  # If we didn't join these lines then our algorithm would think that line 4
  # is separate from the rest, has a higher indentation, then look at it first
  # and remove it.
  #
  # If the code evaluates line 5 by itself it will think line 5 is a constant,
  # remove it, and introduce a syntax errror.
  #
  # All of these problems are fixed by joining the whole heredoc into a single
  # line.
  #
  # ## Comments and whitespace
  #
  # Comments can throw off the way the lexer tells us that the line
  # logically belongs with the next line. This is valid ruby but
  # results in a different lex output than before:
  #
  #     1 User.
  #     2   where(name: "schneems").
  #     3   # Comment here
  #     4   first
  #
  # To handle this we can replace comment lines with empty lines
  # and then re-lex the source. This removal and re-lexing preserves
  # line index and document size, but generates an easier to work with
  # document.
  #
  class CleanDocument
    def initialize(source:)
      lines = clean_sweep(source: source)
      @document = CodeLine.from_source(lines.join, lines: lines)
    end

    # Call all of the document "cleaners"
    # and return self
    def call
      join_trailing_slash!
      join_consecutive!
      join_heredoc!

      self
    end

    # Return an array of CodeLines in the
    # document
    def lines
      @document
    end

    # Renders the document back to a string
    def to_s
      @document.join
    end

    # Remove comments
    #
    # replace with empty newlines
    #
    #     source = <<~'EOM'
    #       # Comment 1
    #       puts "hello"
    #       # Comment 2
    #       puts "world"
    #     EOM
    #
    #     lines = CleanDocument.new(source: source).lines
    #     expect(lines[0].to_s).to eq("\n")
    #     expect(lines[1].to_s).to eq("puts "hello")
    #     expect(lines[2].to_s).to eq("\n")
    #     expect(lines[3].to_s).to eq("puts "world")
    #
    # Important: This must be done before lexing.
    #
    # After this change is made, we lex the document because
    # removing comments can change how the doc is parsed.
    #
    # For example:
    #
    #     values = LexAll.new(source: <<~EOM))
    #       User.
    #         # comment
    #         where(name: 'schneems')
    #     EOM
    #     expect(
    #       values.count {|v| v.type == :on_ignored_nl}
    #     ).to eq(1)
    #
    # After the comment is removed:
    #
    #     values = LexAll.new(source: <<~EOM))
    #       User.
    #
    #         where(name: 'schneems')
    #     EOM
    #     expect(
    #      values.count {|v| v.type == :on_ignored_nl}
    #    ).to eq(2)
    #
    def clean_sweep(source:)
      # Match comments, but not HEREDOC strings with #{variable} interpolation
      # https://rubular.com/r/HPwtW9OYxKUHXQ
      source.lines.map do |line|
        if line.match?(/^\s*#([^{].*|)$/)
          $/
        else
          line
        end
      end
    end

    # Smushes all heredoc lines into one line
    #
    #     source = <<~'EOM'
    #       foo = <<~HEREDOC
    #          lol
    #          hehehe
    #       HEREDOC
    #     EOM
    #
    #     lines = CleanDocument.new(source: source).join_heredoc!.lines
    #     expect(lines[0].to_s).to eq(source)
    #     expect(lines[1].to_s).to eq("")
    def join_heredoc!
      start_index_stack = []
      heredoc_beg_end_index = []
      lines.each do |line|
        line.lex.each do |lex_value|
          case lex_value.type
          when :on_heredoc_beg
            start_index_stack << line.index
          when :on_heredoc_end
            start_index = start_index_stack.pop
            end_index = line.index
            heredoc_beg_end_index << [start_index, end_index]
          end
        end
      end

      heredoc_groups = heredoc_beg_end_index.map { |start_index, end_index| @document[start_index..end_index] }

      join_groups(heredoc_groups)
      self
    end

    # Smushes logically "consecutive" lines
    #
    #     source = <<~'EOM'
    #       User.
    #         where(name: 'schneems').
    #         first
    #     EOM
    #
    #     lines = CleanDocument.new(source: source).join_consecutive!.lines
    #     expect(lines[0].to_s).to eq(source)
    #     expect(lines[1].to_s).to eq("")
    #
    # The one known case this doesn't handle is:
    #
    #     Ripper.lex <<~EOM
    #       a &&
    #        b ||
    #        c
    #     EOM
    #
    # For some reason this introduces `on_ignore_newline` but with BEG type
    #
    def join_consecutive!
      consecutive_groups = @document.select(&:ignore_newline_not_beg?).map do |code_line|
        take_while_including(code_line.index..-1) do |line|
          line.ignore_newline_not_beg?
        end
      end

      join_groups(consecutive_groups)
      self
    end

    # Join lines with a trailing slash
    #
    #     source = <<~'EOM'
    #       it "code can be split" \
    #          "across multi                                                                                                                                                                                                                                                                             ruby/syntax_suggest/parse_blocks_from_indent_line.rb                                                0000644                 00000003000 15040313425 0017171 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       , empty lines are placed
    # in the place of the lines that were "joined"
    def join_groups(groups)
      groups.each do |lines|
        line = lines.first

        # Handle the case of multiple groups in a a row
        # if one is already replaced, move on
        next if @document[line.index].empty?

        # Join group into the first line
        @document[line.index] = CodeLine.new(
          lex: lines.map(&:lex).flatten,
          line: lines.join,
          index: line.index
        )

        # Hide the rest of the lines
        lines[1..-1].each do |line|
          # The above lines already have newlines in them, if add more
          # then there will be double newline, use an empty line instead
          @document[line.index] = CodeLine.new(line: "", index: line.index, lex: [])
        end
      end
      self
    end

    # Helper method for grabbing elements from document
    #
    # Like `take_while` except when it stops
    # iterating, it also returns the line
    # that caused it to stop
    def take_while_including(range = 0..-1)
      take_next_and_stop = false
      @document[range].take_while do |line|
        next if take_next_and_stop

        take_next_and_stop = !(yield line)
        true
      end
    end
  end
end
                                                                                                                                                                                                                                                                             ruby/syntax_suggest/capture/falling_indent_lines.rb                                                 0000644                 00000003127 15040313425 0016753 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # This class is responsible for generating initial code blocks
  # that will then later be expanded.
  #
  # The biggest concern when guessing code blocks, is accidentally
  # grabbing one that contains only an "end". In this example:
  #
  #   def dog
  #     begonn # mispelled `begin`
  #     puts "bark"
  #     end
  #   end
  #
  # The following lines would be matched (from bottom to top):
  #
  #   1) end
  #
  #   2) puts "bark"
  #      end
  #
  #   3) begonn
  #      puts "bark"
  #      end
  #
  # At this point it has no where else to expand, and it will yield this inner
  # code as a block
  class ParseBlocksFromIndentLine
    attr_reader :code_lines

    def initialize(code_lines:)
      @code_lines = code_lines
    end

    # Builds blocks from bottom up
    def each_neighbor_block(target_line)
      scan = AroundBlockScan.new(code_lines: code_lines, block: CodeBlock.new(lines: target_line))
        .force_add_empty
        .force_add_hidden
        .scan_while { |line| line.indent >= target_line.indent }

      neighbors = scan.code_block.lines

      block = CodeBlock.new(lines: neighbors)
      if neighbors.length <= 2 || block.valid?
        yield block
      else
        until neighbors.empty?
          lines = [neighbors.pop]
          while (block = CodeBlock.new(lines: lines)) && block.invalid? && neighbors.any?
            lines.prepend neighbors.pop
          end

          yield block if block
        end
      end
    end
  end
end
ruby/syntax_suggest/capture/falling_indent_lines.rb                                                                                                                                                                                                                                                                                                                                                                                                                                                                             ruby/syntax_suggest/capture/before_after_keyword_ends.rb                                            0000644                 00000004244 15040313425 0020005 0                                                                                                    ustar 00                                                                                                                                                                                                                                                          FallingIndentLines.new(
    #       block: block,
    #       code_lines: @code_lines
    #   ).call do |line|
    #     @lines_to_output << line
    #   end
    #
    class FallingIndentLines
      def initialize(code_lines:, block:)
        @lines = nil
        @scanner = ScanHistory.new(code_lines: code_lines, block: block)
        @original_indent = block.current_indent
      end

      def call(&yieldable)
        last_indent_up = @original_indent
        last_indent_down = @original_indent

        @scanner.commit_if_changed
        @scanner.scan(
          up: ->(line, _, _) {
            next true if line.empty?

            if line.indent < last_indent_up
              yieldable.call(line)
              last_indent_up = line.indent
            end
            true
          },
          down: ->(line, _, _) {
            next true if line.empty?

            if line.indent < last_indent_down
              yieldable.call(line)
              last_indent_down = line.indent
            end
            true
          }
        )
        @scanner.stash_changes
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                         ruby/syntax_suggest/capture/before_after_keyword_ends.rb                                            0000644                 00000004244 15040313425 0020005 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  module Capture
    # Shows surrounding kw/end pairs
    #
    # The purpose of showing these extra pairs is du                                                                                                                                                                                                                                                                                                                                                            ruby/syntax_suggest/code_block.rb                                                                   0000644                 00000004203 15040313425 0013221 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       .new(code_lines: code_lines, block: block)
        @original_indent = block.current_indent
      end

      def call
        lines = []

        @scanner.scan(
          up: ->(line, kw_count, end_count) {
            next true if line.empty?
            break if line.indent < @original_indent
            next true if line.indent != @original_indent

            # If we're going up and have one complete kw/end pair, stop
            if kw_count != 0 && kw_count == end_count
              lines << line
              break
            end

            lines << line if line.is_kw? || line.is_end?
            true
          },
          down: ->(line, kw_count, end_count) {
            next true if line.empty?
            break if line.indent < @original_indent
            next true if line.indent != @original_indent

            # if we're going down and have one complete kw/end pair,stop
            if kw_count != 0 && kw_count == end_count
              lines << line
              break
            end

            lin