       # install files which are in current working directory.
        files = files[2..-1]
        len = nil
      else
        # install files which are under the $(srcdir).
        files = File.join(srcdir, files)
        len = srcdir.size
      end
      f = nil
      Dir.glob(files) do |fx|
        f = fx
        f[0..len] = "" if len
        case File.basename(f)
        when *$NONINSTALLFILES
          next
        end
        d = File.dirname(f)
        d.sub!(prefix, "") if prefix
        d = (d.empty? || d == ".") ? dir : File.join(dir, d)
        f = File.join(srcprefix, f) if len
        path[d] << f
      end
      unless len or f
        d = File.dirname(files)
        d.sub!(prefix, "") if prefix
        d = (d.empty? || d == ".") ? dir : File.join(dir, d)
        path[d] << files
      end
    end
    dirs
  end

  def install_rb(mfile, dest, srcdir = nil)
    install_files(mfile, [["lib/**/*.rb", dest, "lib"]], nil, srcdir)
  end

  def append_library(libs, lib) # :no-doc:
    format(LIBARG, lib) + " " + libs
  end

  # Prints messages to $stdout, if verbose mode.
  #
  # Internal use only.
  #
  def message(*s)
    unless Logging.quiet and not $VERBOSE
      printf(*s)
      $stdout.flush
    end
  end

  # This emits a string to stdout that allows users to see the results of the
  # various have* and find* methods as they are tested.
  #
  # Internal use only.
  #
  def checking_for(m, fmt = nil)
    if f = caller_locations(1, 1).first.base_label and /\A\w/ =~ f
      f += ": "
    else
      f = ""
    end
    m = "checking #{/\Acheck/ =~ f ? '' : 'for '}#{m}... "
    message "%s", m
    a = r = nil
    Logging::postpone do
      r = yield
      a = (fmt ? "#{fmt % r}" : r ? "yes" : "no")
      "#{f}#{m}-------------------- #{a}\n\n"
    end
    message "%s\n", a
    Logging::message "--------------------\n\n"
    r
  end

  # Build a message for checking.
  #
  # Internal use only.
  #
  def checking_message(target, place = nil, opt = nil)
    [["in", place], ["with", opt]].inject("#{target}") do |msg, (pre, noun)|
      if noun
        [[:to_str], [:join, ","], [:to_s]].each do |meth, *args|
          if noun.respond_to?(meth)
            break noun = noun.__send__(meth, *args)
          end
        end
        unless noun.empty?
          msg << " #{pre} " unless msg.empty?
          msg << noun
        end
      end
      msg
    end
  end

  # :startdoc:

  # Check whether each given C compiler flag is acceptable and append it
  # to <tt>$CFLAGS</tt> if so.
  #
  # [+flags+] a C compiler flag as a +String+ or an +Array+ of them
  #
  def append_cflags(flags, **opts)
    Array(flags).each do |flag|
      if checking_for("whether #{flag} is accepted as CFLAGS") {
           try_cflags(flag, **opts)
         }
        $CFLAGS << " " << flag
      end
    end
  end

  # Returns whether or not +macro+ is defined either in the common header
  # files or within any +headers+ you provide.
  #
  # Any options you pass to +opt+ are passed along to the compiler.
  #
  def have_macro(macro, headers = nil, opt = "", &b)
    checking_for checking_message(macro, headers, opt) do
      macro_defined?(macro, cpp_include(headers), opt, &b)
    end
  end

  # Returns whether or not the given entry point +func+ can be found within
  # +lib+.  If +func+ is +nil+, the <code>main()</code> entry point is used by
  # default.  If found, it adds the library to list of libraries to be used
  # when linking your extension.
  #
  # If +headers+ are provided, it will include those header files as the
  # header files it looks in when searching for +func+.
  #
  # The real name of the library to be linked can be altered by
  # <code>--with-FOOlib</code> configuration option.
  #
  def have_library(lib, func = nil, headers = nil, opt = "", &b)
    dir_config(lib)
    lib = with_config(lib+'lib', lib)
    checking_for checking_message(func && func.funcall_style, LIBARG%lib, opt) do
      if COMMON_LIBS.include?(lib)
        true
      else
        libs = append_library($libs, lib)
        if try_func(func, libs, headers, opt, &b)
          $libs = libs
          true
        else
          false
        end
      end
    end
  end

  # Returns whether or not the entry point +func+ can be found within the
  # library +lib+ in one of the +paths+ specified, where +paths+ is an array
  # of strings.  If +func+ is +nil+ , then the <code>main()</code> function is
  # used as the entry point.
  #
  # If +lib+ is found, then the path it was found on is added to the list of
  # library paths searched and linked against.
  #
  def find_library(lib, func, *paths, &b)
    dir_config(lib)
    lib = with_config(lib+'lib', lib)
    paths = paths.flat_map {|path| path.split(File::PATH_SEPARATOR)}
    checking_for checking_message(func && func.funcall_style, LIBARG%lib) do
      libpath = $LIBPATH
      libs = append_library($libs, lib)
      begin
        until r = try_func(func, libs, &b) or paths.empty?
          $LIBPATH = libpath | [paths.shift]
        end
        if r
          $libs = libs
          libpath = nil
        end
      ensure
        $LIBPATH = libpath if libpath
      end
      r
    end
  end

  # Returns whether or not the function +func+ can be found in the common
  # header files, or within any +headers+ that you provide.  If found, a macro
  # is passed as a preprocessor constant to the compiler using the function
  # name, in uppercase, prepended with +HAVE_+.
  #
  # To check functions in an additional library, you need to check that
  # library first using <code>have_library()</code>.  The +func+ shall be
  # either mere function name or function name with arguments.
  #
  # For example, if <code>have_func('foo')</code> returned +true+, then the
  # +HAVE_FOO+ preprocessor macro would be passed to the compiler.
  #
  def have_func(func, headers = nil, opt = "", &b)
    checking_for checking_message(func.funcall_style, headers, opt) do
      if try_func(func, $libs, headers, opt, &b)
        $defs << "-DHAVE_#{func.sans_arguments.tr_cpp}"
        true
      else
        false
      end
    end
  end

  # Returns whether or not the variable +var+ can be found in the common
  # header files, or within any +headers+ that you provide.  If found, a macro
  # is passed as a preprocessor constant to the compiler using the variable
  # name, in uppercase, prepended with +HAVE_+.
  #
  # To check variables in an additional library, you need to check that
  # library first using <code>have_library()</code>.
  #
  # For example, if <code>have_var('foo')</code> returned true, then the
  # +HAVE_FOO+ preprocessor macro would be passed to the compiler.
  #
  def have_var(var, headers = nil, opt = "", &b)
    checking_for checking_message(var, headers, opt) do
      if try_var(var, headers, opt, &b)
        $defs.push(format("-DHAVE_%s", var.tr_cpp))
        true
      else
        false
      end
    end
  end

  # Returns whether or not the given +header+ file can be found on your system.
  # If found, a macro is passed as a preprocessor constant to the compiler
  # using the header file name, in uppercase, prepended with +HAVE_+.
  #
  # For example, if <code>have_header('foo.h')</code> returned true, then the
  # +HAVE_FOO_H+ pre