.inspect}")
      suffix &&= suffix.delete(UNUSABLE_CHARS)
      begin
        t = Time.now.strftime("%Y%m%d")
        path = "#{prefix}#{t}-#{$$}-#{RANDOM.next}"\
               "#{n ? %[-#{n}] : ''}#{suffix||''}"
        path = File.join(tmpdir, path)
        yield(path, n, opts, origdir)
      rescue Errno::EEXIST
        n ||= 0
        n += 1
        retry if !max_try or n < max_try
        raise "cannot generate temporary name using `#{basename}' under `#{tmpdir}'"
                                                                                                                                                                                                                                                                                                                                                           ruby/time.rb                                                                                        0000644                 00000057337 15040313427 0007026 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
# date.rb: Written by Tadayoshi Funaba 1998-2011

require 'date_core'

class Date
  VERSION = "3.3.3" # :nodoc:

  # call-seq:
  #   infinite? -> false
  #
  # Returns +false+
  def infinite?
    false
  end

  class Infinity < Numeric # :nodoc:

    def initialize(d=1) @d = d <=> 0 end

    def d() @d end

    protected :d

    def zero?() false end
    def finite?() false end
    def infinite?() d.nonzero? end
    def nan?() d.zero? end

    def abs() self.class.new end

    def -@() self.class.new(-d) end
    def +@() self.class.new(+d) end

    def <=>(other)
      case other
      when Infinity; return d <=> other.d
      when Float::INFINITY; return d <=> 1
      when -Float::INFINITY; return d <=> -1
      when Numeric; return d
      else
        begin
          l, r = other.coerce(self)
          return l <=> r
        rescue NoMethodError
        end
      end
      nil
    end

    def coerce(other)
      case other
      when Numeric; return -d, d
      else
        super
      end
    end

    def to_f
      return 0 if @d == 0
      if @d > 0
        Float::INFINITY
      else
        -Float::INFINITY
      e                                                       ruby/shellwords.rb                                                                                  0000644                 00000017035 15040313425 0010243 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen-string-literal: true
##
# == Manipulates strings like the UNIX Bourne shell
#
# This module manipulates strings according to the word parsing rules
# of the UNIX Bourne shell.
#
# The <tt>shellwords()</tt> function was originally a port of shellwords.pl, but
# modified to conform to {the Shell & Utilities volume of the IEEE Std 1003.1-2008, 2016
# Edition}[http://pubs.opengroup.org/onlinepubs/9699919799/utilities/contents.html]
#
# === Usage
#
# You can use Shellwords to parse a string into a Bourne shell friendly Array.
#
#   require 'shellwords'
#
#   argv = Shellwords.split('three blind "mice"')
#   argv #=> ["three", "blind", "mice"]
#
# Once you've required Shellwords, you can use the #split alias
# String#shellsplit.
#
#   argv = "see how they run".shellsplit
#   argv #=> ["see", "how", "they", "run"]
#
# They treat quotes as special characters, so an unmatched quote will
# cause an ArgumentError.
#
#   argv = "they all ran after the farmer's wife".shellsplit
#        #=> ArgumentError: Unmatched quote: ...
#
# Shellwords also provides methods that do the opposite.
# Shellwords.escape, or its alias, String#shellescape, escapes
# shell metacharacters in a string for use in a command line.
#
#   filename = "special's.txt"
#
#   system("cat -- #{filename.shellescape}")
#   # runs "cat -- special\\'s.txt"
#
# Note the '--'.  Without it, cat(1) will treat the following argument
# as a command line option if it starts with '-'.  It is guaranteed
# that Shellwords.escape converts a string to a form that a Bourne
# shell will parse back to the original string, but it is the
# programmer's responsibility to make sure that passing an arbitrary
# argument to a command does no harm.
#
# Shellwords also comes with a core extension for Array, Array#shelljoin.
#
#   dir = "Funny GIFs"
#   argv = %W[ls -lta -- #{dir}]
#   system(argv.shelljoin + " | less")
#   # runs "ls -lta -- Funny\\ GIFs | less"
#
# You can use this method to build a complete command line out of an
# array of arguments.
#
# === Authors
# * Wakou Aoyama
# * Akinori MUSHA <knu@iDaemons.org>
#
# === Contact
# * Akinori MUSHA <knu@iDaemons.org> (current maintainer)

module Shellwords
  # The version number string.
  VERSION = "0.2.2"

  # Splits a string into an array of tokens in the same way the UNIX
  # Bourne shell does.
  #
  #   argv = Shellwords.split('here are "two words"')
  #   argv #=> ["here", "are", "two words"]
  #
  # +line+ must not contain NUL characters because of nature of
  # +exec+ system call.
  #
  # Note, however, that this is not a command line parser.  Shell
  # metacharacters except for the single and double quotes and
  # backslash are not treated as such.
  #
  #   argv = Shellwords.split('ruby my_prog.rb | less')
  #   argv #=> ["ruby", "my_prog.rb", "|", "less"]
  #
  # String#shellsplit is a shortcut for this function.
  #
  #   argv = 'here are "two words"'.shellsplit
  #   argv #=> ["here", "are", "two words"]
  def shellsplit(line)
    words = []
    field = String.new
    line.scan(/\G\s*(?>([^\0\s\\\'\"]+)|'([^\0\']*)'|"((?:[^\0\"\\]|\\[^\0])*)"|(\\[^\0]?)|(\S))(\s|\z)?/m) do
      |word, sq, dq, esc, garbage, sep|
      if garbage
        b = $~.begin(0)
        line = $~[0]
        line = "..." + line if b > 0
        raise ArgumentError, "#{garbage == "\0" ? 'Nul character' : 'Unmatched quote'} at #{b}: #{line}"
      end
      # 2.2.3 Double-Quotes:
      #
      #   The <backslash> shall retain its special meaning as an
      #   escape character only when followed by one of the following
      #   characters when considered special:
      #
      #   $ ` " \ <newline>
      field << (word || sq || (dq && dq.gsub(/\\([$`"\\\n])/, '\\1')) || esc.gsub(/\\(.)/, '\\1'))
      if sep
        words << field
        field = String.new
      end
    end
    words
  end

  alias shellwords shellsplit

  module_function :shellsplit, :shellwords

  class << self
    alias split shellsplit
  end

  # Escapes a string so that i