      x ? x.respond_to?(:join) ? x.join(",") : x : self
    end
    checking_for checking_message(type, nil, opt), fmt do
      headers.find do |h|
        try_type(type, h, opt, &b)
      end
    end
  end

  # :nodoc:
  # Returns whether or not the constant +const+ is defined.
  #
  # See also +have_const+
  #
  def try_const(const, headers = nil, opt = "", &b)
    const, type = *const
    if try_compile(<<"SRC", opt, &b)
#{cpp_include(headers)}
/*top*/
typedef #{type || 'int'} conftest_type;
conftest_type conftestval = #{type ? '' : '(int)'}#{const};
SRC
      $defs.push(format("-DHAVE_CONST_%s", const.tr_cpp))
      true
    else
      false
    end
  end

  # Returns whether or not the constant +const+ is defined.  You may
  # optionally pass the +type+ of +const+ as <code>[const, type]</code>,
  # such as:
  #
  #   have_const(%w[PTHREAD_MUTEX_INITIALIZER pthread_mutex_t], "pthread.h")
  #
  # You may also pass additional +headers+ to check against in addition to the
  # common header files, and additional flags to +opt+ which are then passed
  # along to the compiler.
  #
  # If found, a macro is passed as a preprocessor constant to the compiler
  # using the type name, in uppercase, prepended with +HAVE_CONST_+.
  #
  # For example, if <code>have_const('foo')</code> returned true, then the
  # +HAVE_CONST_FOO+ preprocessor macro would be passed to the compiler.
  #
  def have_const(const, headers = nil, opt = "", &b)
    checking_for checking_message([*const].compact.join(' '), headers, opt) do
      try_const(const, headers, opt, &b)
    end
  end

  # :stopdoc:
  STRING_OR_FAILED_FORMAT = "%s"
  class << STRING_OR_FAILED_FORMAT # :nodoc:
    def %(x)
      x ? super : "failed"
    end
  end

  def typedef_expr(type, headers)
    typename, member = type.split('.', 2)
    prelude = cpp_include(headers).split(/$/)
    prelude << "typedef #{typename} rbcv_typedef_;\n"
    return "rbcv_typedef_", member, prelude
  end

  def try_signedness(type, member, headers = nil, opts = nil)
    raise ArgumentError, "don't know how to tell signedness of members" if member
    if try_static_assert("(#{type})-1 < 0", headers, opts)
      return -1
    elsif try_static_assert("(#{type})-1 > 0", headers, opts)
      return +1
    end
  end

  # :startdoc:

  # Returns the size of the given +type+.  You may optionally specify
  # additional +headers+ to search in for the +type+.
  #
  # If found, a macro is passed as a preprocessor constant to the compiler
  # using the type name, in uppercase, prepended with +SIZEOF_+, followed by
  # the type name, followed by <code>=X</code> where "X" is the actual size.
  #
  # For example, if <code>check_sizeof('mystruct')</code> returned 12, then
  # the <code>SIZEOF_MYSTRUCT=12</code> preprocessor macro would be passed to
  # the compiler.
  #
  def check_sizeof(type, headers = nil, opts = "", &b)
    typedef, member, prelude = typedef_expr(type, headers)
    prelude << "#{typedef} *rbcv_ptr_;\n"
    prelude = [prelude]
    expr = "sizeof((*rbcv_ptr_)#{"." << member if member})"
    fmt = STRING_OR_FAILED_FORMAT
    checking_for checking_message("size of #{type}", headers), fmt do
      if size = try_constant(expr, prelude, opts, &b)
        $defs.push(format("-DSIZEOF_%s=%s", type.tr_cpp, size))
        size
      end
    end
  end

  # Returns the signedness of the given +type+.  You may optionally specify
  # additional +headers+ to search in for the +type+.
  #
  # If the +type+ is found and is a numeric type, a macro is passed as a
  # preprocessor constant to the compiler using the +type+ name, in uppercase,
  # prepended with +SIGNEDNESS_OF_+, followed by the +type+ name, followed by
  # <code>=X</code> where "X" is positive integer if the +type+ is unsigned
  # and a negative integer if the +type+ is signed.
  #
  # For example, if +size_t+ is defined as unsigned, then
  # <code>check_signedness('size_t')</code> would return +1 and the
  # <code>SIGNEDNESS_OF_SIZE_T=+1</code> preprocessor macro would be passed to
  # the compiler.  The <code>SIGNEDNESS_OF_INT=-1</code> macro would be set
  # for <code>check_signedness('int')</code>
  #
  def check_signedness(type, headers = nil, opts = nil, &b)
    typedef, member, prelude = typedef_expr(type, headers)
    signed = nil
    checking_for("signedness of #{type}", STRING_OR_FAILED_FORMAT) do
      signed = try_signedness(typedef, member, [prelude], opts, &b) or next nil
      $defs.push("-DSIGNEDNESS_OF_%s=%+d" % [type.tr_cpp, signed])
      signed < 0 ? "signed" : "unsigned"
    end
    signed
  end

  # Returns the convertible integer type of the given +type+.  You may
  # optionally specify additional +headers+ to search in for the +type+.
  # _convertible_ means actually the same type, or typedef'd from the same
  # type.
  #
  # If the +type+ is an integer type and the _convertible_ type is found,
  # the following macros are passed as preprocessor constants to the compiler
  # using the +type+ name, in uppercase.
  #
  # * +TYPEOF_+, followed by the +type+ name, followed by <code>=X</code>
  #   where "X" is the found _convertible_ type name.
  # * +TYP2NUM+ and +NUM2TYP+,
  #   where +TYP+ is the +type+ name in uppercase with replacing an +_t+
  #   suffix with "T", followed by <code>=X</code> where "X" is the macro name
  #   to convert +type+ to an Integer object, and vice versa.
  #
  # For example, if +foobar_t+ is defined as unsigned long, then
  # <code>convertible_int("foobar_t")</code> would return "unsigned long", and
  # define these macros:
  #
  #   #define TYPEOF_FOOBAR_T unsigned long
  #   #define FOOBART2NUM ULONG2NUM
  #   #define NUM2FOOBART NUM2ULONG
  #
  def convertible_int(type, headers = nil, opts = nil, &b)
    type, macname = *type
    checking_for("convertible type of #{type}", STRING_OR_FAILED_FORMAT) do
      if UNIVERSAL_INTS.include?(type)
        type
      else
        typedef, member, prelude = typedef_expr(type, headers, &b)
        if member
          prelude << "static rbcv_typedef_ rbcv_var;"
          compat = UNIVERSAL_INTS.find {|t|
            try_static_assert("sizeof(rbcv_var.#{member}) == sizeof(#{t})", [prelude], opts, &b)
          }
        else
          next unless signed = try_signedness(typedef, member, [prelude])
          u = "unsigned " if signed > 0
          prelude << "extern rbcv_typedef_ foo();"
          compat = UNIVERSAL_INTS.find {|t|
            try_compile([prelude, "extern #{u}#{t} foo();"].join("\n"), opts, werror: true, &b)
          }
        end
        if compat
          macname ||= type.sub(/_(?=t\z)/, '').tr_cpp
          conv = (compat == "long long" ? "LL" : compat.upcase)
          compat = "#{u}#{compat}"
          typename = type.tr_cpp
          $defs.push(format("-DSIZEOF_%s=SIZEOF_%s", typename, compat.tr_cpp))
          $defs.