ath)
          envs = ["PKG_CONFIG_PATH"=>[pkg_config_path, ENV["PKG_CONFIG_PATH"]].compact.join(File::PATH_SEPARATOR)]
        end
      end
      if pkgconfig = with_config("#{pkg}-config") and find_executable0(pkgconfig)
      # if and only if package specific config command is given
      elsif ($PKGCONFIG ||=
             (pkgconfig = with_config("pkg-config") {config_string("PKG_CONFIG") || ENV["PKG_CONFIG"] || "pkg-config"}) &&
             find_executable0(pkgconfig) && pkgconfig) and
           xsystem([*envs, $PKGCONFIG, "--exists", pkg])
        # default to pkg-config command
        pkgconfig = $PKGCONFIG
        args = [pkg]
      elsif find_executable0(pkgconfig = "#{pkg}-config")
      # default to package specific config command, as a last resort.
      else
        pkgconfig = nil
      end
      if pkgconfig
        get = proc {|opts|
          opts = Array(opts).map { |o| "--#{o}" }
          opts = xpopen([*envs, pkgconfig, *opts, *args], err:[:child, :out], &:read)
          Logging.open {puts opts.each_line.map{|s|"=> #{s.inspect}"}}
          if $?.success?
            opts = opts.strip
            libarg, libpath = LIBARG, LIBPATHFLAG.strip
            opts = opts.shellsplit.map { |s|
              if s.start_with?('-l')
                libarg % s[2..]
              elsif s.start_with?('-L')
                libpath % s[2..]
              else
                s
              end
            }.quote.join(" ")
            opts
          end
        }
      end
      orig_ldflags = $LDFLAGS
      if get and !options.empty?
        get[options]
      elsif get and try_ldflags(ldflags = get['libs'])
        if incflags = get['cflags-only-I']
          $INCFLAGS << " " << incflags
          cflags = get['cflags-only-other']
        else
          cflags = get['cflags']
        end
        libs = get['libs-only-l']
        if cflags
          $CFLAGS += " " << cflags
          $CXXFLAGS += " " << cflags
        end
        if libs
          ldflags = (Shellwords.shellwords(ldflags) - Shellwords.shellwords(libs)).quote.join(" ")
        else
          libs, ldflags = Shellwords.shellwords(ldflags).partition {|s| s =~ /-l([^ ]+)/ }.map {|l|l.quote.join(" ")}
        end
        $libs += " " << libs

        $LDFLAGS = [orig_ldflags, ldflags].join(' ')
        Logging::message "package configuration for %s\n", pkg
        Logging::message "incflags: %s\ncflags: %s\nldflags: %s\nlibs: %s\n\n",
                         incflags, cflags, ldflags, libs
        [[incflags, cflags].join(' '), ldflags, libs]
      else
        Logging::message "package configuration for %s is not found\n", pkg
        nil
      end
    end
  end

  # :stopdoc:

  def with_destdir(dir)
    dir = dir.sub($dest_prefix_pattern, '')
    /\A\$[\(\{]/ =~ dir ? dir : "$(DESTDIR)"+dir
  end

  # Converts forward slashes to backslashes. Aimed at MS Windows.
  #
  # Internal use only.
  #
  def winsep(s)
    s.tr('/', '\\')
  end

  # Converts native path to format acceptable in Makefile
  #
  # Internal use only.
  #
  if !CROSS_COMPILING
    case CONFIG['build_os']
    when 'mingw32'
      def mkintpath(path)
        # mingw uses make from msys and it needs special care
        # converts from C:\some\path to /C/some/path
        path = path.dup
        path.tr!('\\', '/')
        path.sub!(/\A([A-Za-z]):(?=\/)/, '/\1')
        path
      end
    when 'cygwin', 'msys'
      if CONFIG['target_os'] != 'cygwin'
        def mkintpath(path)
          IO.popen(["cygpath", "-u", path], &:read).chomp
        end
      end
    end
  end
  unless method_defined?(:mkintpath)
    def mkintpath(path)
      path
    end
  end

  def configuration(srcdir)
    mk = []
    verbose = with_config('verbose') ?  "1" : (CONFIG['MKMF_VERBOSE'] || "0")
    vpath = $VPATH.dup
    CONFIG["hdrdir"] ||= $hdrdir
    mk << %{
SHELL = /bin/sh

# V=0 quiet, V=1 verbose.  other values don't work.
V = 1
V0 = $(V:0=)
Q1 = $(V:1=)
Q = $(Q1:0=@)
ECHO1 = $(V:1=@ #{CONFIG['NULLCMD']})
ECHO = $(ECHO1:0=@ echo)
NULLCMD = #{CONFIG['NULLCMD']}

#### Start of system configuration section. ####
#{"top_srcdir = " + $top_srcdir.sub(%r"\A#{Regexp.quote($topdir)}/", "$(topdir)/") if $extmk}
srcdir = #{srcdir.gsub(/\$\((srcdir)\)|\$\{(srcdir)\}/) {mkintpath(CONFIG[$1||$2]).unspace}}
topdir = #{mkintpath(topdir = $extmk ? CONFIG["topdir"] : $topdir).unspace}
hdrdir = #{(hdrdir = CONFIG["hdrdir"]) == topdir ? "$(topdir)" : mkintpath(hdrdir).unspace}
arch_hdrdir = #{mkintpath($arch_hdrdir).unspace}
PATH_SEPARATOR = #{CONFIG['PATH_SEPARATOR']}
VPATH = #{vpath.join(CONFIG['PATH_SEPARATOR'])}
}
    if $extmk
      mk << "RUBYLIB =\n""RUBYOPT = -\n"
    end
    prefix = mkintpath(CONFIG["prefix"])
    if destdir = prefix[$dest_prefix_pattern, 1]
      mk << "\nDESTDIR = #{destdir}\n"
      prefix = prefix[destdir.size..-1]
    end
    mk << "prefix = #{with_destdir(prefix).unspace}\n"
    CONFIG.each do |key, var|
      mk << "#{key} = #{with_destdir(mkintpath(var)).unspace}\n" if /.prefix$/ =~ key
    end
    CONFIG.each do |key, var|
      next if /^abs_/ =~ key
      next if /^(?:src|top(?:_src)?|build|hdr)dir$/ =~ key
      next unless /dir$/ =~ key
      mk << "#{key} = #{with_destdir(var)}\n"
    end
    if !$extmk and !$configure_args.has_key?('--ruby') and
        sep = config_string('BUILD_FILE_SEPARATOR')
      sep = ":/=#{sep}"
    else
      sep = ""
    end
    possible_command = (proc {|s| s if /top_srcdir|tooldir/ !~ s} unless $extmk)
    extconf_h = $extconf_h ? "-DRUBY_EXTCONF_H=\\\"$(RUBY_EXTCONF_H)\\\" " : $defs.join(" ") << " "
    headers = %w[
      $(hdrdir)/ruby.h
      $(hdrdir)/ruby/backward.h
      $(hdrdir)/ruby/ruby.h
      $(hdrdir)/ruby/defines.h
      $(hdrdir)/ruby/missing.h
      $(hdrdir)/ruby/intern.h
      $(hdrdir)/ruby/st.h
      $(hdrdir)/ruby/subst.h
    ]
    headers += $headers
    if RULE_SUBST
      headers.each {|h| h.sub!(/.*/, &RULE_SUBST.method(:%))}
    end
    headers << $config_h
    headers << '$(RUBY_EXTCONF_H)' if $extconf_h
    mk << %{

CC_WRAPPER = #{CONFIG['CC_WRAPPER']}
CC = #{CONFIG['CC']}
CXX = #{CONFIG['CXX']}
LIBRUBY = #{CONFIG['LIBRUBY']}
LIBRUBY_A = #{CONFIG['LIBRUBY_A']}
LIBRUBYARG_SHARED = #$LIBRUBYARG_SHARED
LIBRUBYARG_STATIC = #$LIBRUBYARG_STATIC
empty =
OUTFLAG = #{OUTFLAG}$(empty)
COUTFLAG = #{COUTFLAG}$(empty)
CSRCFLAG = #{CSRCFLAG}$(empty)

RUBY_EXTCONF_H = #{$extconf_h}
cflags   = #{CONFIG['cflags']}
cxxflags = #{CONFIG['cxxflags']}
optflags = #{CONFIG['optflags']}
debugflags = #{CONFIG['debugflags']}
warnflags = #{$warnflags}
cppflags = #{CONFIG['cppflags']}
CCDLFLAGS = #{$static ? '' : CONFIG['CCDLFLAGS']}
CFLAGS   = $(CCDLFLAGS) #$CFLAGS $(ARCH_FLAG)
INCFLAGS = -I. #$INCFLAGS
DEFS     = #{CONFIG['DEFS']}
CPPFLAGS = #{extconf_h}#{$CPPFLAGS}
CXXFLAGS = $(CCDLFLAGS) #$CXXFLAGS $(ARCH_FLAG)
ldflags  = #{$LDFLAGS}
dldflags = #{$DLDFLAGS} #{CONFIG['EXTDLDFLAGS']}
ARCH_FLAG = #{$ARCH_FLAG}
DLDFLAGS = $(ldflags) $(dldflags) $(ARCH_FLAG)
LDSHARED = #{CONFIG['LDSHARED']}
LDSHAREDXX = #{config_string('LDSHAREDXX') || '$(LDSHARED)'}
POSTLINK = #{config_string('POSTLINK', RbConfig::CONFIG)}
AR = #{CONFIG['AR']}
LD = #{CONFIG['LD']}
EXEEXT = #{CONFIG['EXEEXT']}

}
    CONFIG.each do |key, val|
      mk << "#{key} = #{val}\n" if /^RUBY.*NAME/ =~ key
    end
    mk << %{
arch = #{CONFIG['arch']}
sitearch = #{CONFIG['sitearch']}
ruby_version = #{RbConfig::CONFIG['ruby_version']}
ruby = #{$ruby.sub(%r[\A#{Regexp.quote(RbConfig::CONFIG['bindir'])}(?=/|\z)]) {'$(bindir)'}}
RUBY = $(ruby#{sep})
BUILTRUBY = #{if defined?($builtruby) && $builtruby
    $builtruby
  else
    File.join('$(bindir)', CONFIG["RUBY_INSTALL_NAME"] + CONFIG['EXEEXT'])
  end}
ruby_headers = #{headers.join(' ')}

RM = #{config_string('RM', &possible_command) || '$(RUBY) -run -e rm -- -f'}
RM_RF = #{config_string('RMALL', &possible_command) || '$(RUBY) -run -e rm -- -rf'}
RMDIRS = #{config_string('RMDIRS', &possible_command) || '$(RUBY) -run -e rmdir -- -p'}
MAKEDIRS = #{config_string('MAKEDIRS', &possible_command) || '@$(RUBY) -run -e mkdir -- -p'}
INSTALL = #{config_string('INSTALL', &possible_command) || '@$(RUBY) -run -e install -- -vp'}
INSTALL_PROG = #{config_string('INSTALL_PROG') || '$(INSTALL) -m 0755'}
INSTALL_DATA = #{config_string('INSTALL_DATA') || '$(INSTALL) -m 0644'}
COPY = #{config_string('CP', &possible_command) || '@$(RUBY) -run -e cp -- -v'}
TOUCH = exit >

#### End of system configuration section. ####

preload = #{defined?($preload) && $preload ? $preload.join(' ') : ''}
}
    mk
  end

  def timestamp_file(name, target_prefix = nil)
    pat = {}
    name = '$(RUBYARCHDIR)' if name == '$(TARGET_SO_DIR)'
    install_dirs.each do |n, d|
      pat[n] = $` if /\$\(target_prefix\)\z/ =~ d
    end
    name = name.gsub(/\$\((#{pat.keys.join("|")})\)/) {pat[$1]+target_prefix}
    name.sub!(/(\$\((?:site)?arch\))\/*/, '')
    arch = $1 || ''
    name.chomp!('/')
    name = name.gsub(/(\$[({]|[})])|(\/+)|[^-.\w]+/