
      @queue.pop
    end

    def push(block)
      prune_engulf(block)
      @queue << block
      flush_deleted

      self
    end

    private def flush_deleted
      while @queue&.peek&.deleted?
        @queue.pop
      end
    end

    private def prune_engulf(block)
      # If we're about to pop off the same block, we can skip deleting
      # things from the frontier this iteration since we'll get it
      # on the next iteration
      return if @queue.peek && (block <=> @queue.peek) == 1

      if block.starts_at != block.ends_at # A block of size 1 cannot engulf another
        @queue.to_a.each { |b|
          if b.starts_at >= block.starts_at && b.ends_at <= block.ends_at
            b.delete
            true
          end
        }
      end
    end
  end
end
                                                                                                                                                                                                                                                 ruby/syntax_suggest/ripper_errors.rb                                                                0000644                 00000001700 15040313425 0014031 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Capture parse errors from Ripper
  #
  # Prism returns the errors with their messages, but Ripper
  # does not. To get them we must make a custom subclass.
  #
  # Example:
  #
  #   puts RipperErrors.new(" def foo").call.errors
  #   # => ["syntax error, unexpected end-of-input, expecting ';' or '\\n'"]
  class RipperErrors < Ripper
    attr_reader :errors

    # Comes from ripper, called
    # on every parse error, msg
    # is a string
    def on_parse_error(msg)
      @errors ||= []
      @errors << msg
    end

    alias_method :on_alias_error, :on_parse_error
    alias_method :on_assign_error, :on_parse_error
    alias_method :on_class_name_error, :on_parse_error
    alias_method :on_param_error, :on_parse_error
    alias_method :compile_error, :on_parse_error

    def call
      @run_once ||= begin
        @errors = []
        parse
        true
      end
      self
    end
  end
end
                                                                ruby/syntax_suggest/clean_document.rb                                                               0000644                 00000021357 15040313425 0014126 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module SyntaxSuggest
  # Parses and sanitizes source into a lexically aware document
  #
  # Internally the document is represented by an array with each
  # index containing a CodeLine correlating to a line from the source code.
  #
  # There are three main phases in the algorithm:
  #
  # 1. Sanitize/format input source
  # 2. Search for invalid blocks
  # 3. Format invalid blocks into something meaningful
  #
  # This class handles the first part.
  #
  # The reason this class exists is to format input source
  # for better/easier/cleaner exploration.
  #
  # The CodeSearch class operates at the line level so
  # we must be careful to not introduce lines that look
  # valid by themselves, but when removed will trigger syntax errors
  # or strange behavior.
  #
  # ## Join Trailing slashes
  