header, *paths)
    message = checking_message(header, paths)
    header = cpp_include(header)
    checking_for message do
      if try_header(header)
        true
      else
        found = false
        paths.each do |dir|
          opt = "-I#{dir}".quote
          if try_header(header, opt)
            $INCFLAGS << " " << opt
            found = true
            break
          end
        end
        found
      end
    end
  end

  # Returns whether or not the struct of type +type+ contains +member+.  If
  # it does not, or the struct type can't be found, then false is returned.
  # You may optionally specify additional +headers+ in which to look for the
  # struct (in addition to the common header files).
  #
  # If found, a macro is passed as a preprocessor constant to the compiler
  # using the type name and the member name, in uppercase, prepended with
  # +HAVE_+.
  #
  # For example, if <code>have_struct_member('struct foo', 'bar')</code>
  # returned true, then the +HAVE_STRUCT_FOO_BAR+ preprocessor macro would be
  # passed to the compiler.
  #
  # +HAVE_ST_BAR+ is also defined for backward compatibility.
  #
  def have_struct_member(type, member, headers = nil, opt = "", &b)
    checking_for checking_message("#{type}.#{member}", headers) do
      if try_compile(<<"SRC", opt, &b)
#{cpp_include(headers)}
/*top*/
int s = (char *)&((#{type}*)0)->#{member} - (char *)0;
#{MAIN_DOES_NOTHING}
SRC
        $defs.push(format("-DHAVE_%s_%s", type.tr_cpp, member.tr_cpp))
        $defs.push(format("-DHAVE_ST_%s", member.tr_cpp)) # backward compatibility
        true
      else
        false
      end
    end
  end

  # :nodoc:
  # Returns whether or not the static type +type+ is defined.
  #
  # See also +have_type+
  #
  def try_type(type, headers = nil, opt = "", &b)
    if try_compile(<<"SRC", opt, &b)
#{cpp_include(headers)}
/*top*/
typedef #{type} conftest_type;
int conftestval[sizeof(conftest_type)?1:-1];
SRC
      $defs.push(format("-DHAVE_TYPE_%s", type.tr_cpp))
      true
    else
      false
    end
  end

  # Returns whether or not the static type +type+ is defined.  You may
  # optionally pass additional +headers+ to check against in addition to the
  # common header files.
  #
  # You may also pass additional flags to +opt+ which are then passed along to
  # the compiler.
  #
  # If found, a macro is passed as a preprocessor constant to the compiler
  # using the type name, in uppercase, prepended with +HAVE_