if the target is set to "foo", then the user
  # could use the <code>--with-foo-dir=prefix</code>,
  # <code>--with-foo-include=dir</code> and
  # <code>--with-foo-lib=dir</code> command line options to tell where
  # to search for header/library files.
  #
  # You may pass along additional parameters to specify default
  # values.  If one is given it is taken as default +prefix+, and if
  # two are given they are taken as "include" and "lib" defaults in
  # that order.
  #
  # In any case, the return value will be an array of determined
  # "include" and "lib" directories, either of which can be nil if no
  # corresponding command line option is given when no default value
  # is specified.
  #
  # Note that dir_config only adds to the list of places to search for
  # libraries and include files.  It does not link the libraries into your
  # application.
  #
  def dir_config(target, idefault=nil, ldefault=nil)
    key = [target, idefault, ldefault].compact.join("\0")
    if conf = $config_dirs[key]
      return conf
    end

    if dir = with_config(target + "-dir", (idefault unless ldefault))
      defaults = Array === dir ? dir : dir.split(File::PATH_SEPARATOR)
      idefault = ldefault = nil
    end

    idir = with_config(target + "-include", idefault)
    if conf = $ar