 "#$INCFLAGS",
                                  'CPPFLAGS' => "#$CPPFLAGS",
                                  'CFLAGS' => "#$CFLAGS",
                                  'ARCH_FLAG' => "#$ARCH_FLAG",
                                  'LDFLAGS' => "#$LDFLAGS #{ldflags}",
                                  'LOCAL_LIBS' => "#$LOCAL_LIBS #$libs",
                                  'LIBS' => "#{librubyarg} #{opt} #$LIBS")
    conf['LIBPATH'] = libpathflag(libpath.map {|s| RbConfig::expand(s.dup, conf)})
    conf
  end

  def link_command(ldflags, *opts)
    conf = link_config(ldflags, *opts)
    RbConfig::expand(TRY_LINK.dup, conf)
  end

  def cc_config(opt="")
    conf = RbConfig::CONFIG.merge('hdrdir' => $hdrdir.quote, 'srcdir' => $srcdir.quote,
                                  'arch_hdrdir' => $arch_hdrdir.quote,
                                  'top_srcdir' => $top_srcdir.quote)
    conf
  end

  def cc_command(opt="")
    conf = cc_config(opt)
    RbConfig::expand("$(CC) #$INCFLAGS #$CPPFLAGS #$CFLAGS #$ARCH_FLAG #{opt} -c #{CONFTEST_C}",
                     conf)
  end

  def cpp_command(outfile, opt="")
    conf = cc_config(opt)
    if $universal and (arch_flag = conf['ARCH_FLAG']) and !arch_flag.empty?
      conf['ARCH_FLAG'] = arch_flag.gsub(/(?:\G|\s)-arch\s+\S+/, '')
    end
    RbConfig::expand("$(CPP) #$INCFLAGS #$CPPFLAGS #$CFLAGS #{opt} #{CONFTEST_C} #{outfile}",
                     conf)
  end

  def libpathflag(libpath=$DEFLIBPATH|$LIBPATH)
    libpathflags = nil
    libpath.map{|x|
      case x
      when "$(topdir)", /\A\./
        LIBPATHFLAG
      else
        libpathflags ||= [LIBPATHFLAG, RPATHFLAG].grep(/\S/).join(" ")
      end % x.quote
    }.join(" ")
  end

  def werror_flag(opt = nil)
    config_string("WERRORFLAG") {|flag| opt = opt && !opt.empty? ? "#{opt} #{flag}" : flag}
    opt
  end

  def with_werror(opt, opts = nil)
    opt = werror_flag(opt) if opts and (opts = opts.dup).delete(:werror)
    yield(opt, opts)
  end

  def try_link0(src, opt = "", ldflags: "", **opts, &b) # :nodoc:
    exe = CONFTEST+$EXEEXT
    cmd = link_command(ldflags, opt)
    if $universal
      require 'tmpdir'
      Dir.mktmpdir("mkmf_", oldtmpdir = ENV["TMPDIR"]) do |tmpdir|
        begin
          ENV["TMPDIR"] = tmpdir
          try_do(src, cmd, **opts, &b)
        ensure
          ENV["TMPDIR"] = oldtmpdir
        end
      end
    else
      try_do(src, cmd, **opts, &b)
    end and File.executable?(exe) or return nil
    exe
  ensure
    MakeMakefile.rm_rf(*Dir["#{CONFTEST}*"]-[exe])
  end

  # Returns whether or not the +src+ can be compiled as a C source and linked
  # with its depending libraries successfully.  +opt+ is passed to the linker
  # as options. Note that <tt>$CFLAGS</tt> and <tt>$LDFLAGS</tt> are also
  # passed to the linker.
  #
  # If a block given, it is called with the source before compilation. You can
  # modify the source in the block.
  #
  # [+src+] a String which contains a C source
  # [+opt+] a String which contains linker options
  def try_link(src, opt = "", **opts, &b)
    exe = try_link0(src, opt, **opts, &b) or return false
    Mak