ruby/did_you_mean/tree_spell_checker.rb                                                             0000644                 00000005471 15040313430 0014330 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module DidYouMean
  # spell checker for a dictionary that has a tree
  # structure, see doc/tree_spell_checker_api.md
  class TreeSpellChecker
    attr_reader :dictionary, :separator, :augment

    def initialize(dictionary:, separator: '/', augment: nil)
      @dictionary = dictionary
      @separator = separator
      @augment = augment
    end

    def correct(input)
      plausibles = plausible_dimensions(input)
      return fall_back_to_normal_spell_check(input) if plausibles.empty?

      suggestions = find_suggestions(input, plausibles)
      return fall_back_to_normal_spell_check(input) if suggestions.empty?

      suggestions
    end

    def dictionary_without_leaves
      @dictionary_without_leaves ||= dictionary.map { |word| word.split(separator)[0..-2] }.uniq
    end

    def tree_depth
      @tree_depth ||= dictionary_without_leaves.max { |a, b| a.size <=> b.size }.size
    end

    def dimensions
      @dimensions ||= tree_depth.times.map do |index|
                        dictionary_without_leaves.map { |element| element[index] }.compact.uniq
                      end
    end

    def find_leaves(path)
      path_with_separator = "#{path}#{separator}"

      dictionary
        .select {|str| str.include?(path_with_separator) }
        .map {|str| str.gsub(path_with_separator, '') }
    end

    def plausible_dimensions(input)
      input.split(separator)[0..-2]
        .map
        .with_index { |element, index| correct_element(dimensions[index], element) if dimensions[index] }
        .compact
    end

    def possible_paths(states)
      states.map { |state| state.join(separator) }
    end

    private

    def find_suggestions(input, plausibles)
      states = plausibles[0].product(*plausibles[1..-1])
      paths  = possible_paths(states)
      leaf   = input.split(separator).last

      find_ideas(paths, leaf)
    end

    def fall_back_to_normal_spell_check(input)
      return [] unless augment

      ::DidYouMean::SpellChecker.new(dictionary: dictionary).correct(input)
    end

    def find_ideas(paths, leaf)
      paths.flat_map do |path|
        names = find_leaves(path)
        ideas = correct_element(names, leaf)

        ideas_to_paths(ideas, leaf, names, path)
      end.compact
    end

    def ideas_to_paths(ideas, leaf, names, path)
      if ideas.empty?
        nil
      elsif names.include?(leaf)
        ["#{path}#{separator}#{leaf}"]
      else
        ideas.map {|str| "#{path}#{separator}#{str}" }
      end
    end

    def correct_element(names, element)
      return names if names.size == 1

      str = normalize(element)

      return [str] if names.include?(str)

      ::DidYouMean::SpellChecker.new(dictionary: names).correct(str)
    end

    def normalize(str)
      str.downcase!
      str.tr!('@', ' ') if str.include?('@')
      str
    end
  end
end
                                                                                                                                                                                                       ruby/did_you_mean/verbose.rb                                                                        0000644                 00000000211 15040313430 0012136 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       warn "The verbose formatter has been removed and now `require 'did_you_mean/verbose'` has no effect. Please " \
     "remove this call."
                                                                                                                                                                                                                                                                                                                                                                                       ruby/did_you_mean/core_ext/name_error.rb                                                            0000644                 00000002420 15040313430 0014436 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       module DidYouMean
  module Correctable
    if Exception.method_defined?(:detailed_message)
      # just for compatibility
      def original_message
        # we cannot use alias here because
        to_s
      end

      def detailed_message(highlight: true, did_you_mean: true, **)
        msg = super.dup

        return msg unless did_you_mean

        suggestion = DidYouMean.formatter.message_for(corrections)

        if highlight
          suggestion = suggestion.gsub(/.+/) { "\e[1m" + $& + "\e[m" }
        end

        msg << suggestion
        msg
      rescue
        super
      end
    else
      SKIP_TO_S_FOR_SUPER_LOOKUP = true
      private_constant :SKIP_TO_S_FOR_SUPER_LOOKUP

      def original_message
        meth = method(:to_s)
        while meth.owner.const_defined?(:SKIP_TO_S_FOR_SUPER_LOOKUP)
          meth = meth.super_method
        end
        meth.call
      end

      def to_s
        msg = super.dup
        suggestion = DidYouMean.formatter.message_for(corrections)

        msg << suggestion if !msg.include?(suggestion)
        msg
      rescue
        super
      end
    end

    def corrections
      @corrections ||= spell_checker.corrections
    end

    def spell_checker
      DidYouMean.spell_checkers[self.class.to_s].new(self)
    end
  end
end
                                                                                                                                                                                                                                                ruby/did_you_mean/experimental.rb                                                                   0000644                 00000000213 15040313430 0013170 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       warn "Experimental features in the did_you_mean gem has been removed " \
     "and `require \"did_you_mean/experimental\"' has no effect."
                                                                                                                                                                                                                                                                                                                                                                                     ruby/mutex_m.rb                                                                                     0000644                 00000004517 15040313431 0007531 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       BF\u3099",
    "\u30C2"=>"\u30C1\u3099",
    "\u30C5"=>"\u30C4\u3099",
    "\u30C7"=>"\u30C6\u3099",
    "\u30C9"=>"\u30C8\u3099",
    "\u30D0"=>"\u30CF\u3099",
    "\u30D1"=>"\u30CF\u309A",
    "\u30D3"=>"\u30D2\u3099",
    "\u30D4"=>"\u30D2\u309A",
    "\u30D6"=>"\u30D5\u3099",
    "\u30D7"=>"\u30D5\u309A",
    "\u30D9"=>"\u30D8\u3099",
    "\u30DA"=>"\u30D8\u309A",
    "\u30DC"=>"\u30DB\u3099",
    "\u30DD"=>"\u30DB\u309A",
    "\u30F4"=>"\u30A6\u3099",
    "\u30F7"=>"\u30EF\u3099",
    "\u30F8"=>"\u30F0\u3099",
    "\u30F9"=>"\u30F1\u3099",
    "\u30FA"=>"\u30F2\u3099",
    "\u30FE"=>"\u30FD\u3099",
    "\uF900"=>"\u8C48",
    "\uF901"=>"\u66F4",
    "\uF902"=>"\u8ECA",
    "\uF903"=>"\u8CC8",
    "\uF904"=>"\u6ED1",
    "\uF905"=>"\u4E32",
    "\uF906"=>"\u53E5",
    "\uF907"=>"\u9F9C",
    "\uF908"=>"\u9F9C",
    "\uF909"=>"\u5951",
    "\uF90A"=>"\u91D1",
    "\uF90B"=>"\u5587",
    "\uF90C"=>"\u5948",
    "\uF90D"=>"\u61F6",
    "\uF90E"=>"\u7669",
    "\uF90F"=>"\u7F85",
    "\uF910"=>"\u863F",
    "\uF911"=>"\u87BA",
    "\uF912"=>"\u88F8",
    "\uF913"=>"\u908F",
    "\uF914"=>"\u6A02",
    "\uF915"=>"\u6D1B",
    "\uF916"=>"\u70D9",
    "\uF917"=>"\u73DE",
    "\uF918"=>"\u843D",
    "\uF919"=>"\u916A",
    "\uF91A"=>"\u99F1",
    "\uF91B"=>"\u4E82",
    "\uF91C"=>"\u5375",
    "\uF91D"=>"\u6B04",
    "\uF91E"=>"\u721B",
    "\uF91F"=>"\u862D",
    "\uF920"=>"\u9E1E",
    "\uF921"=>"\u5D50",
    "\uF922"=>"\u6FEB",
    "\uF923"=>"\u85CD",
    "\uF924"=>"\u8964",
    "\uF925"=>"\u62C9",
    "\uF926"=>"\u81D8",
    "\uF927"=>"\u881F",
    "\uF928"=>"\u5ECA",
    "\uF929"=>"\u6717",
    "\uF92A"=>"\u6D6A",
    "\uF92B"=>"\u72FC",
    "\uF92C"=>"\u90CE",
    "\uF92D"=>"\u4F86",
    "\uF92E"=>"\u51B7",
    "\uF92F"=>"\u52DE",
    "\uF930"=>"\u64C4",
    "\uF931"=>"\u6AD3",
    "\uF932"=>"\u7210",
    "\uF933"=>"\u76E7",
    "\uF934"=>"\u8001",
    "\uF935"=>"\u8606",
    "\uF936"=>"\u865C",
    "\uF937"=>"\u8DEF",
    "\uF938"=>"\u9732",
    "\uF939"=>"\u9B6F",
    "\uF93A"=>"\u9DFA",
    "\uF93B"=>"\u788C",
    "\uF93C"=>"\u797F",
    "\uF93D"=>"\u7DA0",
    "\uF93E"=>"\u83C9",
    "\uF93F"=>"\u9304",
    "\uF940"=>"\u9E7F",
    "\uF941"=>"\u8AD6",
    "\uF942"=>"\u58DF",
    "\uF943"=>"\u5F04",
    "\uF944"=>"\u7C60",
    "\uF945"=>"\u807E",
    "\uF946"=>"\u7262",
    "\uF947"=>"\u78CA",
    "\uF948"=>"\u8CC2",
    "\uF949"=>"\u96F                                                                                                                                                                                 ruby/set/sorted_set.rb                                                                              0000644                 00000000305 15040313431 0011010 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       begin
  require 'sorted_set'
rescue ::LoadError
  raise "The `SortedSet` class has been extracted from the `set` library. " \
        "You must use the `sorted_set` gem or other alternatives."
end
                                                                                                                                                                                                                                                                                                                           ruby/bigdecimal.rb                                                                                  0000644                 00000000030 15040313431 0010115 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       \uF991"=>"\u649A",
    "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ruby/open3/version.rb                                                                               0000644                 00000000045 15040313431 0010554 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       module Open3
  VERSION = "0.2.1"
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ruby/prettyprint.rb                                                                                 0000644                 00000037666 15040313431 0010472 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
#
# This class implements a pretty printing algorithm. It finds line breaks and
# nice indentations for grouped structure.
#
# By default, the class assumes that primitive elements are strings and each
# byte in the strings have single column in width. But it can be used for
# other situations by giving suitable arguments for some methods:
# * newline object and space generation block for PrettyPrint.new
# * optional width argument for PrettyPrint#text
# * PrettyPrint#breakable
#
# There are several candidate uses:
# * text formatting using proportional fonts
# * multibyte characters which has columns different to number of bytes
# * non-string formatting
#
# == Bugs
# * Box based formatting?
# * Other (better) model/algorithm?
#
# Report any bugs at http://bugs.ruby-lang.org
#
# == References
# Christian Lindig, Strictly Pretty, March 2000,
# https://lindig.github.io/papers/strictly-pretty-2000.pdf
#
# Philip Wadler, A prettier printer, March 1998,
# https://homepages.inf.ed.ac.uk/wadler/topics/language-design.html#prettier
#
# == Author
# Tanaka Akira <akr@fsij.org>
#
class PrettyPrint

  VERSION = "0.2.0"

  # This is a convenience method which is same as follows:
  #
  #   begin
  #     q = PrettyPrint.new(output, maxwidth, newline, &genspace)
  #     ...
  #     q.flush
  #     output
  #   end
  #
  def PrettyPrint.format(output=''.dup, maxwidth=79, newline="\n", genspace=lambda {|n| ' ' * n})
    q = PrettyPrint.new(output, maxwidth, newline, &genspace)
    yield q
    q.flush
    output
  end

  # This is similar to PrettyPrint::format but the result has no breaks.
  #
  # +maxwidth+, +newline+ and +genspace+ are ignored.
  #
  # The invocation of +breakable+ in the block doesn't break a line and is
  # treated as just an invocation of +text+.
  #
  def PrettyPrint.singleline_format(output=''.dup, maxwidth=nil, newline=nil, genspace=nil)
    q = SingleLine.new(output)
    yield q
    output
  end

  # Creates a buffer for pretty printing.
  #
  # +output+ is an output target. If it is not specified, '' is assumed. It
  # should have a << method which accepts the first argument +obj+ of
  # PrettyPrint#text, the first argument +sep+ of PrettyPrint#breakable, the
  # first argument +newline+ of PrettyPrint.new, and the result of a given
  # block for PrettyPrint.new.
  #
  # +maxwidth+ specifies maximum line length. If it is not specified, 79 is
  # assumed. However actual outputs may overflow +maxwidth+ if long
  # non-breakable texts are provided.
  #
  # +newline+ is used for line breaks. "\n" is used if it is not specified.
  #
  # The block is used to generate spaces. {|width| ' ' * width} is used if it
  # is not given.
  #
  def initialize(output=''.dup, maxwidth=79, newline="\n", &genspace)
    @output = output
    @maxwidth = maxwidth
    @newline = newline
    @genspace = genspace || lambda {|n| ' ' * n}

    @output_width = 0
    @buffer_width = 0
    @buffer = []

    root_group = Group.new(0)
    @group_stack = [root_group]
    @group_queue = GroupQueue.new(root_group)
    @indent = 0
  end

  # The output object.
  #
  # This defaults to '', and should accept the << method
  attr_reader :output

  # The maximum width of a line, before it is separated in to a newline
  #
  # This defaults to 79, and should be an Integer
  attr_reader :maxwidth

  # The value that is appended to +output+ to add a new line.
  #
  # This defaults to "\n", and should be String
  attr_reader :newline

  # A lambda or Proc, that takes one argument, of an Integer, and returns
  # the corresponding number of spaces.
  #
  # By default this is:
  #   lambda {|n| ' ' * n}
  attr_reader :genspace

  # The number of spaces to be indented
  attr_reader :indent

  # The PrettyPrint::GroupQueue of groups in stack to be pretty printed
  attr_reader :group_queue

  # Returns the group most recently added to the stack.
  #
  # Contrived example:
  #   out = ""
  #   => ""
  #   q = PrettyPrint.new(out)
  #   => #<PrettyPrint:0x82f85c0 @output="", @maxwidth=79, @newline="\n", @genspace=#<Proc:0x82f8368@/home/vbatts/.rvm/rubies/ruby-head/lib/ruby/2.0.0/prettyprint.rb:82 (lambda)>, @output_width=0, @buffer_width=0, @buffer=[], @group_stack=[#<PrettyPrint::Group:0x82f8138 @depth=0, @breakables=[], @break=false>], @group_queue=#<PrettyPrint::GroupQueue:0x82fb7c0 @queue=[[#<PrettyPrint::Group:0x82f8138 @depth=0, @breakables=[], @break=false>]]>, @indent=0>
  #   q.group {
  #     q.text q.current_group.inspect
  #     q.text q.newline
  #     q.group(q.current_group.depth + 1) {
  #       q.text q.current_group.inspect
  #       q.text q.newline
  #       q.group(q.current_group.depth + 1) {
  #         q.text q.current_group.inspect
  #         q.text q.newline
  #         q.group(q.current_group.depth + 1) {
  #           q.text q.current_group.inspect
  #           q.text q.newline
  #         }
  #       }
  #     }
  #   }
  #   => 284
  #    puts out
  #   #<PrettyPrint::Group:0x8354758 @depth=1, @breakables=[], @break=false>
  #   #<PrettyPrint::Group:0x8354550 @depth=2, @breakables=[], @break=false>
  #   #<PrettyPrint::Group:0x83541cc @depth=3, @breakables=[], @break=false>
  #   #<PrettyPrint::Group:0x8347e54 @depth=4, @breakables=[], @break=false>
  def current_group
    @group_stack.last
  end

  # Breaks the buffer into lines that are shorter than #maxwidth
  def break_outmost_groups
    while @maxwidth < @output_width + @buffer_width
      return unless group = @group_queue.deq
      until group.breakables.empty?
        data = @buffer.shift
        @output_width = data.output(@output, @output_width)
        @buffer_width -= data.width
      end
      while !@buffer.empty? && Text === @buffer.first
        text = @buffer.shift
        @output_width = text.output(@output, @output_width)
        @buffer_width -= text.width
      end
    end
  end

  # This adds +obj+ as a text of +width+ columns