='', close_obj='', open_width=open_obj.length, close_width=close_obj.length)
    text open_obj, open_width
    group_sub {
      nest(indent) {
        yield
      }
    }
    text close_obj, close_width
  end

  # Takes a block and queues a new group that is indented 1 level further.
  def group_sub
    group = Group.new(@group_stack.last.depth + 1)
    @group_stack.push group
    @group_queue.enq group
    begin
      yield
    ensure
      @group_stack.pop
      if group.breakables.empty?
        @group_queue.delete group
      end
    end
  end

  # Increases left margin after newline with +indent+ for line breaks added in
  # the block.
  #
  def nest(indent)
    @indent += indent
    begin
      yield
    ensure
      @indent -= indent
    end
  end

  # outputs buffered data.
  #
  def flush
    @buffer.each {|data|
      @output_width = data.output(@output, @output_width)
    }
    @buffer.clear
    @buffer_width = 0
  end

  # The Text class is the means by which to collect strings from objects.
  #
  # This class is intended for internal use of the PrettyPrint buffers.
  class Text # :nodoc:

    # Creates a new text object.
    #
    # This constructor takes no arguments.
    #
    # The workflow is to append a PrettyPrint::Text object to the buffer, and
    # being able to call the buffer.last() to reference it.
    #
    # As there are objects, use PrettyPrint::Text#add to include the objects
    # and the width to utilized by the String version of this object.
    def initialize
      @objs = []
      @width = 0
    end

    # The total width of the objects included in this Text object.
    attr_reader :width

    # Render the String text of the objects that have been added to this Text object.
    #
    # Output the text to +out+, and increment the width to +output_width+
    def output(out, output_width)
      @objs.each {|obj| out << obj}
      output_width + @width
    end

    # Include +obj+ in the objects to be pretty printed, and increment
    # this Text object's total width by +width+
    def add(obj, width)
      @objs << obj
      @width += width
    end
  end

  # The Breakable class is used for breaking up object information
  #
  # This class is intended for internal use of the PrettyPrint buffers.
  class Breakable # :nodoc:

